/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.WNafPreCompInfo;

class WNafMultiplier
implements ECMultiplier {
    WNafMultiplier() {
    }

    public byte[] windowNaf(byte by, BigInteger bigInteger) {
        Object object;
        byte[] byArray = new byte[bigInteger.bitLength() + 1];
        short s2 = (short)(1 << by);
        BigInteger bigInteger2 = BigInteger.valueOf(s2);
        int n2 = 0;
        int n3 = 0;
        while (bigInteger.signum() > 0) {
            if (bigInteger.testBit(0)) {
                object = bigInteger.mod(bigInteger2);
                byArray[n2] = ((BigInteger)object).testBit(by - 1) ? (byte)(((BigInteger)object).intValue() - s2) : (byte)((BigInteger)object).intValue();
                bigInteger = bigInteger.subtract(BigInteger.valueOf(byArray[n2]));
                n3 = n2;
            } else {
                byArray[n2] = 0;
            }
            bigInteger = bigInteger.shiftRight(1);
            ++n2;
        }
        object = new byte[++n3];
        System.arraycopy(byArray, 0, object, 0, n3);
        return object;
    }

    public ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger, PreCompInfo preCompInfo) {
        int n2;
        Object[] objectArray;
        int n3;
        byte by;
        WNafPreCompInfo wNafPreCompInfo = preCompInfo != null && preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : new WNafPreCompInfo();
        int n4 = bigInteger.bitLength();
        if (n4 < 13) {
            by = 2;
            n3 = 1;
        } else if (n4 < 41) {
            by = 3;
            n3 = 2;
        } else if (n4 < 121) {
            by = 4;
            n3 = 4;
        } else if (n4 < 337) {
            by = 5;
            n3 = 8;
        } else if (n4 < 897) {
            by = 6;
            n3 = 16;
        } else if (n4 < 2305) {
            by = 7;
            n3 = 32;
        } else {
            by = 8;
            n3 = 127;
        }
        int n5 = 1;
        ECPoint[] eCPointArray = wNafPreCompInfo.getPreComp();
        ECPoint eCPoint2 = wNafPreCompInfo.getTwiceP();
        if (eCPointArray == null) {
            eCPointArray = new ECPoint[]{eCPoint};
        } else {
            n5 = eCPointArray.length;
        }
        if (eCPoint2 == null) {
            eCPoint2 = eCPoint.twice();
        }
        if (n5 < n3) {
            objectArray = eCPointArray;
            eCPointArray = new ECPoint[n3];
            System.arraycopy(objectArray, 0, eCPointArray, 0, n5);
            for (n2 = n5; n2 < n3; ++n2) {
                eCPointArray[n2] = eCPoint2.add(eCPointArray[n2 - 1]);
            }
        }
        objectArray = this.windowNaf(by, bigInteger);
        n2 = objectArray.length;
        ECPoint eCPoint3 = eCPoint.getCurve().getInfinity();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            eCPoint3 = eCPoint3.twice();
            if (objectArray[i2] == false) continue;
            eCPoint3 = objectArray[i2] > 0 ? eCPoint3.add(eCPointArray[(objectArray[i2] - true) / 2]) : eCPoint3.subtract(eCPointArray[(-objectArray[i2] - true) / 2]);
        }
        wNafPreCompInfo.setPreComp(eCPointArray);
        wNafPreCompInfo.setTwiceP(eCPoint2);
        eCPoint.setPreCompInfo(wNafPreCompInfo);
        return eCPoint3;
    }
}

