/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GroovyRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class CachedConstructor
extends ParameterTypes {
    CachedClass clazz;
    public final Constructor cachedConstructor;

    public CachedConstructor(CachedClass clazz, final Constructor c2) {
        this.cachedConstructor = c2;
        this.clazz = clazz;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    c2.setAccessible(true);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public CachedConstructor(Constructor c2) {
        this(ReflectionCache.getCachedClass(c2.getDeclaringClass()), c2);
    }

    protected Class[] getPT() {
        return this.cachedConstructor.getParameterTypes();
    }

    public static CachedConstructor find(Constructor constructor) {
        CachedConstructor[] constructors = ReflectionCache.getCachedClass(constructor.getDeclaringClass()).getConstructors();
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            CachedConstructor cachedConstructor = constructors[i2];
            if (!cachedConstructor.cachedConstructor.equals(constructor)) continue;
            return cachedConstructor;
        }
        throw new RuntimeException("Couldn't find method: " + constructor);
    }

    public Object doConstructorInvoke(Object[] argumentArray) {
        argumentArray = this.coerceArgumentsToClasses(argumentArray);
        return this.invoke(argumentArray);
    }

    public Object invoke(Object[] argumentArray) {
        Constructor constr = this.cachedConstructor;
        try {
            return constr.newInstance(argumentArray);
        }
        catch (InvocationTargetException e2) {
            throw e2.getCause() instanceof RuntimeException ? (RuntimeException)e2.getCause() : new InvokerInvocationException(e2);
        }
        catch (IllegalArgumentException e3) {
            throw CachedConstructor.createExceptionText("failed to invoke constructor: ", constr, argumentArray, e3, false);
        }
        catch (IllegalAccessException e4) {
            throw CachedConstructor.createExceptionText("could not access constructor: ", constr, argumentArray, e4, false);
        }
        catch (Exception e5) {
            if (e5 instanceof RuntimeException) {
                throw (RuntimeException)e5;
            }
            throw CachedConstructor.createExceptionText("failed to invoke constructor: ", constr, argumentArray, e5, true);
        }
    }

    private static GroovyRuntimeException createExceptionText(String init, Constructor constructor, Object[] argumentArray, Throwable e2, boolean setReason) {
        throw new GroovyRuntimeException(init + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e2, setReason ? e2 : null);
    }

    public int getModifiers() {
        return this.cachedConstructor.getModifiers();
    }

    public CachedClass getCachedClass() {
        return this.clazz;
    }
}

