/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteGenerator;
import org.codehaus.groovy.runtime.callsite.PogoMetaMethodSite;
import org.codehaus.groovy.runtime.callsite.PojoMetaMethodSite;
import org.codehaus.groovy.runtime.callsite.StaticMetaMethodSite;
import org.codehaus.groovy.runtime.metaclass.MethodHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedMethod
extends MetaMethod
implements Comparable {
    public final CachedClass cachedClass;
    private final Method cachedMethod;
    private int hashCode;
    private static MyComparator comparator = new MyComparator();
    private SoftReference<Constructor> pogoCallSiteConstructor;
    private SoftReference<Constructor> pojoCallSiteConstructor;
    private SoftReference<Constructor> staticCallSiteConstructor;
    private boolean skipCompiled;

    public CachedMethod(CachedClass clazz, Method method) {
        this.cachedMethod = method;
        this.cachedClass = clazz;
    }

    public CachedMethod(Method method) {
        this(ReflectionCache.getCachedClass(method.getDeclaringClass()), method);
    }

    public static CachedMethod find(Method method) {
        CachedMethod[] methods = ReflectionCache.getCachedClass(method.getDeclaringClass()).getMethods();
        int i2 = Arrays.binarySearch(methods, method, comparator);
        if (i2 < 0) {
            return null;
        }
        return methods[i2];
    }

    @Override
    protected Class[] getPT() {
        return this.cachedMethod.getParameterTypes();
    }

    @Override
    public String getName() {
        return this.cachedMethod.getName();
    }

    @Override
    public String getDescriptor() {
        return BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
    }

    @Override
    public CachedClass getDeclaringClass() {
        return this.cachedClass;
    }

    @Override
    public final Object invoke(Object object, Object[] arguments) {
        try {
            return this.cachedMethod.invoke(object, arguments);
        }
        catch (IllegalArgumentException e2) {
            throw new InvokerInvocationException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new InvokerInvocationException(e3);
        }
        catch (InvocationTargetException e4) {
            Throwable cause = e4.getCause();
            throw cause instanceof RuntimeException && !(cause instanceof MissingMethodException) ? (RuntimeException)cause : new InvokerInvocationException(e4);
        }
    }

    public ParameterTypes getParamTypes() {
        return null;
    }

    @Override
    public Class getReturnType() {
        return this.cachedMethod.getReturnType();
    }

    public int getParamsCount() {
        return this.getParameterTypes().length;
    }

    @Override
    public int getModifiers() {
        return this.cachedMethod.getModifiers();
    }

    @Override
    public String getSignature() {
        return this.getName() + this.getDescriptor();
    }

    public final Method setAccessible() {
        return this.cachedMethod;
    }

    @Override
    public boolean isStatic() {
        return MethodHelper.isStatic(this.cachedMethod);
    }

    public int compareTo(Object o2) {
        if (o2 instanceof CachedMethod) {
            return this.compareToCachedMethod((CachedMethod)o2);
        }
        return this.compareToMethod((Method)o2);
    }

    private int compareToCachedMethod(CachedMethod m2) {
        CachedClass[] mparams;
        if (m2 == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m2.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m2.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m2.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i2 = 0; i2 != params.length; ++i2) {
            int nameComp = params[i2].getName().compareTo(mparams[i2].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        throw new RuntimeException("Should never happen");
    }

    private int compareToMethod(Method m2) {
        Class<?>[] mparams;
        if (m2 == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m2.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m2.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m2.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i2 = 0; i2 != params.length; ++i2) {
            int nameComp = params[i2].getName().compareTo(mparams[i2].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        return 0;
    }

    public boolean equals(Object o2) {
        return o2 instanceof CachedMethod && this.cachedMethod.equals(((CachedMethod)o2).cachedMethod) || o2 instanceof Method && this.cachedMethod.equals(o2);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.cachedMethod.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.cachedMethod.toString();
    }

    private Constructor getConstrcutor(SoftReference<Constructor> ref) {
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public CallSite createPogoMetaMethodSite(CallSite site, MetaClassImpl metaClass, Class[] params) {
        if (!this.skipCompiled) {
            Constructor constr = this.getConstrcutor(this.pogoCallSiteConstructor);
            if (constr == null) {
                if (CallSiteGenerator.isCompilable(this)) {
                    constr = CallSiteGenerator.compilePogoMethod(this);
                }
                if (constr != null) {
                    this.pogoCallSiteConstructor = new SoftReference<Constructor>(constr);
                } else {
                    this.skipCompiled = true;
                }
            }
            if (constr != null) {
                try {
                    return (CallSite)constr.newInstance(site, metaClass, this, params, constr);
                }
                catch (Error e2) {
                    this.skipCompiled = true;
                    throw e2;
                }
                catch (Throwable e3) {
                    this.skipCompiled = true;
                }
            }
        }
        return new PogoMetaMethodSite.PogoCachedMethodSiteNoUnwrapNoCoerce(site, metaClass, this, params);
    }

    public CallSite createPojoMetaMethodSite(CallSite site, MetaClassImpl metaClass, Class[] params) {
        if (!this.skipCompiled) {
            Constructor constr = this.getConstrcutor(this.pojoCallSiteConstructor);
            if (constr == null) {
                if (CallSiteGenerator.isCompilable(this)) {
                    constr = CallSiteGenerator.compilePojoMethod(this);
                }
                if (constr != null) {
                    this.pojoCallSiteConstructor = new SoftReference<Constructor>(constr);
                } else {
                    this.skipCompiled = true;
                }
            }
            if (constr != null) {
                try {
                    return (CallSite)constr.newInstance(site, metaClass, this, params, constr);
                }
                catch (Error e2) {
                    this.skipCompiled = true;
                    throw e2;
                }
                catch (Throwable e3) {
                    this.skipCompiled = true;
                }
            }
        }
        return new PojoMetaMethodSite.PojoCachedMethodSiteNoUnwrapNoCoerce(site, metaClass, (MetaMethod)this, params);
    }

    public CallSite createStaticMetaMethodSite(CallSite site, MetaClassImpl metaClass, Class[] params) {
        if (!this.skipCompiled) {
            Constructor constr = this.getConstrcutor(this.staticCallSiteConstructor);
            if (constr == null) {
                if (CallSiteGenerator.isCompilable(this)) {
                    constr = CallSiteGenerator.compileStaticMethod(this);
                }
                if (constr != null) {
                    this.staticCallSiteConstructor = new SoftReference<Constructor>(constr);
                } else {
                    this.skipCompiled = true;
                }
            }
            if (constr != null) {
                try {
                    return (CallSite)constr.newInstance(site, metaClass, this, params, constr);
                }
                catch (Error e2) {
                    this.skipCompiled = true;
                    throw e2;
                }
                catch (Throwable e3) {
                    this.skipCompiled = true;
                }
            }
        }
        return new StaticMetaMethodSite.StaticMetaMethodSiteNoUnwrapNoCoerce(site, metaClass, (MetaMethod)this, params);
    }

    public Method getCachedMethod() {
        return this.cachedMethod;
    }

    private static class MyComparator
    implements Comparator {
        private MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CachedMethod) {
                return ((CachedMethod)o1).compareTo(o2);
            }
            if (o2 instanceof CachedMethod) {
                return -((CachedMethod)o2).compareTo(o1);
            }
            throw new ClassCastException("One of the two comparables must be a CachedMethod");
        }
    }
}

