/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodRankHelper {
    public static final int DL_SUBSTITUTION = 10;
    public static final int DL_DELETE = 10;
    public static final int DL_TRANSPOSITION = 5;
    public static final int DL_CASE = 5;
    public static final int MAX_RECOMENDATIONS = 5;
    public static final int MAX_METHOD_SCORE = 50;
    public static final int MAX_CONSTRUCTOR_SCORE = 20;
    public static final int MAX_FIELD_SCORE = 30;

    public static String getMethodSuggestionString(String methodName, Class type, Object[] arguments) {
        Class[] argumentClasses;
        List<Pair<Class, Class>> conflictClasses;
        ClassInfo ci = ClassInfo.getClassInfo(type);
        ArrayList<MetaMethod> methods = new ArrayList<MetaMethod>(ci.getMetaClass().getMethods());
        methods.addAll(ci.getMetaClass().getMetaMethods());
        List<MetaMethod> sugg = MethodRankHelper.rankMethods(methodName, arguments, methods);
        StringBuffer sb = new StringBuffer();
        if (!sugg.isEmpty()) {
            sb.append("\nPossible solutions: ");
            for (int i2 = 0; i2 < sugg.size(); ++i2) {
                if (i2 != 0) {
                    sb.append(", ");
                }
                sb.append(sugg.get(i2).getName()).append("(");
                sb.append(MethodRankHelper.listParameterNames(sugg.get(i2).getParameterTypes()));
                sb.append(")");
            }
        }
        if (!(conflictClasses = MethodRankHelper.getConflictClasses(sugg, argumentClasses = MethodRankHelper.getArgumentClasses(arguments))).isEmpty()) {
            sb.append("\nThe following classes appear as argument class and as parameter class, ");
            sb.append("but are defined by different class loader:\n");
            boolean first = true;
            for (Pair<Class, Class> pair : conflictClasses) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(((Class)((Pair)pair).u).getName()).append(" (defined by '");
                sb.append(((Class)((Pair)pair).u).getClassLoader());
                sb.append("' and '");
                sb.append(((Class)((Pair)pair).v).getClassLoader());
                sb.append("')");
            }
            sb.append("\nIf one of the method suggestions matches the method you wanted to call, ");
            sb.append("\nthen check your class loader setup.");
        }
        return sb.toString();
    }

    private static List<Pair<Class, Class>> getConflictClasses(List<MetaMethod> sugg, Class[] argumentClasses) {
        LinkedList<Pair<Class, Class>> ret = new LinkedList<Pair<Class, Class>>();
        HashSet<Class> recordedClasses = new HashSet<Class>();
        for (MetaMethod method : sugg) {
            Class[] para;
            for (Class aPara : para = method.getNativeParameterTypes()) {
                if (recordedClasses.contains(aPara)) continue;
                for (Class argumentClass : argumentClasses) {
                    if (argumentClass == null || argumentClass == aPara || !argumentClass.getName().equals(aPara.getName())) continue;
                    ret.add(new Pair<Class, Class>(argumentClass, aPara));
                }
                recordedClasses.add(aPara);
            }
        }
        return ret;
    }

    private static Class[] getArgumentClasses(Object[] arguments) {
        Class[] argumentClasses = new Class[arguments.length];
        for (int i2 = 0; i2 < argumentClasses.length; ++i2) {
            Object arg = arguments[i2];
            if (arg == null) continue;
            argumentClasses[i2] = arg.getClass();
        }
        return argumentClasses;
    }

    public static String getConstructorSuggestionString(Class type, Object[] arguments) {
        Constructor[] sugg = MethodRankHelper.rankConstructors(arguments, type.getConstructors());
        if (sugg.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nPossible solutions: ");
            for (int i2 = 0; i2 < sugg.length; ++i2) {
                if (i2 != 0) {
                    sb.append(", ");
                }
                sb.append(type.getName()).append("(");
                sb.append(MethodRankHelper.listParameterNames(sugg[i2].getParameterTypes()));
                sb.append(")");
            }
            return sb.toString();
        }
        return "";
    }

    public static String getPropertySuggestionString(String fieldName, Class type) {
        ClassInfo ci = ClassInfo.getClassInfo(type);
        List<MetaProperty> fi = ci.getMetaClass().getProperties();
        ArrayList<RankableField> rf = new ArrayList<RankableField>(fi.size());
        StringBuffer sb = new StringBuffer();
        sb.append("\nPossible solutions: ");
        for (MetaProperty mp : fi) {
            rf.add(new RankableField(fieldName, mp));
        }
        Collections.sort(rf);
        int i2 = 0;
        for (RankableField f2 : rf) {
            if (i2 > 5 || f2.score > 30) break;
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(f2.f.getName());
            ++i2;
        }
        return i2 > 0 ? sb.toString() : "";
    }

    private static String listParameterNames(Class[] cachedClasses) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < cachedClasses.length; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(cachedClasses[i2].getName());
        }
        return sb.toString();
    }

    private static String listParameterNames(CachedClass[] cachedClasses) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < cachedClasses.length; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(cachedClasses[i2].getName());
        }
        return sb.toString();
    }

    private static List<MetaMethod> rankMethods(String name, Object[] original, List<MetaMethod> methods) {
        ArrayList<RankableMethod> rm = new ArrayList<RankableMethod>(methods.size());
        if (original == null) {
            original = new Object[]{};
        }
        Class[] ta = new Class[original.length];
        Class<NullObject> nullC = NullObject.class;
        for (int i2 = 0; i2 < original.length; ++i2) {
            ta[i2] = original[i2] == null ? nullC : original[i2].getClass();
        }
        for (MetaMethod m2 : methods) {
            rm.add(new RankableMethod(name, ta, m2));
        }
        Collections.sort(rm);
        ArrayList<MetaMethod> l2 = new ArrayList<MetaMethod>(rm.size());
        for (RankableMethod m3 : rm) {
            if (l2.size() > 5 || m3.score > 50) break;
            l2.add(m3.m);
        }
        return l2;
    }

    private static Constructor[] rankConstructors(Object[] original, Constructor[] candidates) {
        int i2;
        Object[] rc = new RankableConstructor[candidates.length];
        Class[] ta = new Class[original.length];
        Class<NullObject> nullC = NullObject.class;
        for (i2 = 0; i2 < original.length; ++i2) {
            ta[i2] = original[i2] == null ? nullC : original[i2].getClass();
        }
        for (i2 = 0; i2 < candidates.length; ++i2) {
            rc[i2] = new RankableConstructor(ta, candidates[i2]);
        }
        Arrays.sort(rc);
        ArrayList<Constructor> l2 = new ArrayList<Constructor>();
        for (int index = 0; l2.size() < 5 && index < rc.length && ((RankableConstructor)rc[index]).score < 20; ++index) {
            l2.add(((RankableConstructor)rc[index]).c);
        }
        return l2.toArray(new Constructor[l2.size()]);
    }

    protected static Class boxVar(Class c2) {
        if (Boolean.TYPE.equals(c2)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(c2)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(c2)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(c2)) {
            return Double.class;
        }
        if (Float.TYPE.equals(c2)) {
            return Float.class;
        }
        if (Integer.TYPE.equals(c2)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(c2)) {
            return Long.class;
        }
        if (Short.TYPE.equals(c2)) {
            return Short.class;
        }
        return c2;
    }

    public static int delDistance(CharSequence s2, CharSequence t) {
        int i2;
        if (s2 == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = s2.length();
        int m2 = t.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        int[][] vals = new int[3][n2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            vals[1][i2] = i2 * 10;
        }
        for (int j2 = 1; j2 <= m2; ++j2) {
            char t_j = t.charAt(j2 - 1);
            vals[0][0] = j2 * 10;
            for (i2 = 1; i2 <= n2; ++i2) {
                char s_i = s2.charAt(i2 - 1);
                int cost = Character.isLowerCase(s_i) ^ Character.isLowerCase(t_j) ? (MethodRankHelper.caselessCompare(s_i, t_j) ? 5 : 10) : (s_i == t_j ? 0 : 10);
                vals[0][i2] = Math.min(Math.min(vals[0][i2 - 1] + 10, vals[1][i2] + 10), vals[1][i2 - 1] + cost);
                if (i2 <= 1 || j2 <= 1) continue;
                cost = Character.isLowerCase(s_i) ^ Character.isLowerCase(t.charAt(j2 - 2)) ? 5 : 0;
                int n3 = cost = Character.isLowerCase(s2.charAt(i2 - 2)) ^ Character.isLowerCase(t_j) ? cost + 5 : cost;
                if (!MethodRankHelper.caselessCompare(s_i, t.charAt(j2 - 2)) || !MethodRankHelper.caselessCompare(s2.charAt(i2 - 2), t_j)) continue;
                vals[0][i2] = Math.min(vals[0][i2], vals[2][i2 - 2] + 5 + cost);
            }
            int[] _d = vals[2];
            vals[2] = vals[1];
            vals[1] = vals[0];
            vals[0] = _d;
        }
        return vals[1][n2];
    }

    private static boolean caselessCompare(char a2, char b2) {
        return Character.toLowerCase(a2) == Character.toLowerCase(b2);
    }

    public static int damerauLevenshteinDistance(Object[] s2, Object[] t) {
        int i2;
        if (s2 == null || t == null) {
            throw new IllegalArgumentException("Arrays must not be null");
        }
        int n2 = s2.length;
        int m2 = t.length;
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        int[][] vals = new int[3][n2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            vals[1][i2] = i2 * 10;
        }
        for (int j2 = 1; j2 <= m2; ++j2) {
            Object t_j = t[j2 - 1];
            vals[0][0] = j2 * 10;
            for (i2 = 1; i2 <= n2; ++i2) {
                int cost = s2[i2 - 1].equals(t_j) ? 0 : 10;
                vals[0][i2] = Math.min(Math.min(vals[0][i2 - 1] + 10, vals[1][i2] + 10), vals[1][i2 - 1] + cost);
                if (i2 <= 1 || j2 <= 1 || !s2[i2 - 1].equals(t[j2 - 2]) || !s2[i2 - 2].equals(t_j)) continue;
                vals[0][i2] = Math.min(vals[0][i2], vals[2][i2 - 2] + 5);
            }
            int[] _d = vals[2];
            vals[2] = vals[1];
            vals[1] = vals[0];
            vals[0] = _d;
        }
        return vals[1][n2];
    }

    private static class NullObject {
        private NullObject() {
        }
    }

    private static final class RankableField
    implements Comparable {
        final MetaProperty f;
        final Integer score;

        public RankableField(String name, MetaProperty mp) {
            this.f = mp;
            this.score = MethodRankHelper.delDistance(name, mp.getName());
        }

        public int compareTo(Object o2) {
            RankableField co = (RankableField)o2;
            return this.score.compareTo(co.score);
        }
    }

    private static final class RankableConstructor
    implements Comparable {
        final Constructor c;
        final Integer score;

        public RankableConstructor(Class[] argumentTypes, Constructor c2) {
            this.c = c2;
            Object[] cArgs = new Class[c2.getParameterTypes().length];
            for (int i2 = 0; i2 < cArgs.length; ++i2) {
                cArgs[i2] = MethodRankHelper.boxVar(c2.getParameterTypes()[i2]);
            }
            this.score = MethodRankHelper.damerauLevenshteinDistance(argumentTypes, cArgs);
        }

        public int compareTo(Object o2) {
            RankableConstructor co = (RankableConstructor)o2;
            return this.score.compareTo(co.score);
        }
    }

    private static final class RankableMethod
    implements Comparable {
        final MetaMethod m;
        final Integer score;

        public RankableMethod(String name, Class[] argumentTypes, MetaMethod m2) {
            this.m = m2;
            int nameDist = MethodRankHelper.delDistance(name, m2.getName());
            Object[] mArgs = new Class[m2.getParameterTypes().length];
            for (int i2 = 0; i2 < mArgs.length; ++i2) {
                mArgs[i2] = MethodRankHelper.boxVar(m2.getParameterTypes()[i2].getTheClass());
            }
            int argDist = MethodRankHelper.damerauLevenshteinDistance(argumentTypes, mArgs);
            this.score = nameDist + argDist;
        }

        public int compareTo(Object o2) {
            RankableMethod mo = (RankableMethod)o2;
            return this.score.compareTo(mo.score);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pair<U, V> {
        private U u;
        private V v;

        public Pair(U u, V v) {
            this.u = u;
            this.v = v;
        }
    }
}

