/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import groovy.lang.GroovyRuntimeException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.codehaus.groovy.GroovyExceptionInterface;
import org.codehaus.groovy.control.CompilationFailedException;

public class ErrorReporter {
    private Throwable base = null;
    private boolean debug = false;
    private Object output = null;

    public ErrorReporter(Throwable e2) {
        this.base = e2;
    }

    public ErrorReporter(Throwable e2, boolean debug) {
        this.base = e2;
        this.debug = debug;
    }

    public void write(PrintStream stream) {
        this.output = stream;
        this.dispatch(this.base, false);
        stream.flush();
    }

    public void write(PrintWriter writer) {
        this.output = writer;
        this.dispatch(this.base, false);
        writer.flush();
    }

    protected void dispatch(Throwable object, boolean child) {
        if (object instanceof CompilationFailedException) {
            this.report((CompilationFailedException)object, child);
        } else if (object instanceof GroovyExceptionInterface) {
            this.report((GroovyExceptionInterface)((Object)object), child);
        } else if (object instanceof GroovyRuntimeException) {
            this.report((GroovyRuntimeException)object, child);
        } else if (object instanceof Exception) {
            this.report((Exception)object, child);
        } else {
            this.report(object, child);
        }
    }

    protected void report(CompilationFailedException e2, boolean child) {
        this.println(e2.toString());
        this.stacktrace(e2, false);
    }

    protected void report(GroovyExceptionInterface e2, boolean child) {
        this.println(((Exception)((Object)e2)).getMessage());
        this.stacktrace((Exception)((Object)e2), false);
    }

    protected void report(Exception e2, boolean child) {
        this.println(e2.getMessage());
        this.stacktrace(e2, false);
    }

    protected void report(Throwable e2, boolean child) {
        this.println(">>> a serious error occurred: " + e2.getMessage());
        this.stacktrace(e2, true);
    }

    protected void println(String line) {
        if (this.output instanceof PrintStream) {
            ((PrintStream)this.output).println(line);
        } else {
            ((PrintWriter)this.output).println(line);
        }
    }

    protected void println(StringBuffer line) {
        if (this.output instanceof PrintStream) {
            ((PrintStream)this.output).println(line);
        } else {
            ((PrintWriter)this.output).println(line);
        }
    }

    protected void stacktrace(Throwable e2, boolean always) {
        if (this.debug || always) {
            this.println(">>> stacktrace:");
            if (this.output instanceof PrintStream) {
                e2.printStackTrace((PrintStream)this.output);
            } else {
                e2.printStackTrace((PrintWriter)this.output);
            }
        }
    }
}

