/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.tools.GrapeUtil;
import org.codehaus.groovy.tools.LoaderConfiguration;

public class RootLoader
extends URLClassLoader {
    private Map<String, Class> customClasses = new HashMap<String, Class>();

    private RootLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public RootLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        try {
            this.customClasses.put("org.w3c.dom.Node", super.loadClass("org.w3c.dom.Node", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ClassLoader chooseParent() {
        ClassLoader cl = RootLoader.class.getClassLoader();
        if (cl != null) {
            return cl;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public RootLoader(LoaderConfiguration lc) {
        this(RootLoader.chooseParent());
        URL[] urls;
        Thread.currentThread().setContextClassLoader(this);
        for (URL url : urls = lc.getClassPathUrls()) {
            this.addURL(url);
        }
        String groovyHome = System.getProperty("groovy.home");
        List<String> grabUrls = lc.getGrabUrls();
        for (String grabUrl : grabUrls) {
            Map<String, Object> grabParts = GrapeUtil.getIvyParts(grabUrl);
            String group = grabParts.get("group").toString();
            String module = grabParts.get("module").toString();
            String name = grabParts.get("module").toString() + "-" + grabParts.get("version") + ".jar";
            File jar = new File(groovyHome + "/repo/" + group + "/" + module + "/jars/" + name);
            try {
                this.addURL(jar.toURI().toURL());
            }
            catch (MalformedURLException e2) {}
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c2 = this.findLoadedClass(name);
        if (c2 != null) {
            return c2;
        }
        c2 = this.customClasses.get(name);
        if (c2 != null) {
            return c2;
        }
        try {
            c2 = this.oldFindClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (c2 == null) {
            c2 = super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(c2);
        }
        return c2;
    }

    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    private Class oldFindClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }
}

