/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import org.codehaus.groovy.util.AbstractConcurrentMapBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConcurrentMap<K, V>
extends AbstractConcurrentMapBase {
    public AbstractConcurrentMap(Object segmentInfo) {
        super(segmentInfo);
    }

    @Override
    public Segment segmentFor(int hash) {
        return (Segment)super.segmentFor(hash);
    }

    public V get(K key) {
        int hash = AbstractConcurrentMap.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    public Entry<K, V> getOrPut(K key, V value) {
        int hash = AbstractConcurrentMap.hash(key);
        return this.segmentFor(hash).getOrPut(key, hash, value);
    }

    public void put(K key, V value) {
        int hash = AbstractConcurrentMap.hash(key);
        this.segmentFor(hash).put(key, hash, value);
    }

    public void remove(K key) {
        int hash = AbstractConcurrentMap.hash(key);
        this.segmentFor(hash).remove(key, hash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<K, V>
    extends AbstractConcurrentMapBase.Entry<V> {
        public boolean isEqual(K var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Segment<K, V>
    extends AbstractConcurrentMapBase.Segment {
        protected Segment(int initialCapacity) {
            super(initialCapacity);
        }

        public final V get(K key, int hash) {
            Object[] tab = this.table;
            Object o2 = tab[hash & tab.length - 1];
            if (o2 != null) {
                if (o2 instanceof Entry) {
                    Entry e2 = (Entry)o2;
                    if (e2.isEqual(key, hash)) {
                        return e2.getValue();
                    }
                } else {
                    Object[] arr = (Object[])o2;
                    for (int i2 = 0; i2 < arr.length; ++i2) {
                        Entry e3 = (Entry)arr[i2];
                        if (e3 == null || !e3.isEqual(key, hash)) continue;
                        return e3.getValue();
                    }
                }
            }
            return null;
        }

        public final Entry<K, V> getOrPut(K key, int hash, V value) {
            Object[] tab = this.table;
            Object o2 = tab[hash & tab.length - 1];
            if (o2 != null) {
                if (o2 instanceof Entry) {
                    Entry e2 = (Entry)o2;
                    if (e2.isEqual(key, hash)) {
                        return e2;
                    }
                } else {
                    Object[] arr = (Object[])o2;
                    for (int i2 = 0; i2 < arr.length; ++i2) {
                        Entry e3 = (Entry)arr[i2];
                        if (e3 == null || !e3.isEqual(key, hash)) continue;
                        return e3;
                    }
                }
            }
            return this.put(key, hash, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Entry put(K key, int hash, V value) {
            this.lock();
            try {
                Entry<K, V> e2;
                int index;
                Object[] tab;
                Object o2;
                int c2 = this.count;
                if (c2++ > this.threshold) {
                    this.rehash();
                }
                if ((o2 = (tab = this.table)[index = hash & tab.length - 1]) != null) {
                    if (o2 instanceof Entry) {
                        Entry e3 = (Entry)o2;
                        if (e3.isEqual(key, hash)) {
                            e3.setValue(value);
                            Entry entry = e3;
                            return entry;
                        }
                        Entry<K, V> ee = this.createEntry(key, hash, value);
                        Object[] arr = new Object[]{ee, e3};
                        tab[index] = arr;
                        this.count = c2;
                        Entry<K, V> entry = ee;
                        return entry;
                    }
                    Object[] arr = (Object[])o2;
                    for (int i2 = 0; i2 < arr.length; ++i2) {
                        Entry e4 = (Entry)arr[i2];
                        if (e4 == null || !e4.isEqual(key, hash)) continue;
                        e4.setValue(value);
                        Entry entry = e4;
                        return entry;
                    }
                    Entry<K, V> ee = this.createEntry(key, hash, value);
                    for (int i3 = 0; i3 < arr.length; ++i3) {
                        Entry e5 = (Entry)arr[i3];
                        if (e5 != null) continue;
                        arr[i3] = ee;
                        this.count = c2;
                        Entry<K, V> entry = ee;
                        return entry;
                    }
                    Object[] newArr = new Object[arr.length + 1];
                    newArr[0] = ee;
                    System.arraycopy(arr, 0, newArr, 1, arr.length);
                    tab[index] = newArr;
                    this.count = c2;
                    Entry<K, V> entry = ee;
                    return entry;
                }
                tab[index] = e2 = this.createEntry(key, hash, value);
                this.count = c2;
                Entry<K, V> entry = e2;
                return entry;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(K key, int hash) {
            block6: {
                this.lock();
                try {
                    int c2 = this.count - 1;
                    Object[] tab = this.table;
                    int index = hash & tab.length - 1;
                    Object o2 = tab[index];
                    if (o2 == null) break block6;
                    if (o2 instanceof Entry) {
                        if (((Entry)o2).isEqual(key, hash)) {
                            tab[index] = null;
                            this.count = c2;
                        }
                        break block6;
                    }
                    Object[] arr = (Object[])o2;
                    for (int i2 = 0; i2 < arr.length; ++i2) {
                        Entry e2 = (Entry)arr[i2];
                        if (e2 == null || !e2.isEqual(key, hash)) continue;
                        arr[i2] = null;
                        this.count = c2;
                        break;
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        protected abstract Entry<K, V> createEntry(K var1, int var2, V var3);
    }
}

