/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.util.Collection;
import java.util.LinkedList;
import org.codehaus.groovy.util.LockableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConcurrentMapBase {
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    protected final Segment[] segments;

    public AbstractConcurrentMapBase(Object segmentInfo) {
        int cap;
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < 16; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        int c2 = 512 / ssize;
        if (c2 * ssize < 512) {
            ++c2;
        }
        for (cap = 1; cap < c2; cap <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = this.createSegment(segmentInfo, cap);
        }
    }

    protected abstract Segment createSegment(Object var1, int var2);

    protected static <K> int hash(K key) {
        int h2 = System.identityHashCode(key);
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    public Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fullSize() {
        int count = 0;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].lock();
            try {
                for (int j2 = 0; j2 < this.segments[i2].table.length; ++j2) {
                    Object o2 = this.segments[i2].table[j2];
                    if (o2 == null) continue;
                    if (o2 instanceof Entry) {
                        ++count;
                        continue;
                    }
                    Object[] arr = (Object[])o2;
                    count += arr.length;
                }
                continue;
            }
            finally {
                this.segments[i2].unlock();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int count = 0;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].lock();
            try {
                for (int j2 = 0; j2 < this.segments[i2].table.length; ++j2) {
                    Object o2 = this.segments[i2].table[j2];
                    if (o2 == null) continue;
                    if (o2 instanceof Entry) {
                        Entry e2 = (Entry)o2;
                        if (!e2.isValid()) continue;
                        ++count;
                        continue;
                    }
                    Object[] arr = (Object[])o2;
                    for (int k2 = 0; k2 < arr.length; ++k2) {
                        Entry info = (Entry)arr[k2];
                        if (info == null || !info.isValid()) continue;
                        ++count;
                    }
                }
                continue;
            }
            finally {
                this.segments[i2].unlock();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        LinkedList<Entry> result = new LinkedList<Entry>();
        boolean count = false;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].lock();
            try {
                for (int j2 = 0; j2 < this.segments[i2].table.length; ++j2) {
                    Object o2 = this.segments[i2].table[j2];
                    if (o2 == null) continue;
                    if (o2 instanceof Entry) {
                        Entry e2 = (Entry)o2;
                        if (!e2.isValid()) continue;
                        result.add(e2);
                        continue;
                    }
                    Object[] arr = (Object[])o2;
                    for (int k2 = 0; k2 < arr.length; ++k2) {
                        Entry info = (Entry)arr[k2];
                        if (info == null || !info.isValid()) continue;
                        result.add(info);
                    }
                }
                continue;
            }
            finally {
                this.segments[i2].unlock();
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<V> {
        public V getValue();

        public void setValue(V var1);

        public int getHash();

        public boolean isValid();
    }

    public static class Segment
    extends LockableObject {
        volatile int count;
        int threshold;
        protected volatile Object[] table;

        protected Segment(int initialCapacity) {
            this.setTable(new Object[initialCapacity]);
        }

        void setTable(Object[] newTable) {
            this.threshold = (int)((float)newTable.length * 0.75f);
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeEntry(Entry e2) {
            this.lock();
            int newCount = this.count;
            try {
                Object[] tab = this.table;
                int index = e2.getHash() & tab.length - 1;
                Object o2 = tab[index];
                if (o2 != null) {
                    if (o2 instanceof Entry) {
                        if (o2 == e2) {
                            tab[index] = null;
                            --newCount;
                        }
                    } else {
                        Object[] arr = (Object[])o2;
                        Object res = null;
                        for (int i2 = 0; i2 < arr.length; ++i2) {
                            Entry info = (Entry)arr[i2];
                            if (info == null) continue;
                            if (info != e2) {
                                if (info.isValid()) {
                                    res = this.put(info, res);
                                    continue;
                                }
                                --newCount;
                                continue;
                            }
                            --newCount;
                        }
                        tab[index] = res;
                    }
                    this.count = newCount;
                }
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            Object[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            int newCount = 0;
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                Object o2 = oldTable[i2];
                if (o2 == null) continue;
                if (o2 instanceof Entry) {
                    Entry e2 = (Entry)o2;
                    if (e2.isValid()) {
                        ++newCount;
                        continue;
                    }
                    oldTable[i2] = null;
                    continue;
                }
                Object[] arr = (Object[])o2;
                int localCount = 0;
                for (int index = 0; index < arr.length; ++index) {
                    Entry e3 = (Entry)arr[index];
                    if (e3 != null && e3.isValid()) {
                        ++localCount;
                        continue;
                    }
                    arr[index] = null;
                }
                if (localCount == 0) {
                    oldTable[i2] = null;
                    continue;
                }
                newCount += localCount;
            }
            Object[] newTable = new Object[newCount + 1 < this.threshold ? oldCapacity : oldCapacity << 1];
            int sizeMask = newTable.length - 1;
            newCount = 0;
            for (int i3 = 0; i3 < oldCapacity; ++i3) {
                Object o3 = oldTable[i3];
                if (o3 == null) continue;
                if (o3 instanceof Entry) {
                    Entry e4 = (Entry)o3;
                    if (!e4.isValid()) continue;
                    int index = e4.getHash() & sizeMask;
                    this.put(e4, index, newTable);
                    ++newCount;
                    continue;
                }
                Object[] arr = (Object[])o3;
                for (int j2 = 0; j2 < arr.length; ++j2) {
                    Entry e5 = (Entry)arr[j2];
                    if (e5 == null || !e5.isValid()) continue;
                    int index = e5.getHash() & sizeMask;
                    this.put(e5, index, newTable);
                    ++newCount;
                }
            }
            this.threshold = (int)((float)newTable.length * 0.75f);
            this.table = newTable;
            this.count = newCount;
        }

        private void put(Entry ee, int index, Object[] tab) {
            Object o2 = tab[index];
            if (o2 != null) {
                if (o2 instanceof Entry) {
                    Object[] arr = new Object[]{ee, (Entry)o2};
                    tab[index] = arr;
                    return;
                }
                Object[] arr = (Object[])o2;
                Object[] newArr = new Object[arr.length + 1];
                newArr[0] = ee;
                System.arraycopy(arr, 0, newArr, 1, arr.length);
                tab[index] = newArr;
                return;
            }
            tab[index] = ee;
        }

        private Object put(Entry ee, Object o2) {
            if (o2 != null) {
                if (o2 instanceof Entry) {
                    Object[] arr = new Object[]{ee, (Entry)o2};
                    return arr;
                }
                Object[] arr = (Object[])o2;
                Object[] newArr = new Object[arr.length + 1];
                newArr[0] = ee;
                System.arraycopy(arr, 0, newArr, 1, arr.length);
                return newArr;
            }
            return ee;
        }
    }
}

