/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.util.NoSuchElementException;

public class ComplexKeyHashMap {
    protected Entry[] table;
    protected static final int DEFAULT_CAPACITY = 32;
    protected static final int MINIMUM_CAPACITY = 4;
    protected static final int MAXIMUM_CAPACITY = 0x10000000;
    protected int size;
    protected transient int threshold;

    public ComplexKeyHashMap() {
        this.init(32);
    }

    public ComplexKeyHashMap(boolean b2) {
    }

    public ComplexKeyHashMap(int expectedMaxSize) {
        this.init(this.capacity(expectedMaxSize));
    }

    public static int hash(int h2) {
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            tab[i2] = null;
        }
        this.size = 0;
    }

    public void init(int initCapacity) {
        this.threshold = initCapacity * 6 / 8;
        this.table = new Entry[initCapacity];
    }

    public void resize(int newLength) {
        Entry[] oldTable = this.table;
        int oldLength = this.table.length;
        Entry[] newTable = new Entry[newLength];
        for (int j2 = 0; j2 < oldLength; ++j2) {
            Entry e2 = oldTable[j2];
            while (e2 != null) {
                Entry next = e2.next;
                int index = e2.hash & newLength - 1;
                e2.next = newTable[index];
                newTable[index] = e2;
                e2 = next;
            }
        }
        this.table = newTable;
        this.threshold = 6 * newLength / 8;
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = 8 * expectedMaxSize / 6;
        if (minCapacity > 0x10000000 || minCapacity < 0) {
            result = 0x10000000;
        } else {
            for (result = 4; result < minCapacity; result <<= 1) {
            }
        }
        return result;
    }

    public Entry[] getTable() {
        return this.table;
    }

    public EntryIterator getEntrySetIterator() {
        return new EntryIterator(){
            Entry next;
            int index;
            Entry current;
            {
                Entry[] t = ComplexKeyHashMap.this.table;
                int i2 = t.length;
                Entry n2 = null;
                if (ComplexKeyHashMap.this.size != 0) {
                    while (i2 > 0 && (n2 = t[--i2]) == null) {
                    }
                }
                this.next = n2;
                this.index = i2;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Entry next() {
                return this.nextEntry();
            }

            Entry nextEntry() {
                Entry e2 = this.next;
                if (e2 == null) {
                    throw new NoSuchElementException();
                }
                Entry n2 = e2.next;
                Entry[] t = ComplexKeyHashMap.this.table;
                int i2 = this.index;
                while (n2 == null && i2 > 0) {
                    n2 = t[--i2];
                }
                this.index = i2;
                this.next = n2;
                this.current = e2;
                return this.current;
            }
        };
    }

    public static interface EntryIterator {
        public boolean hasNext();

        public Entry next();
    }

    public static class Entry {
        public int hash;
        public Entry next;
        public Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

