/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.util.Reference;
import org.codehaus.groovy.util.ReferenceBundle;
import org.codehaus.groovy.util.ReferenceType;

public class ReferenceManager {
    private ReferenceQueue queue;
    private static final ReferenceBundle SOFT_BUNDLE;
    private static final ReferenceBundle WEAK_BUNDLE;

    public static ReferenceManager createThreadedManager(ReferenceQueue queue) {
        return new ThreadedReferenceManager(queue);
    }

    public static ReferenceManager createIdlingManager(ReferenceQueue queue) {
        return new ReferenceManager(queue);
    }

    public static ReferenceManager createCallBackedManager(ReferenceQueue queue) {
        return new ReferenceManager(queue){

            public void removeStallEntries() {
                java.lang.ref.Reference r2;
                ReferenceQueue queue = this.getReferenceQueue();
                while ((r2 = queue.poll()) != null) {
                    Reference ref;
                    Object holder;
                    if (r2 instanceof Reference && (holder = (ref = (Reference)((Object)r2)).getHandler()) != null) {
                        holder.finalizeReference();
                    }
                    r2.clear();
                    Object var2_2 = null;
                }
            }

            public void afterReferenceCreation(Reference r2) {
                this.removeStallEntries();
            }

            public String toString() {
                return "ReferenceManager(callback)";
            }
        };
    }

    public static ReferenceManager createThresholdedIdlingManager(final ReferenceQueue queue, final ReferenceManager callback, final int threshold) {
        if (threshold < 0) {
            throw new IllegalArgumentException("threshold must not be below 0.");
        }
        return new ReferenceManager(queue){
            private AtomicInteger refCnt;
            private volatile ReferenceManager manager;
            {
                super(x0);
                this.refCnt = new AtomicInteger();
                this.manager = 2.createIdlingManager(queue);
            }

            public void afterReferenceCreation(Reference r2) {
                if (this.manager == callback) {
                    callback.afterReferenceCreation(r2);
                    return;
                }
                int count = this.refCnt.incrementAndGet();
                if (count > threshold || count < 0) {
                    this.manager = callback;
                }
            }

            public String toString() {
                return "ReferenceManager(thresholded, current manager=" + this.manager + ", threshold=" + this.refCnt.get() + "/" + threshold + ")";
            }
        };
    }

    public ReferenceManager(ReferenceQueue queue) {
        this.queue = queue;
    }

    protected ReferenceQueue getReferenceQueue() {
        return this.queue;
    }

    public void afterReferenceCreation(Reference r2) {
    }

    public void removeStallEntries() {
    }

    public void stopThread() {
    }

    public String toString() {
        return "ReferenceManager(idling)";
    }

    public static ReferenceBundle getDefaultSoftBundle() {
        return SOFT_BUNDLE;
    }

    public static ReferenceBundle getDefaultWeakBundle() {
        return WEAK_BUNDLE;
    }

    static {
        ReferenceQueue queue = new ReferenceQueue();
        ReferenceManager callBack = ReferenceManager.createCallBackedManager(queue);
        ReferenceManager manager = ReferenceManager.createThresholdedIdlingManager(queue, callBack, 500);
        SOFT_BUNDLE = new ReferenceBundle(manager, ReferenceType.SOFT);
        WEAK_BUNDLE = new ReferenceBundle(manager, ReferenceType.WEAK);
    }

    private static class ThreadedReferenceManager
    extends ReferenceManager {
        private final Thread thread = new Thread(){

            public void run() {
                ReferenceQueue queue = ThreadedReferenceManager.this.getReferenceQueue();
                java.lang.ref.Reference r2 = null;
                while (ThreadedReferenceManager.this.shouldRun) {
                    Reference ref;
                    Object holder;
                    try {
                        r2 = queue.remove(1000L);
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                    if (r2 == null) continue;
                    if (r2 instanceof Reference && (holder = (ref = (Reference)((Object)r2)).getHandler()) != null) {
                        holder.finalizeReference();
                    }
                    r2.clear();
                    r2 = null;
                }
            }
        };
        private volatile boolean shouldRun = true;

        public ThreadedReferenceManager(ReferenceQueue queue) {
            super(queue);
            this.thread.setContextClassLoader(null);
            this.thread.setDaemon(true);
            this.thread.setName(ThreadedReferenceManager.class.getName());
            this.thread.start();
        }

        public void stopThread() {
            this.shouldRun = false;
            this.thread.interrupt();
        }

        public String toString() {
            return "ReferenceManager(threaded, thread=" + this.thread + ")";
        }
    }
}

