/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    private static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String join(Collection strings, String sep) {
        return StringUtil.join(strings.iterator(), sep);
    }

    public static String join(Iterator strings, String sep) {
        if (!strings.hasNext()) {
            return "";
        }
        String start = strings.next().toString();
        if (!strings.hasNext()) {
            return start;
        }
        StringBuilder sb = new StringBuilder(64).append(start);
        while (strings.hasNext()) {
            sb.append(sep);
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static String padding(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (width < padding.length) {
            return padding[width];
        }
        char[] out = new char[width];
        for (int i2 = 0; i2 < width; ++i2) {
            out[i2] = 32;
        }
        return String.valueOf(out);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int l2 = string.length();
        for (int i2 = 0; i2 < l2; ++i2) {
            if (StringUtil.isWhitespace(string.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int l2 = string.length();
        for (int i2 = 0; i2 < l2; ++i2) {
            if (Character.isDigit(string.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c2) {
        return c2 == 32 || c2 == 9 || c2 == 10 || c2 == 12 || c2 == 13;
    }

    public static String normaliseWhitespace(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        StringUtil.appendNormalisedWhitespace(sb, string, false);
        return sb.toString();
    }

    public static void appendNormalisedWhitespace(StringBuilder accum, String string, boolean stripLeading) {
        int c2;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        for (int i2 = 0; i2 < len; i2 += Character.charCount(c2)) {
            c2 = string.codePointAt(i2);
            if (StringUtil.isWhitespace(c2)) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) continue;
                accum.append(' ');
                lastWasWhite = true;
                continue;
            }
            accum.appendCodePoint(c2);
            lastWasWhite = false;
            reachedNonWhite = true;
        }
    }

    public static boolean in(String needle, String ... haystack) {
        for (String hay : haystack) {
            if (!hay.equals(needle)) continue;
            return true;
        }
        return false;
    }
}

