/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import java.awt.Dimension;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixConstants;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import org.krysalis.barcode4j.tools.URLUtil;

public class DataMatrixHighLevelEncoder
implements DataMatrixConstants {
    private static final boolean DEBUG = false;
    private static final int ASCII_ENCODATION = 0;
    private static final int C40_ENCODATION = 1;
    private static final int TEXT_ENCODATION = 2;
    private static final int X12_ENCODATION = 3;
    private static final int EDIFACT_ENCODATION = 4;
    private static final int BASE256_ENCODATION = 5;
    private static final String[] ENCODATION_NAMES = new String[]{"ASCII", "C40", "Text", "ANSI X12", "EDIFACT", "Base 256"};
    private static final String DEFAULT_ASCII_ENCODING = "ISO-8859-1";
    private static final String URL_START = "url(";
    private static final String URL_END = ")";

    public static byte[] getBytesForMessage(String msg) {
        String charset = "cp437";
        try {
            return msg.getBytes("cp437");
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnsupportedOperationException("Incompatible JVM! The 'cp437' charset is not available!");
        }
    }

    private static char randomize253State(char ch, int codewordPosition) {
        int pseudoRandom = 149 * codewordPosition % 253 + 1;
        int tempVariable = ch + pseudoRandom;
        if (tempVariable <= 254) {
            return (char)tempVariable;
        }
        return (char)(tempVariable - 254);
    }

    private static char randomize255State(char ch, int codewordPosition) {
        int pseudoRandom = 149 * codewordPosition % 255 + 1;
        int tempVariable = ch + pseudoRandom;
        if (tempVariable <= 255) {
            return (char)tempVariable;
        }
        return (char)(tempVariable - 256);
    }

    public static String encodeHighLevel(String msg) throws IOException {
        return DataMatrixHighLevelEncoder.encodeHighLevel(msg, SymbolShapeHint.FORCE_NONE, null, null);
    }

    public static String encodeHighLevel(String msg, SymbolShapeHint shape, Dimension minSize, Dimension maxSize) throws IOException {
        StringBuffer codewords;
        Encoder[] encoders = new Encoder[]{new ASCIIEncoder(), new C40Encoder(), new TextEncoder(), new X12Encoder(), new EdifactEncoder(), new Base256Encoder()};
        int encodingMode = 0;
        EncoderContext context = DataMatrixHighLevelEncoder.createEncoderContext(msg);
        context.setSymbolShape(shape);
        context.setSizeConstraints(minSize, maxSize);
        if (msg.startsWith("[)>\u001e05\u001d") && msg.endsWith("\u001e\u0004")) {
            context.writeCodeword('\u00ec');
            context.setSkipAtEnd(2);
            context.pos += "[)>\u001e05\u001d".length();
        } else if (msg.startsWith("[)>\u001e06\u001d") && msg.endsWith("\u001e\u0004")) {
            context.writeCodeword('\u00ed');
            context.setSkipAtEnd(2);
            context.pos += "[)>\u001e06\u001d".length();
        }
        while (context.hasMoreCharacters()) {
            encoders[encodingMode].encode(context);
            if (context.newEncoding < 0) continue;
            encodingMode = context.newEncoding;
            context.resetEncoderSignal();
        }
        int len = context.codewords.length();
        context.updateSymbolInfo();
        int capacity = ((EncoderContext)context).symbolInfo.dataCapacity;
        if (len < capacity && encodingMode != 0 && encodingMode != 5) {
            context.writeCodeword('\u00fe');
        }
        if ((codewords = context.codewords).length() < capacity) {
            codewords.append('\u0081');
        }
        while (codewords.length() < capacity) {
            codewords.append(DataMatrixHighLevelEncoder.randomize253State('\u0081', codewords.length() + 1));
        }
        return context.codewords.toString();
    }

    private static EncoderContext createEncoderContext(String msg) throws IOException {
        if (msg.startsWith(URL_START) && msg.endsWith(URL_END)) {
            String url = msg.substring(URL_START.length(), msg.length() - URL_END.length());
            byte[] data = URLUtil.getData(url, DEFAULT_ASCII_ENCODING);
            return new EncoderContext(data);
        }
        return new EncoderContext(msg);
    }

    private static char encodeASCIIDigits(char digit1, char digit2) {
        if (DataMatrixHighLevelEncoder.isDigit(digit1) && DataMatrixHighLevelEncoder.isDigit(digit2)) {
            int num = (digit1 - 48) * 10 + (digit2 - 48);
            return (char)(num + 130);
        }
        throw new IllegalArgumentException("not digits: " + digit1 + digit2);
    }

    private static int lookAheadTest(String msg, int startpos, int currentMode) {
        float[] charCounts;
        if (startpos >= msg.length()) {
            return currentMode;
        }
        if (currentMode == 0) {
            charCounts = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.25f};
        } else {
            charCounts = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.25f};
            charCounts[currentMode] = 0.0f;
        }
        int charsProcessed = 0;
        while (true) {
            int[] intCharCounts;
            if (startpos + charsProcessed == msg.length()) {
                int min = Integer.MAX_VALUE;
                byte[] mins = new byte[6];
                intCharCounts = new int[6];
                min = DataMatrixHighLevelEncoder.findMinimums(charCounts, intCharCounts, min, mins);
                int minCount = DataMatrixHighLevelEncoder.getMinimumCount(mins);
                if (intCharCounts[0] == min) {
                    return 0;
                }
                if (minCount == 1 && mins[5] > 0) {
                    return 5;
                }
                if (minCount == 1 && mins[4] > 0) {
                    return 4;
                }
                if (minCount == 1 && mins[2] > 0) {
                    return 2;
                }
                if (minCount == 1 && mins[3] > 0) {
                    return 3;
                }
                return 1;
            }
            char c2 = msg.charAt(startpos + charsProcessed);
            ++charsProcessed;
            if (DataMatrixHighLevelEncoder.isDigit(c2)) {
                charCounts[0] = (float)((double)charCounts[0] + 0.5);
            } else if (DataMatrixHighLevelEncoder.isExtendedASCII(c2)) {
                charCounts[0] = (int)Math.ceil(charCounts[0]);
                charCounts[0] = charCounts[0] + 2.0f;
            } else {
                charCounts[0] = (int)Math.ceil(charCounts[0]);
                charCounts[0] = charCounts[0] + 1.0f;
            }
            charCounts[1] = DataMatrixHighLevelEncoder.isNativeC40(c2) ? charCounts[1] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c2) ? charCounts[1] + 2.6666667f : charCounts[1] + 1.3333334f);
            charCounts[2] = DataMatrixHighLevelEncoder.isNativeText(c2) ? charCounts[2] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c2) ? charCounts[2] + 2.6666667f : charCounts[2] + 1.3333334f);
            charCounts[3] = DataMatrixHighLevelEncoder.isNativeX12(c2) ? charCounts[3] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c2) ? charCounts[3] + 4.3333335f : charCounts[3] + 3.3333333f);
            charCounts[4] = DataMatrixHighLevelEncoder.isNativeEDIFACT(c2) ? charCounts[4] + 0.75f : (DataMatrixHighLevelEncoder.isExtendedASCII(c2) ? charCounts[4] + 4.25f : charCounts[4] + 3.25f);
            charCounts[5] = DataMatrixHighLevelEncoder.isSpecialB256(c2) ? charCounts[5] + 4.0f : charCounts[5] + 1.0f;
            if (charsProcessed < 4) continue;
            int min = Integer.MAX_VALUE;
            intCharCounts = new int[6];
            byte[] mins = new byte[6];
            min = DataMatrixHighLevelEncoder.findMinimums(charCounts, intCharCounts, min, mins);
            int minCount = DataMatrixHighLevelEncoder.getMinimumCount(mins);
            if (intCharCounts[0] + 1 <= intCharCounts[5] && intCharCounts[0] + 1 <= intCharCounts[1] && intCharCounts[0] + 1 <= intCharCounts[2] && intCharCounts[0] + 1 <= intCharCounts[3] && intCharCounts[0] + 1 <= intCharCounts[4]) {
                return 0;
            }
            if (intCharCounts[5] + 1 <= intCharCounts[0] || mins[1] + mins[2] + mins[3] + mins[4] == 0) {
                return 5;
            }
            if (minCount == 1 && mins[4] > 0) {
                return 4;
            }
            if (minCount == 1 && mins[2] > 0) {
                return 2;
            }
            if (minCount == 1 && mins[3] > 0) {
                return 3;
            }
            if (intCharCounts[1] + 1 >= intCharCounts[0] || intCharCounts[1] + 1 >= intCharCounts[5] || intCharCounts[1] + 1 >= intCharCounts[4] || intCharCounts[1] + 1 >= intCharCounts[2]) continue;
            if (intCharCounts[1] < intCharCounts[3]) {
                return 1;
            }
            if (intCharCounts[1] == intCharCounts[3]) break;
        }
        for (int p2 = startpos + charsProcessed + 1; p2 < msg.length(); ++p2) {
            char tc = msg.charAt(p2);
            if (DataMatrixHighLevelEncoder.isX12TermSep(tc)) {
                return 3;
            }
            if (!DataMatrixHighLevelEncoder.isNativeX12(tc)) break;
        }
        return 1;
    }

    private static int findMinimums(float[] charCounts, int[] intCharCounts, int min, byte[] mins) {
        Arrays.fill(mins, (byte)0);
        for (int i2 = 0; i2 < 6; ++i2) {
            intCharCounts[i2] = (int)Math.ceil(charCounts[i2]);
            int current = intCharCounts[i2];
            if (min > current) {
                min = current;
                Arrays.fill(mins, (byte)0);
            }
            if (min != current) continue;
            int n2 = i2;
            mins[n2] = (byte)(mins[n2] + 1);
        }
        return min;
    }

    private static int getMinimumCount(byte[] mins) {
        int minCount = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            minCount += mins[i2];
        }
        return minCount;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isExtendedASCII(char ch) {
        return ch >= '\u0080' && ch <= '\u00ff';
    }

    private static boolean isASCII7(char ch) {
        return ch >= '\u0000' && ch <= '\u007f';
    }

    private static boolean isNativeC40(char ch) {
        return ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isNativeText(char ch) {
        return ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isNativeX12(char ch) {
        return DataMatrixHighLevelEncoder.isX12TermSep(ch) || ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isX12TermSep(char ch) {
        return ch == '\r' || ch == '*' || ch == '>';
    }

    private static boolean isNativeEDIFACT(char ch) {
        return ch >= ' ' && ch <= '^';
    }

    private static boolean isSpecialB256(char ch) {
        return false;
    }

    public static int determineConsecutiveDigitCount(String msg, int startpos) {
        int count = 0;
        int idx = startpos;
        int len = msg.length();
        if (idx < len) {
            char ch = msg.charAt(idx);
            while (DataMatrixHighLevelEncoder.isDigit(ch) && idx < len) {
                ++count;
                if (++idx >= len) continue;
                ch = msg.charAt(idx);
            }
        }
        return count;
    }

    private static void illegalCharacter(char c2) {
        String hex = Integer.toHexString(c2);
        String padding = "0000";
        hex = "0000".substring(0, 4 - hex.length()) + hex;
        throw new IllegalArgumentException("Illegal character: " + c2 + " (0x" + hex + URL_END);
    }

    private static class Base256Encoder
    implements Encoder {
        private Base256Encoder() {
        }

        public int getEncodingMode() {
            return 5;
        }

        public void encode(EncoderContext context) {
            boolean mustPad;
            StringBuffer buffer = new StringBuffer();
            buffer.append('\u0000');
            while (context.hasMoreCharacters()) {
                char c2 = context.getCurrentChar();
                buffer.append(c2);
                context.pos++;
                int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                if (newMode == this.getEncodingMode()) continue;
                context.signalEncoderChange(newMode);
                break;
            }
            int dataCount = buffer.length() - 1;
            int lengthFieldSize = 1;
            int currentSize = context.getCodewordCount() + dataCount + lengthFieldSize;
            context.updateSymbolInfo(currentSize);
            boolean bl = mustPad = ((EncoderContext)context).symbolInfo.dataCapacity - currentSize > 0;
            if (context.hasMoreCharacters() || mustPad) {
                if (dataCount <= 249) {
                    buffer.setCharAt(0, (char)dataCount);
                } else if (dataCount > 249 && dataCount <= 1555) {
                    buffer.setCharAt(0, (char)(dataCount / 250 + 249));
                    buffer.insert(1, (char)(dataCount % 250));
                } else {
                    throw new IllegalStateException("Message length not in valid ranges: " + dataCount);
                }
            }
            int c3 = buffer.length();
            for (int i2 = 0; i2 < c3; ++i2) {
                context.writeCodeword(DataMatrixHighLevelEncoder.randomize255State(buffer.charAt(i2), context.getCodewordCount() + 1));
            }
        }
    }

    private static class EdifactEncoder
    implements Encoder {
        private EdifactEncoder() {
        }

        public int getEncodingMode() {
            return 4;
        }

        public void encode(EncoderContext context) {
            StringBuffer buffer = new StringBuffer();
            while (context.hasMoreCharacters()) {
                char c2 = context.getCurrentChar();
                this.encodeChar(c2, buffer);
                context.pos++;
                int count = buffer.length();
                if (count < 4) continue;
                context.writeCodewords(this.encodeToCodewords(buffer, 0));
                buffer.delete(0, 4);
                int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                if (newMode == this.getEncodingMode()) continue;
                context.signalEncoderChange(0);
                break;
            }
            buffer.append('\u001f');
            this.handleEOD(context, buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleEOD(EncoderContext context, StringBuffer buffer) {
            try {
                boolean restInAscii;
                int count = buffer.length();
                if (count == 0) {
                    return;
                }
                if (count == 1) {
                    context.updateSymbolInfo();
                    int available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
                    int remaining = context.getRemainingCharacters();
                    if (remaining == 0 && available <= 2) {
                        return;
                    }
                }
                if (count > 4) {
                    throw new IllegalStateException("Count must not exceed 4");
                }
                int restChars = count - 1;
                String encoded = this.encodeToCodewords(buffer, 0);
                boolean endOfSymbolReached = !context.hasMoreCharacters();
                boolean bl = restInAscii = endOfSymbolReached && restChars <= 2;
                if (restChars <= 2) {
                    context.updateSymbolInfo(context.getCodewordCount() + restChars);
                    int available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
                    if (available >= 3) {
                        restInAscii = false;
                        context.updateSymbolInfo(context.getCodewordCount() + encoded.length());
                        available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
                    }
                }
                if (restInAscii) {
                    context.resetSymbolInfo();
                    context.pos -= restChars;
                } else {
                    context.writeCodewords(encoded);
                }
            }
            finally {
                context.signalEncoderChange(0);
            }
        }

        protected void encodeChar(char c2, StringBuffer sb) {
            if (c2 >= ' ' && c2 <= '?') {
                sb.append(c2);
            } else if (c2 >= '@' && c2 <= '^') {
                sb.append((char)(c2 - 64));
            } else {
                DataMatrixHighLevelEncoder.illegalCharacter(c2);
            }
        }

        protected String encodeToCodewords(StringBuffer sb, int startPos) {
            int len = sb.length() - startPos;
            if (len == 0) {
                throw new IllegalStateException("StringBuffer must not be empty");
            }
            char c1 = sb.charAt(startPos);
            char c2 = len >= 2 ? sb.charAt(startPos + 1) : (char)'\u0000';
            char c3 = len >= 3 ? sb.charAt(startPos + 2) : (char)'\u0000';
            char c4 = len >= 4 ? sb.charAt(startPos + 3) : (char)'\u0000';
            int v = (c1 << 18) + (c2 << 12) + (c3 << 6) + c4;
            char cw1 = (char)(v >> 16 & 0xFF);
            char cw2 = (char)(v >> 8 & 0xFF);
            char cw3 = (char)(v & 0xFF);
            StringBuffer res = new StringBuffer(3);
            res.append(cw1);
            if (len >= 2) {
                res.append(cw2);
            }
            if (len >= 3) {
                res.append(cw3);
            }
            return res.toString();
        }
    }

    private static class X12Encoder
    extends C40Encoder {
        private X12Encoder() {
        }

        public int getEncodingMode() {
            return 3;
        }

        public void encode(EncoderContext context) {
            StringBuffer buffer = new StringBuffer();
            while (context.hasMoreCharacters()) {
                char c2 = context.getCurrentChar();
                context.pos++;
                this.encodeChar(c2, buffer);
                int count = buffer.length();
                if (count % 3 != 0) continue;
                this.writeNextTriplet(context, buffer);
                int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                if (newMode == this.getEncodingMode()) continue;
                context.signalEncoderChange(newMode);
                break;
            }
            this.handleEOD(context, buffer);
        }

        protected int encodeChar(char c2, StringBuffer sb) {
            if (c2 == '\r') {
                sb.append('\u0000');
            } else if (c2 == '*') {
                sb.append('\u0001');
            } else if (c2 == '>') {
                sb.append('\u0002');
            } else if (c2 == ' ') {
                sb.append('\u0003');
            } else if (c2 >= '0' && c2 <= '9') {
                sb.append((char)(c2 - 48 + 4));
            } else if (c2 >= 'A' && c2 <= 'Z') {
                sb.append((char)(c2 - 65 + 14));
            } else {
                DataMatrixHighLevelEncoder.illegalCharacter(c2);
            }
            return 1;
        }

        protected void handleEOD(EncoderContext context, StringBuffer buffer) {
            context.updateSymbolInfo();
            int available = ((EncoderContext)context).symbolInfo.dataCapacity - context.getCodewordCount();
            int count = buffer.length();
            if (count == 2) {
                context.writeCodeword('\u00fe');
                context.pos -= 2;
                context.signalEncoderChange(0);
            } else if (count == 1) {
                context.pos--;
                if (available > 1) {
                    context.writeCodeword('\u00fe');
                }
                context.signalEncoderChange(0);
            }
        }
    }

    private static class TextEncoder
    extends C40Encoder {
        private TextEncoder() {
        }

        public int getEncodingMode() {
            return 2;
        }

        protected int encodeChar(char c2, StringBuffer sb) {
            if (c2 == ' ') {
                sb.append('\u0003');
                return 1;
            }
            if (c2 >= '0' && c2 <= '9') {
                sb.append((char)(c2 - 48 + 4));
                return 1;
            }
            if (c2 >= 'a' && c2 <= 'z') {
                sb.append((char)(c2 - 97 + 14));
                return 1;
            }
            if (c2 >= '\u0000' && c2 <= '\u001f') {
                sb.append('\u0000');
                sb.append(c2);
                return 2;
            }
            if (c2 >= '!' && c2 <= '/') {
                sb.append('\u0001');
                sb.append((char)(c2 - 33));
                return 2;
            }
            if (c2 >= ':' && c2 <= '@') {
                sb.append('\u0001');
                sb.append((char)(c2 - 58 + 15));
                return 2;
            }
            if (c2 >= '[' && c2 <= '_') {
                sb.append('\u0001');
                sb.append((char)(c2 - 91 + 22));
                return 2;
            }
            if (c2 == '`') {
                sb.append('\u0002');
                sb.append((char)(c2 - 96));
                return 2;
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                sb.append('\u0002');
                sb.append((char)(c2 - 65 + 1));
                return 2;
            }
            if (c2 >= '{' && c2 <= '\u007f') {
                sb.append('\u0002');
                sb.append((char)(c2 - 123 + 27));
                return 2;
            }
            if (c2 >= '\u0080') {
                sb.append("\u0001\u001e");
                int len = 2;
                return len += this.encodeChar((char)(c2 - 128), sb);
            }
            DataMatrixHighLevelEncoder.illegalCharacter(c2);
            return -1;
        }
    }

    private static class C40Encoder
    implements Encoder {
        private C40Encoder() {
        }

        public int getEncodingMode() {
            return 1;
        }

        public void encode(EncoderContext context) {
            int lastCharSize = -1;
            StringBuffer buffer = new StringBuffer();
            while (context.hasMoreCharacters()) {
                int newMode;
                char c2 = context.getCurrentChar();
                context.pos++;
                lastCharSize = this.encodeChar(c2, buffer);
                int unwritten = buffer.length() / 3 * 2;
                int curCodewordCount = context.getCodewordCount() + unwritten;
                context.updateSymbolInfo(curCodewordCount);
                int available = ((EncoderContext)context).symbolInfo.dataCapacity - curCodewordCount;
                if (!context.hasMoreCharacters()) {
                    StringBuffer removed = new StringBuffer();
                    if (buffer.length() % 3 == 2 && (available < 2 || available > 2)) {
                        lastCharSize = this.backtrackOneCharacter(context, buffer, removed, lastCharSize);
                    }
                    while (buffer.length() % 3 == 1 && (lastCharSize <= 3 && available != 1 || lastCharSize > 3)) {
                        lastCharSize = this.backtrackOneCharacter(context, buffer, removed, lastCharSize);
                    }
                    break;
                }
                int count = buffer.length();
                if (count % 3 != 0 || (newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode())) == this.getEncodingMode()) continue;
                context.signalEncoderChange(newMode);
                break;
            }
            this.handleEOD(context, buffer, lastCharSize);
        }

        private int backtrackOneCharacter(EncoderContext context, StringBuffer buffer, StringBuffer removed, int lastCharSize) {
            int count = buffer.length();
            buffer.delete(count - lastCharSize, count);
            context.pos--;
            char c2 = context.getCurrentChar();
            lastCharSize = this.encodeChar(c2, removed);
            context.resetSymbolInfo();
            return lastCharSize;
        }

        protected void writeNextTriplet(EncoderContext context, StringBuffer buffer) {
            context.writeCodewords(this.encodeToCodewords(buffer, 0));
            buffer.delete(0, 3);
        }

        protected void handleEOD(EncoderContext context, StringBuffer buffer, int lastCharSize) {
            int unwritten = buffer.length() / 3 * 2;
            int rest = buffer.length() % 3;
            int curCodewordCount = context.getCodewordCount() + unwritten;
            context.updateSymbolInfo(curCodewordCount);
            int available = ((EncoderContext)context).symbolInfo.dataCapacity - curCodewordCount;
            if (rest == 2) {
                buffer.append('\u0000');
                while (buffer.length() >= 3) {
                    this.writeNextTriplet(context, buffer);
                }
                if (context.hasMoreCharacters()) {
                    context.writeCodeword('\u00fe');
                }
            } else if (available == 1 && rest == 1) {
                while (buffer.length() >= 3) {
                    this.writeNextTriplet(context, buffer);
                }
                if (context.hasMoreCharacters()) {
                    context.writeCodeword('\u00fe');
                }
                context.pos--;
            } else if (rest == 0) {
                while (buffer.length() >= 3) {
                    this.writeNextTriplet(context, buffer);
                }
                if (available > 0 || context.hasMoreCharacters()) {
                    context.writeCodeword('\u00fe');
                }
            } else {
                throw new IllegalStateException("Unexpected case. Please report!");
            }
            context.signalEncoderChange(0);
        }

        protected int encodeChar(char c2, StringBuffer sb) {
            if (c2 == ' ') {
                sb.append('\u0003');
                return 1;
            }
            if (c2 >= '0' && c2 <= '9') {
                sb.append((char)(c2 - 48 + 4));
                return 1;
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                sb.append((char)(c2 - 65 + 14));
                return 1;
            }
            if (c2 >= '\u0000' && c2 <= '\u001f') {
                sb.append('\u0000');
                sb.append(c2);
                return 2;
            }
            if (c2 >= '!' && c2 <= '/') {
                sb.append('\u0001');
                sb.append((char)(c2 - 33));
                return 2;
            }
            if (c2 >= ':' && c2 <= '@') {
                sb.append('\u0001');
                sb.append((char)(c2 - 58 + 15));
                return 2;
            }
            if (c2 >= '[' && c2 <= '_') {
                sb.append('\u0001');
                sb.append((char)(c2 - 91 + 22));
                return 2;
            }
            if (c2 >= '`' && c2 <= '\u007f') {
                sb.append('\u0002');
                sb.append((char)(c2 - 96));
                return 2;
            }
            if (c2 >= '\u0080') {
                sb.append("\u0001\u001e");
                int len = 2;
                return len += this.encodeChar((char)(c2 - 128), sb);
            }
            throw new IllegalArgumentException("Illegal character: " + c2);
        }

        protected String encodeToCodewords(StringBuffer sb, int startPos) {
            char c1 = sb.charAt(startPos);
            char c2 = sb.charAt(startPos + 1);
            char c3 = sb.charAt(startPos + 2);
            int v = 1600 * c1 + 40 * c2 + c3 + 1;
            char cw1 = (char)(v / 256);
            char cw2 = (char)(v % 256);
            return "" + cw1 + cw2;
        }
    }

    private static class ASCIIEncoder
    implements Encoder {
        private ASCIIEncoder() {
        }

        public int getEncodingMode() {
            return 0;
        }

        public void encode(EncoderContext context) {
            block10: {
                char c2;
                block11: {
                    block9: {
                        int n2 = DataMatrixHighLevelEncoder.determineConsecutiveDigitCount(context.msg, context.pos);
                        if (n2 < 2) break block9;
                        context.writeCodeword(DataMatrixHighLevelEncoder.encodeASCIIDigits(context.msg.charAt(context.pos), context.msg.charAt(context.pos + 1)));
                        context.pos += 2;
                        break block10;
                    }
                    c2 = context.getCurrentChar();
                    int newMode = DataMatrixHighLevelEncoder.lookAheadTest(context.msg, context.pos, this.getEncodingMode());
                    if (newMode == this.getEncodingMode()) break block11;
                    switch (newMode) {
                        case 5: {
                            context.writeCodeword('\u00e7');
                            context.signalEncoderChange(5);
                            return;
                        }
                        case 1: {
                            context.writeCodeword('\u00e6');
                            context.signalEncoderChange(1);
                            return;
                        }
                        case 3: {
                            context.writeCodeword('\u00ee');
                            context.signalEncoderChange(3);
                            break block10;
                        }
                        case 2: {
                            context.writeCodeword('\u00ef');
                            context.signalEncoderChange(2);
                            break block10;
                        }
                        case 4: {
                            context.writeCodeword('\u00f0');
                            context.signalEncoderChange(4);
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException("Illegal mode: " + newMode);
                        }
                    }
                }
                if (DataMatrixHighLevelEncoder.isExtendedASCII(c2)) {
                    context.writeCodeword('\u00eb');
                    context.writeCodeword((char)(c2 - 128 + 1));
                    context.pos++;
                } else {
                    context.writeCodeword((char)(c2 + '\u0001'));
                    context.pos++;
                }
            }
        }
    }

    private static interface Encoder {
        public int getEncodingMode();

        public void encode(EncoderContext var1);
    }

    private static class EncoderContext {
        private String msg;
        private SymbolShapeHint shape = SymbolShapeHint.FORCE_NONE;
        private Dimension minSize;
        private Dimension maxSize;
        private StringBuffer codewords;
        private int pos = 0;
        private int newEncoding = -1;
        private DataMatrixSymbolInfo symbolInfo;
        private int skipAtEnd = 0;

        public EncoderContext(String msg) {
            byte[] msgBinary;
            try {
                msgBinary = msg.getBytes(DataMatrixHighLevelEncoder.DEFAULT_ASCII_ENCODING);
            }
            catch (UnsupportedEncodingException e2) {
                throw new UnsupportedOperationException("Unsupported encoding: " + e2.getMessage());
            }
            StringBuffer sb = new StringBuffer(msgBinary.length);
            int c2 = msgBinary.length;
            for (int i2 = 0; i2 < c2; ++i2) {
                char ch = (char)(msgBinary[i2] & 0xFF);
                if (ch == '?' && msg.charAt(i2) != '?') {
                    throw new IllegalArgumentException("Message contains characters outside ISO-8859-1 encoding.");
                }
                sb.append(ch);
            }
            this.msg = sb.toString();
            this.codewords = new StringBuffer(msg.length());
        }

        public EncoderContext(byte[] data) {
            StringBuffer sb = new StringBuffer(data.length);
            int c2 = data.length;
            for (int i2 = 0; i2 < c2; ++i2) {
                char ch = (char)(data[i2] & 0xFF);
                sb.append(ch);
            }
            this.msg = sb.toString();
            this.codewords = new StringBuffer(this.msg.length());
        }

        public void setSymbolShape(SymbolShapeHint shape) {
            this.shape = shape;
        }

        public void setSizeConstraints(Dimension minSize, Dimension maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        public String getMessage() {
            return this.msg;
        }

        public void setSkipAtEnd(int count) {
            this.skipAtEnd = count;
        }

        public char getCurrentChar() {
            return this.msg.charAt(this.pos);
        }

        public char getCurrent() {
            return this.msg.charAt(this.pos);
        }

        public void writeCodewords(String codewords) {
            this.codewords.append(codewords);
        }

        public void writeCodeword(char codeword) {
            this.codewords.append(codeword);
        }

        public int getCodewordCount() {
            return this.codewords.length();
        }

        public void signalEncoderChange(int encoding) {
            this.newEncoding = encoding;
        }

        public void resetEncoderSignal() {
            this.newEncoding = -1;
        }

        public boolean hasMoreCharacters() {
            return this.pos < this.getTotalMessageCharCount();
        }

        private int getTotalMessageCharCount() {
            return this.msg.length() - this.skipAtEnd;
        }

        public int getRemainingCharacters() {
            return this.getTotalMessageCharCount() - this.pos;
        }

        public void updateSymbolInfo() {
            this.updateSymbolInfo(this.getCodewordCount());
        }

        public void updateSymbolInfo(int len) {
            if (this.symbolInfo == null || len > this.symbolInfo.dataCapacity) {
                this.symbolInfo = DataMatrixSymbolInfo.lookup(len, this.shape, this.minSize, this.maxSize, true);
            }
        }

        public void resetSymbolInfo() {
            this.symbolInfo = null;
        }
    }
}

