/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import java.awt.Dimension;
import java.io.IOException;
import org.krysalis.barcode4j.TwoDimBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixErrorCorrection;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixHighLevelEncoder;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixPlacement;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import org.krysalis.barcode4j.impl.datamatrix.DefaultDataMatrixPlacement;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;

public class DataMatrixLogicImpl {
    private static final boolean DEBUG = false;

    public void generateBarcodeLogic(TwoDimBarcodeLogicHandler logic, String msg, SymbolShapeHint shape, Dimension minSize, Dimension maxSize) {
        String encoded;
        try {
            encoded = DataMatrixHighLevelEncoder.encodeHighLevel(msg, shape, minSize, maxSize);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Cannot fetch data: " + e2.getLocalizedMessage());
        }
        DataMatrixSymbolInfo symbolInfo = DataMatrixSymbolInfo.lookup(encoded.length(), shape, minSize, maxSize, true);
        String codewords = DataMatrixErrorCorrection.encodeECC200(encoded, symbolInfo);
        DefaultDataMatrixPlacement placement = new DefaultDataMatrixPlacement(codewords, symbolInfo.getSymbolDataWidth(), symbolInfo.getSymbolDataHeight());
        placement.place();
        logic.startBarcode(msg, msg);
        this.encodeLowLevel(logic, placement, symbolInfo);
        logic.endBarcode();
    }

    private void encodeLowLevel(TwoDimBarcodeLogicHandler logic, DataMatrixPlacement placement, DataMatrixSymbolInfo symbolInfo) {
        int symbolWidth = symbolInfo.getSymbolDataWidth();
        int symbolHeight = symbolInfo.getSymbolDataHeight();
        for (int y = 0; y < symbolHeight; ++y) {
            int x;
            if (y % symbolInfo.matrixHeight == 0) {
                logic.startRow();
                for (x = 0; x < symbolInfo.getSymbolWidth(); ++x) {
                    logic.addBar(x % 2 == 0, 1);
                }
                logic.endRow();
            }
            logic.startRow();
            for (x = 0; x < symbolWidth; ++x) {
                if (x % symbolInfo.matrixWidth == 0) {
                    logic.addBar(true, 1);
                }
                logic.addBar(placement.getBit(x, y), 1);
                if (x % symbolInfo.matrixWidth != symbolInfo.matrixWidth - 1) continue;
                logic.addBar(y % 2 == 0, 1);
            }
            logic.endRow();
            if (y % symbolInfo.matrixHeight != symbolInfo.matrixHeight - 1) continue;
            logic.startRow();
            for (x = 0; x < symbolInfo.getSymbolWidth(); ++x) {
                logic.addBar(true, 1);
            }
            logic.endRow();
        }
    }
}

