/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public abstract class AbstractFourStateLogicImpl {
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public AbstractFourStateLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public abstract char calcChecksum(String var1);

    public boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = this.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    public static boolean isIgnoredChar(char c2) {
        return false;
    }

    protected abstract String normalizeMessage(String var1);

    protected abstract String[] encodeHighLevel(String var1);

    protected void encodeCodeword(ClassicBarcodeLogicHandler logic, char c2, String codeword) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c2).toString());
        int count = codeword.length();
        for (int i2 = 0; i2 < count; ++i2) {
            int height = Integer.parseInt(codeword.substring(i2, i2 + 1));
            logic.addBar(true, height);
        }
        logic.endBarGroup();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String normalizedMsg = this.normalizeMessage(msg);
        String[] encodedMsg = this.encodeHighLevel(normalizedMsg);
        logic.startBarcode(msg, normalizedMsg);
        for (int i2 = 0; i2 < encodedMsg.length; ++i2) {
            char ch = normalizedMsg.charAt(i2);
            this.encodeCodeword(logic, ch, encodedMsg[i2]);
        }
        logic.endBarcode();
    }
}

