/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.fourstate.AbstractRMCBCKIXLogicImpl;

public class RoyalMailCBCLogicImpl
extends AbstractRMCBCKIXLogicImpl {
    public RoyalMailCBCLogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public char calcChecksum(String msg) {
        String[] codewords = this.encodeHighLevel(RoyalMailCBCLogicImpl.removeStartStop(msg));
        int[] multiplier = new int[]{4, 2, 1, 0};
        int upperSum = 0;
        int lowerSum = 0;
        for (int i2 = 0; i2 < codewords.length; ++i2) {
            int upper = 0;
            int lower = 0;
            for (int j2 = 0; j2 < 4; ++j2) {
                int v = codewords[i2].charAt(j2) - 48;
                upper += (v & 1) * multiplier[j2];
                lower += ((v & 2) >> 1) * multiplier[j2];
            }
            upperSum += upper % 6;
            lowerSum += lower % 6;
        }
        int row = upperSum % 6;
        row = row == 0 ? 5 : --row;
        int col = lowerSum % 6;
        col = col == 0 ? 5 : --col;
        int idx = row * 6 + col;
        if (idx < 10) {
            return (char)(48 + idx);
        }
        return (char)(65 + idx - 10);
    }

    protected String handleChecksum(String msg) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return msg + this.calcChecksum(msg);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!this.validateChecksum(msg)) {
                throw new IllegalArgumentException("Message '" + msg + "' has a bad checksum. Expected: " + this.calcChecksum(msg.substring(0, msg.length() - 1)));
            }
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + this.getChecksumMode());
    }

    public static String removeStartStop(String msg) {
        StringBuffer sb = new StringBuffer(msg.length());
        int c2 = msg.length();
        block3: for (int i2 = 0; i2 < c2; ++i2) {
            char ch = msg.charAt(i2);
            switch (ch) {
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public String normalizeMessage(String msg) {
        String s2 = RoyalMailCBCLogicImpl.removeStartStop(msg);
        s2 = this.handleChecksum(s2);
        return "(" + s2 + ")";
    }
}

