/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.bitmap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import org.krysalis.barcode4j.output.bitmap.ImageIOBitmapEncoder;

public class BitmapEncoderRegistry {
    private static Set encoders = new TreeSet();

    protected BitmapEncoderRegistry() {
        throw new UnsupportedOperationException();
    }

    private static synchronized void register(String classname, int priority, boolean complain) {
        boolean failed = false;
        try {
            Class<?> clazz = Class.forName(classname);
            BitmapEncoder encoder = (BitmapEncoder)clazz.newInstance();
            encoders.add(new Entry(encoder, priority));
        }
        catch (Exception e2) {
            failed = true;
        }
        catch (LinkageError le) {
            failed = true;
        }
        if (failed) {
            if (complain) {
                throw new IllegalArgumentException("The implementation being registered is unavailable or cannot be instantiated: " + classname);
            }
            return;
        }
    }

    public static void register(String classname, int priority) {
        BitmapEncoderRegistry.register(classname, priority, true);
    }

    public static boolean supports(BitmapEncoder encoder, String mime) {
        String[] mimes = encoder.getSupportedMIMETypes();
        for (int i2 = 0; i2 < mimes.length; ++i2) {
            if (!mimes[i2].equals(mime)) continue;
            return true;
        }
        return false;
    }

    public static boolean supports(String mime) {
        Iterator i2 = encoders.iterator();
        while (i2.hasNext()) {
            Entry entry = (Entry)i2.next();
            BitmapEncoder encoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(encoder, mime)) continue;
            return true;
        }
        return false;
    }

    public static BitmapEncoder getInstance(String mime) {
        Iterator i2 = encoders.iterator();
        while (i2.hasNext()) {
            Entry entry = (Entry)i2.next();
            BitmapEncoder encoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(encoder, mime)) continue;
            return encoder;
        }
        throw new UnsupportedOperationException("No BitmapEncoder available for " + mime);
    }

    public static Set getSupportedMIMETypes() {
        HashSet<String> mimes = new HashSet<String>();
        Iterator i2 = encoders.iterator();
        while (i2.hasNext()) {
            Entry entry = (Entry)i2.next();
            BitmapEncoder encoder = entry.encoder;
            String[] s2 = encoder.getSupportedMIMETypes();
            for (int j2 = 0; j2 < s2.length; ++j2) {
                mimes.add(s2[j2]);
            }
        }
        return mimes;
    }

    static {
        BitmapEncoderRegistry.register(ImageIOBitmapEncoder.class.getName(), 0, false);
    }

    private static class Entry
    implements Comparable {
        private BitmapEncoder encoder;
        private int priority;

        public Entry(BitmapEncoder encoder, int priority) {
            this.encoder = encoder;
            this.priority = priority;
        }

        public int compareTo(Object o2) {
            Entry e2 = (Entry)o2;
            return e2.priority - this.priority;
        }
    }
}

