/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignatureBuilder {
    private final ParameterTable table = new ParameterTable();
    private final Constructor factory;

    public SignatureBuilder(Constructor factory) {
        this.factory = factory;
    }

    public boolean isValid() {
        int width;
        Class<?>[] types = this.factory.getParameterTypes();
        return types.length == (width = this.table.width());
    }

    public void insert(Parameter value, int index) {
        this.table.insert(value, index);
    }

    public List<Signature> build() throws Exception {
        return this.build(new ParameterTable());
    }

    private List<Signature> build(ParameterTable matrix) throws Exception {
        if (this.table.isEmpty()) {
            return this.create();
        }
        this.build(matrix, 0);
        return this.create(matrix);
    }

    private List<Signature> create() throws Exception {
        ArrayList<Signature> list = new ArrayList<Signature>();
        Signature signature = new Signature(this.factory);
        if (this.isValid()) {
            list.add(signature);
        }
        return list;
    }

    private List<Signature> create(ParameterTable matrix) throws Exception {
        ArrayList<Signature> list = new ArrayList<Signature>();
        int height = matrix.height();
        int width = matrix.width();
        for (int i2 = 0; i2 < height; ++i2) {
            Signature signature = new Signature(this.factory);
            for (int j2 = 0; j2 < width; ++j2) {
                Parameter parameter = matrix.get(j2, i2);
                String path = parameter.getPath();
                Object key = parameter.getKey();
                if (signature.contains(key)) {
                    throw new ConstructorException("Parameter '%s' is a duplicate in %s", path, this.factory);
                }
                signature.add(parameter);
            }
            list.add(signature);
        }
        return list;
    }

    private void build(ParameterTable matrix, int index) {
        this.build(matrix, new ParameterList(), index);
    }

    private void build(ParameterTable matrix, ParameterList signature, int index) {
        ParameterList column = this.table.get(index);
        int height = column.size();
        int width = this.table.width();
        if (width - 1 > index) {
            for (int i2 = 0; i2 < height; ++i2) {
                ParameterList extended = new ParameterList(signature);
                if (signature == null) continue;
                Parameter parameter = (Parameter)column.get(i2);
                extended.add(parameter);
                this.build(matrix, extended, index + 1);
            }
        } else {
            this.populate(matrix, signature, index);
        }
    }

    private void populate(ParameterTable matrix, ParameterList signature, int index) {
        ParameterList column = this.table.get(index);
        int width = signature.size();
        int height = column.size();
        for (int i2 = 0; i2 < height; ++i2) {
            for (int j2 = 0; j2 < width; ++j2) {
                ParameterList list = matrix.get(j2);
                Parameter parameter = (Parameter)signature.get(j2);
                list.add(parameter);
            }
            ParameterList list = matrix.get(index);
            Parameter parameter = (Parameter)column.get(i2);
            list.add(parameter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterList
    extends ArrayList<Parameter> {
        public ParameterList() {
        }

        public ParameterList(ParameterList list) {
            super(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterTable
    extends ArrayList<ParameterList> {
        private int height() {
            int width = this.width();
            if (width > 0) {
                return this.get(0).size();
            }
            return 0;
        }

        private int width() {
            return this.size();
        }

        public void insert(Parameter value, int column) {
            ParameterList list = this.get(column);
            if (list != null) {
                list.add(value);
            }
        }

        @Override
        public ParameterList get(int column) {
            int size;
            for (int i2 = size = this.size(); i2 <= column; ++i2) {
                ParameterList list = new ParameterList();
                this.add(list);
            }
            return (ParameterList)super.get(column);
        }

        public Parameter get(int column, int row) {
            return (Parameter)this.get(column).get(row);
        }
    }
}

