/*
 * Decompiled with CFR 0.152.
 */
package tangram.dbf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import tangram.dbf.TngDbfFieldValuable;
import tangram.dbf.TngDbfUtils;
import tangram.library.Nat;

public class TngDbfField<E>
implements TngDbfFieldValuable<E> {
    public static final byte FIELD_TYPE_C = 67;
    public static final byte FIELD_TYPE_L = 76;
    public static final byte FIELD_TYPE_N = 78;
    public static final byte FIELD_TYPE_F = 70;
    public static final byte FIELD_TYPE_D = 68;
    public static final byte FIELD_TYPE_M = 77;
    private byte[] fieldName = new byte[11];
    private byte dataType;
    private int reserv1;
    private int fieldLength;
    private byte decimalCount;
    private short reserv2;
    private byte workAreaId;
    private byte setFieldsFlag;
    private byte[] reserv4 = new byte[7];
    private byte indexFieldFlag;
    private int nameNullIndex = 0;

    protected static TngDbfField createField(DataInput in) throws IOException {
        TngDbfField field = new TngDbfField();
        byte t_byte = in.readByte();
        if (t_byte == 13) {
            return null;
        }
        in.readFully(field.fieldName, 1, 10);
        field.fieldName[0] = t_byte;
        for (int i2 = 0; i2 < field.fieldName.length; ++i2) {
            if (field.fieldName[i2] != 0) continue;
            field.nameNullIndex = i2;
            break;
        }
        field.dataType = in.readByte();
        field.reserv1 = TngDbfUtils.readLittleEndianInt(in);
        field.fieldLength = in.readUnsignedByte();
        field.decimalCount = in.readByte();
        field.reserv2 = TngDbfUtils.readLittleEndianShort(in);
        field.workAreaId = in.readByte();
        field.reserv2 = TngDbfUtils.readLittleEndianShort(in);
        field.setFieldsFlag = in.readByte();
        in.readFully(field.reserv4);
        field.indexFieldFlag = in.readByte();
        return field;
    }

    public String getFieldName() {
        return new String(this.fieldName);
    }

    protected void write(DataOutput out) throws IOException {
        out.write(this.fieldName);
        out.write(new byte[11 - this.fieldName.length]);
        out.writeByte(this.dataType);
        out.writeInt(0);
        out.writeByte(this.fieldLength);
        out.writeByte(this.decimalCount);
        out.writeShort(0);
        out.writeByte(0);
        out.writeShort(0);
        out.writeByte(0);
        out.write(new byte[7]);
        out.writeByte(0);
    }

    public String getName() {
        return new String(this.fieldName, 0, this.nameNullIndex);
    }

    public byte getDataType() {
        return this.dataType;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    @Deprecated
    public void setFieldName(String value) {
        this.setName(value);
    }

    public void setName(String value) {
        if (value == null) {
            throw new IllegalArgumentException(Nat.x("N\u00e1zov DBF polo\u017eky mus\u00ed byt zadan\u00fd"));
        }
        if (value.length() == 0 || value.length() > 10) {
            throw new IllegalArgumentException(Nat.x("N\u00e1zov DBF polo\u017eky mus\u00ed ma\u0165 0-10 znakov"));
        }
        this.fieldName = value.getBytes();
        this.nameNullIndex = this.fieldName.length;
    }

    public void setDataType(byte value) {
        switch (value) {
            case 68: {
                this.fieldLength = 8;
            }
            case 67: 
            case 70: 
            case 76: 
            case 77: 
            case 78: {
                this.dataType = value;
                break;
            }
            default: {
                throw new IllegalArgumentException(Nat.x("Nezn\u00e1my d\u00e1tovy typ DBF polo\u017eky"));
            }
        }
    }

    public void setFieldLength(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(Nat.x("Rozmer DBF polo\u017eky mus\u00ed by\u0165 v\u00e4\u010d\u0161\u00ed alebo rovn\u00fd nule"));
        }
        if (this.dataType == 68) {
            throw new UnsupportedOperationException(Nat.x("Nastavenie rozmeru pre d\u00e1tumov\u00fa DBF polo\u017eku nie je povolen\u00e9"));
        }
        this.fieldLength = value;
    }

    public void setDecimalCount(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(Nat.x("Po\u010det desatinn\u00fdch miest DBF polo\u017eky mus\u00ed by\u0165 v\u00e4\u010d\u0161\u00ed alebo rovn\u00fd nule"));
        }
        if (value > this.fieldLength) {
            throw new IllegalArgumentException(Nat.x("Po\u010det desatinn\u00fdch miest DBF polo\u017eky mus\u00ed by\u0165 men\u0161\u00ed ako rozmer DBF polo\u017eky"));
        }
        this.decimalCount = (byte)value;
    }

    @Override
    public E getValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
    }
}

