/*
 * Decompiled with CFR 0.152.
 */
package tangram.dbf;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import tangram.dbf.TngDbfBase;
import tangram.dbf.TngDbfField;
import tangram.dbf.TngDbfHeader;
import tangram.dbf.TngDbfUtils;
import tangram.exception.TngExceptionDbf;
import tangram.library.Nat;

public class TngDbfReader
extends TngDbfBase {
    private DataInputStream dataInputStream;
    private TngDbfHeader header;

    public TngDbfReader(InputStream in) throws TngExceptionDbf {
        try {
            this.dataInputStream = new DataInputStream(in);
            this.header = new TngDbfHeader();
            this.header.read(this.dataInputStream);
            int t_dataStartIndex = this.getHeader().getHeaderLength() - (32 + 32 * this.header.getFields().length) - 1;
            if (t_dataStartIndex > 0) {
                this.dataInputStream.skip(t_dataStartIndex);
            }
        }
        catch (Exception e2) {
            throw new TngExceptionDbf(e2.getMessage());
        }
    }

    public TngDbfHeader getHeader() {
        return this.header;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.header.toString());
        for (int i2 = 0; i2 < this.header.getFields().length; ++i2) {
            sb.append(this.getField(i2).getName());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getRecordCount() {
        return this.header.getNumberOfRecords();
    }

    public TngDbfField getField(int index) {
        return this.header.getFields()[index];
    }

    public int getFieldCount() {
        if (this.header.getFields() != null) {
            return this.header.getFields().length;
        }
        return -1;
    }

    public Object[] nextRecord() throws TngExceptionDbf {
        Object[] recordObjects = new Object[this.getFieldCount()];
        try {
            byte t_byte;
            boolean isDeleted = false;
            do {
                if (isDeleted) {
                    this.dataInputStream.skip(this.header.getRecordLength() - 1);
                }
                if ((t_byte = this.dataInputStream.readByte()) != 26) continue;
                return new Object[0];
            } while (isDeleted = t_byte == 42);
            block18: for (int i2 = 0; i2 < this.getFieldCount(); ++i2) {
                switch (this.getField(i2).getDataType()) {
                    case 67: {
                        byte[] b_array = new byte[this.getField(i2).getFieldLength()];
                        this.dataInputStream.read(b_array);
                        recordObjects[i2] = new String(b_array, this.characterSetName);
                        continue block18;
                    }
                    case 68: {
                        byte[] t_byte_year = new byte[4];
                        this.dataInputStream.read(t_byte_year);
                        byte[] t_byte_month = new byte[2];
                        this.dataInputStream.read(t_byte_month);
                        byte[] t_byte_day = new byte[2];
                        this.dataInputStream.read(t_byte_day);
                        try {
                            GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(new String(t_byte_year)), Integer.parseInt(new String(t_byte_month)) - 1, Integer.parseInt(new String(t_byte_day)));
                            recordObjects[i2] = calendar.getTime();
                        }
                        catch (NumberFormatException e2) {
                            recordObjects[i2] = null;
                        }
                        continue block18;
                    }
                    case 70: {
                        try {
                            byte[] t_float = new byte[this.getField(i2).getFieldLength()];
                            this.dataInputStream.read(t_float);
                            t_float = TngDbfUtils.trimLeftSpaces(t_float);
                            if (t_float.length > 0 && !TngDbfUtils.contains(t_float, (byte)63)) {
                                recordObjects[i2] = new Float(new String(t_float));
                                continue block18;
                            }
                            recordObjects[i2] = null;
                            continue block18;
                        }
                        catch (NumberFormatException e3) {
                            throw new TngExceptionDbf(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed Float hodnoty:") + " " + e3.getMessage());
                        }
                    }
                    case 78: {
                        try {
                            byte[] t_numeric = new byte[this.getField(i2).getFieldLength()];
                            this.dataInputStream.read(t_numeric);
                            t_numeric = TngDbfUtils.trimLeftSpaces(t_numeric);
                            if (t_numeric.length > 0 && !TngDbfUtils.contains(t_numeric, (byte)63)) {
                                recordObjects[i2] = new Double(new String(t_numeric));
                                continue block18;
                            }
                            recordObjects[i2] = null;
                            continue block18;
                        }
                        catch (NumberFormatException e4) {
                            throw new TngExceptionDbf(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed Number hodnoty:") + " " + e4.getMessage());
                        }
                    }
                    case 76: {
                        byte t_logical = this.dataInputStream.readByte();
                        if (t_logical == 89 || t_logical == 116 || t_logical == 84 || t_logical == 116) {
                            recordObjects[i2] = Boolean.TRUE;
                            continue block18;
                        }
                        recordObjects[i2] = Boolean.FALSE;
                        continue block18;
                    }
                    case 77: {
                        recordObjects[i2] = "null";
                        continue block18;
                    }
                    default: {
                        recordObjects[i2] = "null";
                    }
                }
            }
        }
        catch (EOFException e5) {
            return new Object[0];
        }
        catch (IOException e6) {
            throw new TngExceptionDbf(e6.getMessage());
        }
        return recordObjects;
    }
}

