/*
 * Decompiled with CFR 0.152.
 */
package tangram.devices;

import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import tangram.devices.TngPorts;
import tangram.devices.TngReadersListener;
import tangram.interfaces.TngReadable;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public final class TngCardReaderAhl
implements TngReadable,
Runnable {
    public static String DEF_COMPORT_PARAMS = "9600,E,8,1";
    public boolean LOGGING = false;
    private boolean opened;
    private String port;
    private TngReadersListener listener;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SerialPort serialPort;
    private Thread thread;
    private boolean running = false;
    private String lastCard = null;
    private int[] answer = new int[32];
    private static final char CMD_RESET = 'd';
    private static final char[] PACKET_RESET = new char[]{'\u0004', '\u00ff', 'd', '\u009f'};
    private static final char CMD_SUPPORTED_TAGS = '\u0080';
    private static final char[] PACKET_SUPPORTED_TAGS = new char[]{'\u0006', '\u00ff', '\u0080', '\u0000', '\u0001', 'x'};
    private static final char CMD_READ_CARD = '\u0011';
    private static final char[] PACKET_READ_CARD = new char[]{'\u0004', '\u00ff', '\u0011', '\u00ea'};

    @Override
    public String getName() {
        return Nat.x("\u010c\u00edta\u010dka kariet AHL");
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public void setListener(TngReadersListener listener) {
        this.listener = listener;
    }

    @Override
    public void open() throws Exception {
        this.close();
        if (this.listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.serialPortOpen(this.port);
        this.initialize();
        this.opened = true;
    }

    @Override
    public void close() {
        this.stopThread();
        this.serialPortClose();
        this.opened = false;
    }

    private void serialPortOpen(String port) throws Exception {
        if (this.LOGGING) {
            System.out.println(Nat.nox("Otv\u00e1ranie CardReaderAhl portu %1", port));
        }
        this.serialPort = TngPorts.openSerial(Nat.x("\u010c\u00edta\u010dka \u010dipov\u00fdch kariet AHL"), port, DEF_COMPORT_PARAMS);
        this.inputStream = this.serialPort.getInputStream();
        if (this.inputStream == null) {
            throw new Exception(Nat.x("S\u00e9riov\u00fd port %1 nie je mo\u017en\u00e9 otvori\u0165 pre \u010d\u00edtanie", port));
        }
        this.outputStream = this.serialPort.getOutputStream();
        if (this.outputStream == null) {
            throw new Exception(Nat.x("S\u00e9riov\u00fd port %1 nie je mo\u017en\u00e9 otvori\u0165 pre z\u00e1pis", port));
        }
        this.serialPort.notifyOnDataAvailable(false);
        this.serialPort.setFlowControlMode(0);
    }

    private void serialPortClose() {
        if (this.serialPort == null) {
            return;
        }
        try {
            if (this.LOGGING) {
                System.out.println(Nat.nox("Zatv\u00e1ranie CardReaderAhl portu %1", this.serialPort.getName()));
            }
            this.inputStream.close();
            this.inputStream = null;
            this.outputStream.close();
            this.outputStream = null;
            this.serialPort.close();
            this.serialPort = null;
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private synchronized void cardReaded(String cardcode) {
        this.listener.codeReaded(this, cardcode, 1);
    }

    private void initialize() throws Exception {
        this.commandReset();
        this.commandSupportedTags();
        this.startThread();
    }

    private void startThread() {
        this.thread = new Thread((Runnable)this, this.getName());
        this.thread.setDaemon(true);
        this.running = true;
        this.thread.start();
    }

    private void stopThread() {
        this.running = false;
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
    }

    @Override
    public void run() {
        if (this.LOGGING) {
            System.out.println("CardReaderAhl thread start");
        }
        while (this.running) {
            this.readCard();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e2) {
                // empty catch block
                break;
            }
        }
        if (this.LOGGING) {
            System.out.println("CardReaderAhl thread terminate");
        }
        this.running = false;
        this.thread = null;
    }

    private void readCard() {
        try {
            String card = this.commandReadCard();
            if (!(card == null || this.lastCard != null && this.lastCard.equals(card))) {
                this.cardReaded(card);
            }
            this.lastCard = card;
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private void sendCommand(char[] command) throws Exception {
        for (char c2 : command) {
            if (this.LOGGING) {
                System.out.println("CardReaderAhl write: " + c2);
            }
            this.outputStream.write(c2);
        }
        this.outputStream.flush();
    }

    private void receiveAnswer(char command, int maxBytes) throws Exception {
        int timeout = 0;
        int counter = 0;
        int c2 = 0;
        int crc = 0;
        while (true) {
            if ((c2 = this.inputStream.read()) == -1) {
                Thread.sleep(50L);
                if (timeout++ <= 30) continue;
                throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet nekomunikuje"));
            }
            if (this.LOGGING) {
                System.out.println("CardReaderAhl read: " + c2);
            }
            this.answer[counter] = c2;
            if (++counter > maxBytes) {
                throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet poslala pr\u00edli\u0161 dlh\u00fd paket"));
            }
            if (counter > 1 && this.answer[0] == counter) break;
            crc ^= c2;
        }
        if (crc != this.answer[counter - 1]) {
            throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet poslala paket, ale kontroln\u00fd s\u00fa\u010det paketu je chybn\u00fd"));
        }
        if (this.answer[2] != command) {
            throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet poslala neo\u010dak\u00e1van\u00fd paket"));
        }
    }

    private void commandReset() throws Exception {
        this.sendCommand(PACKET_RESET);
        this.receiveAnswer('d', 5);
        if (this.answer[0] != 5 || this.answer[3] != 0) {
            throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet poslala neo\u010dak\u00e1van\u00fa odpove\u010f"));
        }
    }

    private void commandSupportedTags() throws Exception {
        this.sendCommand(PACKET_SUPPORTED_TAGS);
        this.receiveAnswer('\u0080', 5);
        if (this.answer[0] != 5 || this.answer[3] != 0) {
            throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet poslala neo\u010dak\u00e1van\u00fa odpove\u010f"));
        }
    }

    private String commandReadCard() throws Exception {
        this.sendCommand(PACKET_READ_CARD);
        this.receiveAnswer('\u0011', 11);
        if (this.answer[0] == 5 && this.answer[3] == 1) {
            return null;
        }
        if (this.answer[0] == 11 && this.answer[3] == 0) {
            return TngCardReaderAhl.getHex(this.answer, 5, 5);
        }
        throw new Exception(Nat.x("\u010c\u00edta\u010dka kariet poslala neo\u010dak\u00e1van\u00fa odpove\u010f"));
    }

    public static String getHex(int[] raw, int from, int length) {
        StringBuilder hex = new StringBuilder(2 * length);
        for (int i2 = 0; i2 < length; ++i2) {
            TngUtilities.hexCharsFromInt(hex, raw[from + i2], 2);
        }
        return hex.toString();
    }
}

