/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm;

import java.util.ArrayList;
import tangram.dm.Column;
import tangram.dm.SchemaAccessorSql;
import tangram.dm.Table;

public class Difference {
    public static final int ADD_TABLE = 1;
    public static final int DELETE_TABLE = 2;
    public static final int ADD_COLUMN = 3;
    public static final int DELETE_COLUMN = 4;
    public static final int MODIFIED_COLUMN = 5;
    public static final int REPAIR_MODE_ALL = 0;
    public static final int REPAIR_MODE_BEFORE_SCRIPT = 1;
    public static final int REPAIR_MODE_AFTER_SCRIPT = 2;
    private static final int MODIFIED_FLAG_TYPE = 1;
    private static final int MODIFIED_FLAG_SIZE_GROW = 2;
    private static final int MODIFIED_FLAG_SIZE_SHRINK = 4;
    private static final int MODIFIED_FLAG_NOTNULL_ON = 8;
    private static final int MODIFIED_FLAG_NOTNULL_OFF = 16;
    private static final int MODIFIED_FLAG_DEFVALUE = 32;
    private static final String longAsString = "longAsString";
    public int action;
    public int modifiedFlags;
    public String tableName;
    public Table table;
    public Column column;
    public Column physColumn;
    public String infoText;
    private ArrayList<String> commands;

    public String toString() {
        return this.infoText;
    }

    public static int getModifiedFlags(Column column, Column physColumn) {
        String colDef;
        String destType = SchemaAccessorSql.columnTypeToPhys(column.type);
        if (!physColumn.type.equals(destType)) {
            return 1;
        }
        int flags = 0;
        if (physColumn.precision != column.precision || physColumn.scale != column.scale) {
            flags = column.precision < physColumn.precision || column.precision - column.scale < physColumn.precision - physColumn.scale ? (flags += 4) : (flags += 2);
        }
        if (physColumn.notNull != column.notNull) {
            flags += column.notNull ? 8 : 16;
        }
        String physDef = physColumn.defaultValue == null ? "" : physColumn.defaultValue;
        String string = colDef = column.defaultValue == null ? "" : column.defaultValue;
        if (!physDef.equals(colDef)) {
            flags += 32;
        }
        return flags;
    }

    public void repairDDL(int repairMode, ArrayList<String> commands) {
        this.commands = commands;
        if (repairMode == 0 || repairMode == 1) {
            this.repairBeforeDDL();
        }
        if (repairMode == 0 || repairMode == 2) {
            this.repairAfterDDL();
        }
    }

    private boolean repairBeforeDDL() {
        boolean changeDefvalue;
        if (this.action == 1) {
            return this.addCommand(SchemaAccessorSql.getTableDDL(this.table));
        }
        if (this.action == 3) {
            boolean useNotnull = this.column.notNull;
            boolean useDefvalue = this.column.defaultValue != null;
            return this.addCommand("ALTER TABLE " + this.tableName + " ADD " + this.columnDefinition(this.column.name, true, useNotnull, useDefvalue));
        }
        if (this.action != 5) {
            return false;
        }
        boolean changeSize = (this.modifiedFlags & 2) != 0;
        boolean changeNotnull = (this.modifiedFlags & 0x10) != 0;
        boolean bl = changeDefvalue = (this.modifiedFlags & 0x20) != 0;
        if ((this.modifiedFlags & 0xD) != 0) {
            changeDefvalue = false;
        }
        if (changeSize || changeNotnull || changeDefvalue) {
            return this.addCommand(this.alterTableModify(changeSize, changeNotnull, changeDefvalue));
        }
        return false;
    }

    private boolean repairAfterDDL() {
        boolean changeDefvalue;
        if (this.action == 2) {
            return this.addCommand("DROP TABLE \"" + this.tableName + "\"");
        }
        if (this.action == 4) {
            return this.addCommand("ALTER TABLE \"" + this.tableName + "\" DROP COLUMN \"" + this.physColumn.name + "\"");
        }
        if (this.action != 5) {
            return false;
        }
        if ((this.modifiedFlags & 1) != 0) {
            return this.addCommandsRecreate();
        }
        if ((this.modifiedFlags & 4) != 0) {
            if (this.column.type.equals("VARCHAR2")) {
                boolean bl = changeDefvalue = (this.modifiedFlags & 0x20) != 0;
                if ((this.modifiedFlags & 8) != 0) {
                    changeDefvalue = false;
                }
                this.addCommand("UPDATE " + this.tableName + " SET " + this.column.name + "=SUBSTR(" + this.column.name + ",1," + this.column.precision + ") WHERE LENGTH(" + this.column.name + ")>" + this.column.precision);
                this.addCommand(this.alterTableModify(true, false, changeDefvalue));
            } else {
                return this.addCommandsRecreate();
            }
        }
        if ((this.modifiedFlags & 8) != 0) {
            changeDefvalue = (this.modifiedFlags & 0x20) != 0 && (this.modifiedFlags & 4) == 0;
            this.addCommandsNotnull(changeDefvalue);
        }
        return (this.modifiedFlags & 0xC) != 0;
    }

    private boolean addCommand(String command) {
        this.commands.add(command);
        return true;
    }

    private void addCommandsNotnull(boolean changeDefvalue) {
        if (this.column.defaultValue != null) {
            this.addCommand("UPDATE " + this.tableName + " SET " + this.column.name + "=" + this.column.defaultValue + " WHERE " + this.column.name + " IS NULL");
        }
        this.addCommand(this.alterTableModify(false, true, changeDefvalue));
    }

    private boolean addCommandsRecreate() {
        String funcRetype = this.createFuncRetype();
        if (funcRetype == null) {
            boolean useNotnull = this.column.notNull;
            boolean useDefvalue = this.column.defaultValue != null;
            this.commands.add("ALTER TABLE " + this.tableName + " DROP COLUMN " + this.column.name);
            this.commands.add("ALTER TABLE " + this.tableName + " ADD " + this.columnDefinition(this.column.name, true, useNotnull, useDefvalue));
            return true;
        }
        String tmpcol = this.createTmpColumn();
        boolean useDefvalue = this.column.defaultValue != null;
        this.commands.add("ALTER TABLE " + this.tableName + " ADD " + this.columnDefinition(tmpcol, true, false, useDefvalue));
        this.commands.add(this.createRetypeUpdate(tmpcol, funcRetype));
        this.commands.add("ALTER TABLE " + this.tableName + " DROP COLUMN " + this.column.name);
        this.commands.add("ALTER TABLE " + this.tableName + " RENAME COLUMN " + tmpcol + " TO " + this.column.name);
        if (this.column.notNull) {
            this.addCommandsNotnull(false);
        }
        return true;
    }

    private String createTmpColumn() {
        String h2 = this.column.name;
        if (h2.length() > 29) {
            h2 = h2.substring(0, 29);
        }
        return "\"#" + h2 + "\"";
    }

    private String createRetypeUpdate(String tmpcol, String funcRetype) {
        if (!this.physColumn.type.equals("LONG")) {
            return "UPDATE " + this.tableName + " SET " + tmpcol + "=" + funcRetype + " WHERE " + this.column.name + " IS NOT NULL";
        }
        return "DECLARE\n CURSOR cur IS SELECT " + this.column.name + " FROM " + this.tableName + " FOR UPDATE;\n" + " " + longAsString + " VARCHAR2(4000);\n" + "BEGIN\n" + " FOR rec IN cur LOOP\n" + "  " + longAsString + ":=SUBSTR(rec." + this.column.name + ",1,4000);\n" + "  UPDATE " + this.tableName + " SET " + tmpcol + "=" + funcRetype + " WHERE CURRENT OF cur;\n" + " END LOOP;\n" + "END;";
    }

    private String createFuncRetype() {
        if ((this.modifiedFlags & 1) == 0) {
            return this.column.name;
        }
        String destType = SchemaAccessorSql.columnTypeToPhys(this.column.type);
        String physType = this.physColumn.type;
        String name = this.column.name;
        if (destType.equals("VARCHAR2")) {
            if (physType.equals("LONG")) {
                return "SUBSTR(longAsString,1," + this.column.precision + ")";
            }
            return "SUBSTR(TO_CHAR(" + name + "),1," + this.column.precision + ")";
        }
        if (destType.equals("LONG")) {
            return "TO_CHAR(" + name + ")";
        }
        if (destType.equals("NUMBER")) {
            if (physType.equals("VARCHAR2")) {
                return "TNG_CONV.ToNumber(" + name + ")";
            }
            if (physType.equals("LONG")) {
                return "TNG_CONV.ToNumber(longAsString)";
            }
            return null;
        }
        if (destType.equals("DATE")) {
            if (physType.equals("VARCHAR2")) {
                return "TNG_CONV.ToDate(" + name + ")";
            }
            if (physType.equals("LONG")) {
                return "TNG_CONV.ToDate(longAsString)";
            }
            if (physType.equals("TIMESTAMP")) {
                return name;
            }
            return null;
        }
        if (destType.equals("TIMESTAMP")) {
            if (physType.equals("VARCHAR2")) {
                return "TNG_CONV.ToTimestamp(" + name + ")";
            }
            if (physType.equals("LONG")) {
                return "TNG_CONV.ToTimestamp(longAsString)";
            }
            if (physType.equals("DATE")) {
                return name;
            }
            return null;
        }
        return null;
    }

    private String alterTableModify(boolean useTypeOrSize, boolean useNotnull, boolean useDefvalue) {
        return "ALTER TABLE " + this.tableName + " MODIFY (" + this.columnDefinition(this.column.name, useTypeOrSize, useNotnull, useDefvalue) + ")";
    }

    private String columnDefinition(String columnName, boolean useTypeOrSize, boolean useNotnull, boolean useDefvalue) {
        StringBuilder ddl = new StringBuilder();
        String physType = SchemaAccessorSql.columnTypeToPhys(this.column.type);
        ddl.append(columnName);
        if (useTypeOrSize) {
            ddl.append(' ');
            ddl.append(physType);
            if (this.column.precision != 0) {
                ddl.append('(');
                ddl.append(this.column.precision);
                if (this.column.scale != 0) {
                    ddl.append(',');
                    ddl.append(this.column.scale);
                }
                ddl.append(')');
            }
        }
        if (useDefvalue) {
            ddl.append(" DEFAULT ");
            if (this.column.defaultValue != null) {
                ddl.append(this.column.defaultValue);
            } else {
                ddl.append("NULL");
            }
        }
        if (useNotnull) {
            if (this.column.notNull) {
                ddl.append(" NOT NULL");
            } else {
                ddl.append(" NULL");
            }
        }
        return ddl.toString();
    }
}

