/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import tangram.dm.External;
import tangram.dm.Package;
import tangram.dm.Root;
import tangram.dm.Script;
import tangram.dm.Sequence;
import tangram.dm.Table;
import tangram.dm.Version;
import tangram.dm.View;
import tangram.library.Nat;

@XmlRootElement(name="template")
public class Schema
extends Root {
    public static final Version PACKAGE_VERSION = new Version("1.00");
    @XmlAttribute
    public Version version;
    @XmlElementWrapper
    @XmlElement(name="table")
    public ArrayList<Table> tables = new ArrayList();
    @XmlElementWrapper
    @XmlElement(name="view")
    public ArrayList<View> views = new ArrayList();
    @XmlElementWrapper
    @XmlElement(name="package")
    public ArrayList<Package> packages = new ArrayList();
    @XmlElementWrapper
    @XmlElement(name="sequence")
    public ArrayList<Sequence> sequences = new ArrayList();
    @XmlElementWrapper
    @XmlElement(name="script")
    public ArrayList<Script> scripts = new ArrayList();
    @XmlElementWrapper
    @XmlElement(name="external")
    public ArrayList<External> externals = new ArrayList();
    private static final String desc = Nat.x("XML \u0161abl\u00f3na");

    public void extend(Schema schema) {
        this.extendTables(this.tables, schema.tables);
        this.extendObjects(this.views, schema.views);
        this.extendObjects(this.packages, schema.packages);
        this.extendObjects(this.sequences, schema.sequences);
        this.extendObjects(this.scripts, schema.scripts);
        this.extendObjects(this.externals, schema.externals);
    }

    private void extendTables(ArrayList<Table> tables, ArrayList<Table> tablesExtend) {
        for (int i2 = 0; i2 < tablesExtend.size(); ++i2) {
            Table t = tablesExtend.get(i2);
            Table f2 = this.findObject(tables, t.name);
            if (f2 != null) {
                this.extendObjects(f2.columns, t.columns);
                this.extendObjects(f2.indexes, t.indexes);
                continue;
            }
            tables.add(t);
        }
    }

    private <U extends Root> void extendObjects(ArrayList<U> list, ArrayList<U> extend) {
        for (int i2 = 0; i2 < extend.size(); ++i2) {
            Root r2 = (Root)extend.get(i2);
            U f2 = this.findObject(list, r2.name);
            if (f2 != null) continue;
            list.add(r2);
        }
    }

    public <U extends Root> U findObject(ArrayList<U> list, String name) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Root r2 = (Root)list.get(i2);
            if (!r2.name.equals(name)) continue;
            return (U)r2;
        }
        return null;
    }

    public void normalize(String source, String normSchemaName, Version normVersion) throws Exception {
        int i2;
        normSchemaName = normSchemaName.toUpperCase();
        String owner = this.normalizeName(source, desc);
        if (normSchemaName != null && !this.name.equals(normSchemaName)) {
            throw new Exception(Nat.x("%1 je typu %2, vy\u017eaduje sa typ %3 (TEMPLATE->NAME)", owner, this.name, normSchemaName));
        }
        if (this.versionFrom == null) {
            throw new Exception(Nat.x("%1 nem\u00e1 zadan\u00fa verziu form\u00e1tu (TEMPLATE->VERSIONFROM)", owner));
        }
        if (this.versionFrom.compareTo(PACKAGE_VERSION) > 0) {
            throw new Exception(Nat.x("%1 m\u00e1 verziu form\u00e1tu %2, tento program umo\u017e\u0148uje pracova\u0165 do verzie form\u00e1tu %3 (TEMPLATE->VERSIONFROM)", owner, this.versionFrom, PACKAGE_VERSION));
        }
        if (normVersion != null) {
            if (this.version == null) {
                throw new Exception(Nat.x("%1 nem\u00e1 zadan\u00fa verziu (TEMPLATE->VERSION)", owner));
            }
            if (this.version.compareTo(normVersion) != 0) {
                throw new Exception(Nat.x("%1 je verzie %2, vy\u017eaduje sa verzia %3 (TEMPLATE->VERSION)", owner, this.version, normVersion));
            }
        }
        for (i2 = 0; i2 < this.tables.size(); ++i2) {
            this.tables.get(i2).normalize(owner);
        }
        for (i2 = 0; i2 < this.views.size(); ++i2) {
            this.views.get(i2).normalize(owner);
        }
        for (i2 = 0; i2 < this.packages.size(); ++i2) {
            this.packages.get(i2).normalize(owner);
        }
        for (i2 = 0; i2 < this.sequences.size(); ++i2) {
            this.sequences.get(i2).normalize(owner);
        }
        for (i2 = 0; i2 < this.scripts.size(); ++i2) {
            this.scripts.get(i2).normalize(owner);
        }
    }
}

