/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm.buffer;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import tangram.dm.buffer.TngDmBufferLoader;
import tangram.dm.buffer.TngDmField;
import tangram.exception.TngException;
import tangram.exception.TngExceptionNoChange;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class TngDmBuffer {
    public static final String KEYWORDS_SUFFIX = "_K_";
    protected boolean autoCommit = true;
    protected final TngDmBufferLoader loader = new TngDmBufferLoader(this);

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    private void autocommit(TngConnection conn) throws Exception {
        if (this.isAutoCommit()) {
            conn.commit();
        }
    }

    public TngDmBufferLoader getLoader() {
        return this.loader;
    }

    protected String getTableName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    protected final void afterConstruct() {
        try {
            List<TngDmField> dmFields = this.loader.getDmFieldsAll();
            for (TngDmField dmField : dmFields) {
                if (TngUtilities.isEmpty(this.getTableName())) continue;
                dmField.setFullName(this.getTableName() + "." + dmField.getName());
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public List<TngDmField> getPrimaryFields() {
        return new ArrayList<TngDmField>();
    }

    public String getPrimaryFieldsAsString() throws Exception {
        List<TngDmField> primaryFields = this.getPrimaryFields();
        return TngDmBuffer.generateColumn(primaryFields, Append.NAME);
    }

    public boolean select(TngConnection conn, TngDmField ... whereFields) throws Exception {
        return this.select(conn, Arrays.asList(whereFields));
    }

    public boolean select(TngConnection conn, List<TngDmField> whereFieldsList) throws Exception {
        String select = this.generateSelect();
        select = select + this.generateWhere(whereFieldsList);
        return this.statementRead(conn, select, whereFieldsList);
    }

    public boolean select(TngConnection conn, String where) throws Exception {
        String select = this.generateSelect();
        select = select + " " + where;
        return this.statementRead(conn, select, null);
    }

    public void insert(TngConnection conn) throws Exception {
        List<TngDmField> changedFields = this.loader.getDmFieldsChanged();
        if (changedFields.size() == 0) {
            throw new TngExceptionNoChange();
        }
        String insert = this.generateInsert(changedFields);
        this.statementWrite(conn, insert, changedFields, null);
    }

    public void copy(TngConnection conn) throws Exception {
        List<TngDmField> allFields = this.loader.getDmFieldsAll();
        String copy = this.generateCopy(allFields);
        this.statementWrite(conn, copy, allFields, null);
    }

    public void update(TngConnection conn, TngDmField ... whereFields) throws Exception {
        this.update(conn, Arrays.asList(whereFields));
    }

    public void update(TngConnection conn, List<TngDmField> whereFieldsList) throws Exception {
        List<TngDmField> changedFields = this.loader.getDmFieldsChanged();
        if (changedFields.size() == 0) {
            throw new TngExceptionNoChange();
        }
        String update = this.generateUpdate(changedFields);
        update = update + this.generateWhere(whereFieldsList);
        this.statementWrite(conn, update, changedFields, whereFieldsList);
    }

    public void update(TngConnection conn, String where) throws Exception {
        List<TngDmField> changedFields = this.loader.getDmFieldsChanged();
        if (changedFields.size() == 0) {
            throw new TngExceptionNoChange();
        }
        String update = this.generateUpdate(changedFields);
        update = update + " " + where;
        this.statementWrite(conn, update, changedFields, null);
    }

    public void delete(TngConnection conn, TngDmField ... whereFields) throws Exception {
        this.delete(conn, Arrays.asList(whereFields));
    }

    public void delete(TngConnection conn, List<TngDmField> whereFieldsList) throws Exception {
        String delete = this.generateDelete();
        delete = delete + this.generateWhere(whereFieldsList);
        this.statementWrite(conn, delete, null, whereFieldsList);
    }

    public void delete(TngConnection conn, String where) throws Exception {
        String delete = this.generateDelete();
        delete = delete + " " + where;
        this.statementWrite(conn, delete, null, null);
    }

    public boolean selectByPrimaryKeys(TngConnection conn, Object ... keyValues) throws Exception {
        return this.select(conn, this.getWhereByPrimaryKeys(keyValues));
    }

    public void updateByPrimaryKeys(TngConnection conn, Object ... keyValues) throws Exception {
        this.update(conn, this.getWhereByPrimaryKeys(keyValues));
    }

    public void deleteByPrimaryKeys(TngConnection conn, Object ... keyValues) throws Exception {
        this.delete(conn, this.getWhereByPrimaryKeys(keyValues));
    }

    public List<TngDmField> getWhereByPrimaryKeys(Object ... keyValues) throws Exception {
        List<TngDmField> primaryFields = this.getPrimaryFields();
        if (primaryFields == null || primaryFields.size() == 0) {
            throw new TngException(Nat.x("Nedefinovan\u00fd prim\u00e1rny k\u013e\u00fa\u010d pre tabu\u013eku %1", this.getTableName()));
        }
        if (keyValues == null || keyValues.length != primaryFields.size()) {
            throw new TngException(Nat.x("Nespr\u00e1vny po\u010det hodn\u00f4t pre filtrovanie pod\u013ea prim\u00e1rneho k\u013e\u00fa\u010da (%1)", this.getPrimaryFieldsAsString()));
        }
        ArrayList<TngDmField> whereFields = new ArrayList<TngDmField>();
        for (TngDmField primaryField : primaryFields) {
            TngDmField primaryFieldWhere = (TngDmField)primaryField.clone();
            primaryFieldWhere.setValue(keyValues[0], true);
            whereFields.add(primaryFieldWhere);
        }
        return whereFields;
    }

    private String generateSelect() throws Exception {
        StringBuilder select = new StringBuilder();
        select.append("SELECT ");
        List<TngDmField> dmFields = this.loader.getDmFieldsAll();
        select.append(TngDmBuffer.generateColumn(dmFields, Append.NAME));
        select.append(" FROM " + this.getTableName());
        return select.toString();
    }

    private String generateInsert(List<TngDmField> changedFields) throws Exception {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO " + this.getTableName() + "(");
        insert.append(TngDmBuffer.generateColumn(changedFields, Append.NAME));
        insert.append(this.loader.generateXcolumnsIns(false));
        insert.append(") VALUES (");
        insert.append(TngDmBuffer.generateColumn(changedFields, Append.VALUE_INS));
        insert.append(this.loader.generateXcolumnsIns(true));
        insert.append(")");
        return insert.toString();
    }

    private String generateUpdate(List<TngDmField> changedFields) throws Exception {
        StringBuilder update = new StringBuilder();
        update.append("UPDATE " + this.getTableName() + " SET ");
        update.append(TngDmBuffer.generateColumn(changedFields, Append.VALUE_UPD));
        update.append(this.loader.generateXcolumnsUpd(true));
        return update.toString();
    }

    private String generateCopy(List<TngDmField> changedFields) throws Exception {
        StringBuilder copy = new StringBuilder();
        copy.append("INSERT INTO " + this.getTableName() + "(");
        copy.append(TngDmBuffer.generateColumn(changedFields, Append.NAME));
        copy.append(") VALUES (");
        copy.append(TngDmBuffer.generateColumn(changedFields, Append.VALUE_INS));
        copy.append(")");
        return copy.toString();
    }

    private String generateDelete() throws Exception {
        StringBuilder select = new StringBuilder();
        select.append("DELETE FROM " + this.getTableName());
        return select.toString();
    }

    private String generateWhere(List<TngDmField> whereFields) throws Exception {
        if (whereFields == null || whereFields.size() == 0) {
            return "";
        }
        return " WHERE " + TngDmBuffer.generateColumn(whereFields, Append.WHERE);
    }

    private String generateOrderBy(List<TngDmField> whereFields) throws Exception {
        if (whereFields == null || whereFields.size() == 0) {
            return "";
        }
        return " ORDER BY " + TngDmBuffer.generateColumn(whereFields, Append.WHERE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean statementRead(TngConnection conn, String query, List<TngDmField> whereFields) throws Exception {
        PreparedStatement pst = null;
        try {
            pst = this.statementPrepare(conn, query, null, whereFields);
            boolean bl = this.readData(pst.executeQuery());
            conn.close(pst);
            return bl;
        }
        catch (Throwable throwable) {
            conn.close(pst);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statementWrite(TngConnection conn, String query, List<TngDmField> changedFields, List<TngDmField> whereFields) throws Exception {
        PreparedStatement pst = null;
        try {
            pst = this.statementPrepare(conn, query, changedFields, whereFields);
            pst.execute();
            this.autocommit(conn);
            conn.close(pst);
        }
        catch (Throwable throwable) {
            conn.close(pst);
            throw throwable;
        }
    }

    private PreparedStatement statementPrepare(TngConnection conn, String query, List<TngDmField> changedField, List<TngDmField> whereFields) throws Exception {
        PreparedStatement pst = conn.prepareStatement(query);
        int pc = 1;
        pc = this.writeStatementFields(pst, pc, changedField);
        pc = this.writeStatementFields(pst, pc, whereFields);
        return pst;
    }

    private boolean readData(ResultSet resultSet) throws Exception {
        if (!resultSet.next()) {
            return false;
        }
        List<TngDmField> dmFields = this.loader.getDmFieldsAll();
        for (TngDmField dmField : dmFields) {
            String name = dmField.getName();
            String type = dmField.getType();
            if (type.equals("DATE") || type.equals("TIMESTAMP")) {
                Timestamp timeStamp = resultSet.getTimestamp(name);
                dmField.setValue(timeStamp == null ? null : new Date(timeStamp.getTime()), true);
                continue;
            }
            if (type.equals("NUMBER") && dmField.getScale() == 0) {
                dmField.setValue(resultSet.getInt(name), true);
                continue;
            }
            dmField.setValue(resultSet.getObject(name), true);
        }
        return true;
    }

    private int writeStatementFields(PreparedStatement pst, int pcStart, List<TngDmField> fields) throws Exception {
        if (fields != null) {
            for (TngDmField field : fields) {
                this.writeStatementField(pst, pcStart, field);
                ++pcStart;
            }
        }
        return pcStart;
    }

    private void writeStatementField(PreparedStatement pst, int pc, TngDmField dmField) throws Exception {
        Object value = dmField.getValue();
        if (value == null) {
            pst.setObject(pc, null);
            return;
        }
        String type = dmField.getType();
        if (type.equals("DATE") || type.equals("TIMESTAMP")) {
            Date dValue = (Date)value;
            if (TngUtilities.dateHasTime(dValue)) {
                pst.setTimestamp(pc, TngDmBuffer.getSqlTimestamp(dValue));
            } else {
                pst.setDate(pc, TngDmBuffer.getSqlDate(dValue));
            }
        } else if (type.equals("NUMBER") && dmField.getScale() == 0) {
            pst.setInt(pc, TngUtilities.strToInt(value, 0));
        } else {
            pst.setObject(pc, value);
        }
    }

    public boolean hasChanged() throws Exception {
        return this.loader.hasChanged();
    }

    public int countAll(TngConnection conn) throws Exception {
        return this.count(conn, null);
    }

    public int count(TngConnection conn, String where) throws Exception {
        String queryInt = "SELECT COUNT(*) FROM " + this.getTableName();
        if (!TngUtilities.isEmpty(where)) {
            queryInt = queryInt + where;
        }
        return conn.queryInt(queryInt);
    }

    private static String generateColumn(List<TngDmField> dmFields, Append appendType) throws Exception {
        if (dmFields == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        for (int i2 = 0; i2 < dmFields.size(); ++i2) {
            String dmFieldName = dmFields.get(i2).getName();
            if (appendType == Append.NAME) {
                value.append(dmFieldName);
            } else if (appendType == Append.VALUE_INS) {
                value.append("?");
            } else if (appendType == Append.VALUE_UPD) {
                value.append(dmFieldName + "=?");
            } else if (appendType == Append.WHERE) {
                value.append(dmFieldName + "=?");
            }
            if (i2 == dmFields.size() - 1) continue;
            value.append(appendType == Append.WHERE ? " AND " : ",");
        }
        return value.toString();
    }

    public static java.sql.Date getSqlDate(Date datum) {
        return datum == null ? null : new java.sql.Date(datum.getTime());
    }

    public static Timestamp getSqlTimestamp(Date datum) {
        return datum == null ? null : new Timestamp(datum.getTime());
    }

    public static <E extends TngDmBuffer> List<E> loadAll(TngConnection conn, E buffer) throws Exception {
        return TngDmBuffer.loadAll(conn, buffer, "", "ORDER BY " + buffer.getPrimaryFieldsAsString());
    }

    public static <E extends TngDmBuffer> List<E> loadAll(TngConnection conn, E buffer, List<TngDmField> whereFields, List<TngDmField> orderbyFields) throws Exception {
        return TngDmBuffer.loadAll(conn, buffer, super.generateWhere(whereFields), super.generateOrderBy(orderbyFields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends TngDmBuffer> List<E> loadAll(TngConnection conn, E buffer, String where, String orderby) throws Exception {
        List<TngDmField> primaryFields = buffer.getPrimaryFields();
        String tableName = buffer.getTableName();
        String query = "SELECT " + buffer.getPrimaryFieldsAsString() + " FROM " + tableName + " " + where + " " + orderby;
        ArrayList<TngDmBuffer> bufferList = new ArrayList<TngDmBuffer>();
        Statement st = null;
        try {
            st = conn.execStatement(st, query);
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                Object[] data = new Object[primaryFields.size()];
                for (int i2 = 0; i2 < data.length; ++i2) {
                    data[i2] = rs.getObject(i2 + 1);
                }
                TngDmBuffer bufferItem = (TngDmBuffer)buffer.getClass().newInstance();
                bufferItem.selectByPrimaryKeys(conn, data);
                bufferList.add(bufferItem);
            }
        }
        finally {
            conn.close(st);
        }
        return bufferList;
    }

    private static enum Append {
        NAME,
        VALUE_INS,
        VALUE_UPD,
        WHERE;

    }
}

