/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm.buffer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangram.dm.buffer.TngDmBuffer;
import tangram.dm.buffer.TngDmField;
import tangram.library.TngUtilities;

public class TngDmBufferLoader {
    private TngDmBuffer buffer;
    private static Map<String, String> Xins = new HashMap<String, String>();
    private static Map<String, String> Xupd = new HashMap<String, String>();

    public TngDmBufferLoader(TngDmBuffer buffer) {
        this.buffer = buffer;
    }

    public List<TngDmField> getDmFieldsAll() throws Exception {
        return this.getDmFields(false);
    }

    public List<TngDmField> getDmFieldsChanged() throws Exception {
        return this.getDmFields(true);
    }

    public boolean hasChanged() throws Exception {
        return this.getDmFieldsChanged().size() != 0;
    }

    public String generateXcolumnsIns(boolean appendValue) throws Exception {
        return this.generateXcolumns(Xins, appendValue);
    }

    public String generateXcolumnsUpd(boolean appendValue) throws Exception {
        return this.generateXcolumns(Xupd, appendValue);
    }

    private List<Field> getFields() throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        TngDmBufferLoader.getFieldsRecursive(fields, this.buffer.getClass());
        return fields;
    }

    private List<TngDmField> getDmFields(boolean onlyChanged) throws Exception {
        List<Field> fields = this.getFields();
        ArrayList<TngDmField> dmFields = new ArrayList<TngDmField>();
        for (Field field : fields) {
            TngDmField dmField = this.getDmField(field);
            if (dmField == null || onlyChanged && !dmField.valueChanged()) continue;
            dmFields.add(dmField);
        }
        return dmFields;
    }

    private TngDmField getDmField(Field field) throws Exception {
        Object fieldValue = field.get(this.buffer);
        if (!(fieldValue instanceof TngDmField)) {
            return null;
        }
        return (TngDmField)fieldValue;
    }

    private String generateXcolumns(Map<String, String> xNames, boolean appendValue) throws Exception {
        List<TngDmField> dmFields = this.getDmFieldsAll();
        List<TngDmField> changedDmFields = this.getDmFieldsChanged();
        StringBuilder value = new StringBuilder();
        for (String xName : xNames.keySet()) {
            if (!TngDmBufferLoader.isXcolumn(dmFields, xName) || TngDmBufferLoader.isXcolumn(changedDmFields, xName)) continue;
            value.append("," + (appendValue ? xNames.get(xName) : xName));
        }
        String valueAsStr = value.toString();
        int valueLength = valueAsStr.length();
        return valueLength == 0 ? "" : TngUtilities.strLeft(valueAsStr, valueLength);
    }

    private static boolean isXcolumn(List<TngDmField> dmFields, String xName) {
        for (TngDmField dmField : dmFields) {
            if (!dmField.getName().equalsIgnoreCase(xName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isXcolumn(TngDmField dmField) {
        String dmFieldName = dmField.getName();
        for (String xName : Xins.keySet()) {
            if (!dmFieldName.equalsIgnoreCase(xName)) continue;
            return true;
        }
        for (String xName : Xupd.keySet()) {
            if (!dmFieldName.equalsIgnoreCase(xName)) continue;
            return true;
        }
        return false;
    }

    private static void getFieldsRecursive(List<Field> fields, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == TngDmBuffer.class) {
            for (Field field : clazz.getDeclaredFields()) {
                fields.add(field);
            }
        } else {
            TngDmBufferLoader.getFieldsRecursive(fields, superclazz);
        }
    }

    static {
        Xins.put("xc", "1");
        Xins.put("xio", "user");
        Xins.put("xid", "sysdate");
        Xupd.put("xc", "xc=xc+1");
        Xupd.put("xuo", "xuo=user");
        Xupd.put("xud", "xud=sysdate");
    }
}

