/*
 * Decompiled with CFR 0.152.
 */
package tangram.exception;

import tangram.exception.TngException;
import tangram.library.Nat;

public class TngExceptionLine
extends TngException {
    private final String line;
    private final int lineNumber;

    public TngExceptionLine(String message, String line, int lineNumber) {
        super(TngExceptionLine.createMessage(message, line, lineNumber));
        this.line = line;
        this.lineNumber = lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private static String createMessage(String message, String line, int lineNumber) {
        message = message + "\n" + Nat.x("Riadok: %1", lineNumber);
        if (line != null) {
            String l2 = line;
            if (l2.length() > 127) {
                l2 = l2.substring(0, 127) + "...";
            }
            message = message + " -> " + l2;
        }
        return message;
    }
}

