/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter;

import java.util.Vector;
import tangram.filter.item.TngFilterItem;
import tangram.library.TngParams;

public class TngFilterSet
implements Cloneable {
    protected Vector<TngFilterItem> items = new Vector();
    protected String label;

    public TngFilterSet clone() {
        try {
            TngFilterSet clone = (TngFilterSet)super.clone();
            clone.items = (Vector)this.items.clone();
            for (int i2 = 0; i2 < clone.items.size(); ++i2) {
                clone.items.set(i2, (TngFilterItem)clone.items.get(i2).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int size() {
        return this.items.size();
    }

    public void add(TngFilterItem filterItem) {
        this.items.add(filterItem);
    }

    public TngFilterItem get(int index) {
        return this.items.get(index);
    }

    public TngFilterItem find(String name) {
        if (name == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!name.equals(filterItem.getName())) continue;
            return filterItem;
        }
        return null;
    }

    public TngFilterItem remove(String name) {
        if (name == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!name.equals(filterItem.getName())) continue;
            this.items.remove(i2);
            return filterItem;
        }
        return null;
    }

    public String createFilterExpression() {
        StringBuilder buff = new StringBuilder();
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!filterItem.hasValue()) continue;
            if (buff.length() != 0) {
                buff.append("\nAND ");
            }
            buff.append(filterItem.createFilterExpression());
        }
        return buff.toString();
    }

    public String createFilterDescription() {
        StringBuilder buff = new StringBuilder();
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!filterItem.hasValue()) continue;
            if (buff.length() != 0) {
                buff.append(" a ");
            }
            buff.append(filterItem.createFilterDescription());
        }
        return buff.toString();
    }

    public void reset() {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!filterItem.isEditable()) continue;
            filterItem.reset();
        }
    }

    public void save(TngParams params) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!filterItem.isEditable()) continue;
            filterItem.save(params);
        }
    }

    public void load(TngParams params) {
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            TngFilterItem filterItem = this.items.get(i2);
            if (!filterItem.isEditable()) continue;
            filterItem.load(params);
        }
    }
}

