/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import tangram.library.TngUtilities;

public final class TngFilterUtilities {
    public static final char LIST_DIV = ';';
    public static final char LIST_DIV_KOD = '-';
    public static final SimpleDateFormat fmtSqlDate = new SimpleDateFormat("dd.MM.yyyy");

    public static String stringToSql(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        value = value.replace("'", "''");
        return "'" + value + "'";
    }

    public static String dateToSql(Date date) {
        return date == null ? null : "'" + fmtSqlDate.format(date) + "'";
    }

    public static String numberToSql(BigDecimal number) {
        return number == null ? null : number.toString().replace(',', '.');
    }

    public static String integerToSql(Integer number) {
        return number == null ? null : number.toString();
    }

    public static String getListItem(String kod, String[] list) {
        int f2 = TngFilterUtilities.findListItem(kod, list);
        if (f2 < 0) {
            return kod + '-' + "?";
        }
        return list[f2];
    }

    public static int findListItem(String kod, String[] list) {
        if (kod == null || kod.length() == 0 || list == null || list.length == 0) {
            return -1;
        }
        kod = kod + '-';
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (!list[i2].startsWith(kod)) continue;
            return i2;
        }
        return -1;
    }

    public static String[] tokenizeList(String zstring) {
        return TngFilterUtilities.tokenizeList(zstring, false);
    }

    public static String[] tokenizeList(String zstring, boolean deleteDuplicates) {
        if (zstring == null || zstring.length() == 0) {
            return new String[0];
        }
        String[] items = TngUtilities.strTokenizeNotNull(zstring, ';');
        String[] pure = new String[items.length];
        int count = 0;
        for (int i2 = 0; i2 < items.length; ++i2) {
            String h2 = items[i2].trim();
            if (deleteDuplicates && h2.length() != 0) {
                for (int y = 0; y < count; ++y) {
                    if (pure[y] == null || !pure[y].equals(h2)) continue;
                    h2 = null;
                    break;
                }
            }
            if (h2 == null || h2.length() == 0) continue;
            pure[count++] = h2;
        }
        if (count == 0) {
            return new String[0];
        }
        items = new String[count];
        if (pure.length == count) {
            return pure;
        }
        System.arraycopy(pure, 0, items, 0, count);
        return items;
    }
}

