/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import tangram.exception.TngExceptionSql;
import tangram.forms.TngFormFillerUo;
import tangram.forms.TngFormSqlScript;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormDefaultValue;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngJournalFile;
import tangram.library.TngUtilities;
import tangram.swing.panel.TngProgressableWorker;

public abstract class TngFormFiller<E> {
    protected E data;
    protected TngConnection conn;
    protected TngProgressableWorker worker;
    protected TngJournalFile journalFile;
    protected TngForm form;
    protected TngFormSqlScript sqlScript;
    protected TngFormFillerUo uo;

    public void setConnection(TngConnection conn) {
        this.conn = conn;
    }

    public void setData(E data) {
        this.data = data;
    }

    public void setWorker(TngProgressableWorker worker) {
        this.worker = worker;
    }

    public void setJournalFile(TngJournalFile journalFile) {
        this.journalFile = journalFile;
    }

    public void setForm(TngForm form) {
        this.form = form;
    }

    public void setFormSqlScript(TngFormSqlScript sqlScript) {
        this.sqlScript = sqlScript;
    }

    protected void addJournalInfo(String group, String msg) {
        if (this.journalFile != null) {
            this.journalFile.info(msg, null, group);
        }
    }

    protected void addJournalError(String group, String error) {
        if (this.journalFile != null) {
            this.journalFile.error(error, null, group);
        }
    }

    public abstract void setDefaultValue(TngFormDefaultValue var1) throws Exception;

    public abstract void fill() throws Exception;

    public void load() throws Exception {
    }

    public void setDefaultValues() throws Exception {
        if (this.form == null && this.form.getDefaultValues() == null) {
            return;
        }
        for (TngFormDefaultValue defaultValue : this.form.getDefaultValues()) {
            this.setDefaultValue(defaultValue);
        }
    }

    public void save() throws Exception {
    }

    protected void resolvePeriod(String uo) throws Exception {
        this.uo = TngFormFillerUo.fromUo(uo);
        if (this.uo == null) {
            throw new Exception(Nat.x("Dokument nie je mo\u017en\u00e9 vyplni\u0165, \u00fa\u010dtovn\u00e9 obdobie nie je zadan\u00e9 spr\u00e1vne"));
        }
    }

    protected String getDefaultValue(String expression) {
        String value = this.getDefaultValueForSimpleSelect(expression);
        if (value == null) {
            value = this.getDefaultValueForSelect(expression);
        }
        if (value == null) {
            value = expression;
        }
        return value;
    }

    protected String getDefaultValueForSimpleSelect(String simpleSelect) {
        String[] tokens = TngUtilities.strTokenizeNotNull(simpleSelect, ':');
        if (tokens.length < 3) {
            return null;
        }
        String select = "select " + tokens[0] + " from " + tokens[1] + " where " + tokens[2];
        return this.getDefaultValueForSelect(select);
    }

    protected String getDefaultValueForSelect(String select) {
        try {
            Object value = this.conn.queryObject(select);
            return value == null ? "" : value.toString();
        }
        catch (TngExceptionSql e2) {
            return null;
        }
    }
}

