/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.util.Calendar;
import java.util.GregorianCalendar;
import tangram.library.TngUtilities;

public class TngFormFillerUo {
    private int year;
    private int month;
    private int quartal;
    private Calendar start;
    private Calendar end;

    private TngFormFillerUo() {
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getQuartal() {
        return this.quartal;
    }

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public boolean isQuartal() {
        return this.getQuartal() != 0;
    }

    public static TngFormFillerUo fromUo(String uo) {
        TngFormFillerUo fillerUo = new TngFormFillerUo();
        if (TngUtilities.isEmpty(uo) || uo.length() != 6) {
            return null;
        }
        int year = TngUtilities.strToInt(TngUtilities.strLeft(uo, 4), -1);
        if (year == -1) {
            return null;
        }
        fillerUo.year = year;
        String monthStr = TngUtilities.strSubstrOrNull(uo, 4, 2);
        if (TngUtilities.isEmpty(monthStr) || monthStr.length() != 2) {
            return null;
        }
        if (monthStr.charAt(0) == 'Q') {
            int quartal = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(monthStr, 1, 1), -1);
            if (quartal < 1 || quartal > 4) {
                return null;
            }
            fillerUo.quartal = quartal;
        } else {
            int month = TngUtilities.strToInt(monthStr, -1);
            if (month < 1 || month > 12) {
                return null;
            }
            fillerUo.month = month;
        }
        int monthStart = fillerUo.isQuartal() ? fillerUo.month : fillerUo.quartal * 3 - 2;
        int monthEnd = fillerUo.isQuartal() ? fillerUo.month : fillerUo.quartal * 3;
        fillerUo.start = new GregorianCalendar(year, monthStart - 1, 1);
        fillerUo.end = new GregorianCalendar(year, monthEnd - 1, 1);
        fillerUo.end.setTime(TngUtilities.dateMonthEnd(fillerUo.end.getTime()));
        return fillerUo;
    }
}

