/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.XfaForm;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import tangram.exception.TngException;
import tangram.forms.TngFormDataAccessor;
import tangram.forms.TngFormZipFile;
import tangram.forms.TngForms;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormObject;
import tangram.interfaces.TngProgressable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngFileChooser;
import tangram.swing.panel.TngProgressableWorker;

public class TngFormPdfOperator {
    public static File createTempPdf() throws Exception {
        File tmpFile = File.createTempFile("Doc_", ".pdf");
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public static PdfReader createPdfReader(InputStream sourcePdf) throws Exception {
        PdfReader pdfReader = new PdfReader(sourcePdf);
        return pdfReader;
    }

    public static PdfReader createPdfReaderPartial(File sourcePdf) throws Exception {
        PdfReader pdfReader = new PdfReader(sourcePdf.getAbsolutePath(), (byte[])null, true);
        return pdfReader;
    }

    public static void closeStamperSafe(PdfStamper pdfStamper) {
        try {
            if (pdfStamper != null) {
                pdfStamper.addJavaScript("this.calculateNow();");
                pdfStamper.setFullCompression();
                pdfStamper.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(InputStream sourcePdf, File targetPdf, TngFormDataAccessor dataAccessor, TngProgressable worker) throws Exception {
        worker.setProgressStatus(Nat.x("Z\u00e1pis \u00fadajov"));
        PdfStamper pdfStamper = null;
        try {
            PdfReader pdfReader = TngFormPdfOperator.createPdfReader(sourcePdf);
            pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(targetPdf), '\u0000', true);
            TngFormPdfOperator.loadData(pdfStamper, dataAccessor, worker);
        }
        catch (Throwable throwable) {
            TngFormPdfOperator.closeStamperSafe(pdfStamper);
            throw throwable;
        }
        TngFormPdfOperator.closeStamperSafe(pdfStamper);
    }

    private static void loadData(PdfStamper pdfStamper, TngFormDataAccessor dataAccessor, TngProgressable worker) throws Exception {
        AcroFields acroFields = pdfStamper.getAcroFields();
        XfaForm xfa = acroFields.getXfa();
        if (xfa.isXfaPresent()) {
            TngFormPdfOperator.loadDataXfa(xfa, dataAccessor, worker);
        } else {
            TngFormPdfOperator.loadDataAcrofields(acroFields, dataAccessor, worker);
        }
    }

    private static void loadDataXfa(XfaForm xfaForm, TngFormDataAccessor dataAccessor, TngProgressable worker) throws Exception {
        TngForm form = TngForms.loadStruct(dataAccessor.getFormat());
        List<TngFormObject> formObjects = form.getObjects();
        worker.setProgressMax(formObjects.size());
        for (TngFormObject formObject : formObjects) {
            worker.addProgressValue(1);
            String path = formObject.getPath();
            String name = formObject.getName();
            Node node = xfaForm.getDatasetsNode();
            XfaForm.Xml2SomDatasets som = new XfaForm.Xml2SomDatasets(node);
            for (Map.Entry<String, Node> entry : som.getName2Node().entrySet()) {
                String key = entry.getKey();
                if (!key.equals(path)) continue;
                Node value = entry.getValue();
                for (int i2 = 0; i2 < value.getAttributes().getLength(); ++i2) {
                    Node item = value.getAttributes().item(i2);
                    if (!name.equals(item.getLocalName())) continue;
                    item.setTextContent(dataAccessor.getValue(name));
                }
            }
        }
        xfaForm.setChanged(true);
    }

    private static void loadDataAcrofields(AcroFields acroFields, TngFormDataAccessor dataAccessor, TngProgressable worker) throws Exception {
        Set<String> fields = acroFields.getFields().keySet();
        worker.setProgressMax(fields.size());
        for (String field : fields) {
            worker.addProgressValue(1);
            String value = dataAccessor.getValue(field);
            if (TngUtilities.isEmpty(value)) continue;
            acroFields.setField(field, value);
        }
    }

    public static void exportFinalPdf(final TngFormDataAccessor dataAccessor) throws Exception {
        TngFileChooser fileChooser = new TngFileChooser();
        fileChooser.setDialogTitle(Nat.x("Umiestnenie s\u00faboru"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.addFileFilterExtension("PDF s\u00fabory", "pdf");
        if (fileChooser.showDialog(TngSwing.mainWindow, Nat.x("Ulo\u017ei\u0165")) != 0) {
            return;
        }
        String fileName = fileChooser.getSelectedFile().getAbsolutePath();
        if (!fileName.endsWith(".pdf")) {
            fileName = fileName + ".pdf";
        }
        final File targetPdf = new File(fileName);
        TngProgressableWorker worker = new TngProgressableWorker(Nat.x("Export PDF s\u00faboru")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void compute() throws Exception {
                this.setProgressStatus(Nat.x("Vytv\u00e1ranie s\u00faboru"));
                TngFormZipFile formZipFile = TngForms.openFormZipFile();
                String entryName = TngForms.getZipEntryName(dataAccessor.getFormat(), "_Original", "pdf");
                try {
                    InputStream sourcePdf = formZipFile.getZippedInputStream(entryName);
                    TngFormPdfOperator.load(sourcePdf, targetPdf, dataAccessor, this);
                    Desktop.getDesktop().open(targetPdf);
                }
                finally {
                    TngForms.closeFormZipFile(formZipFile);
                }
            }
        };
        try {
            worker.setProgressCancelable(true);
            worker.start();
        }
        catch (TngException e2) {
            TngSwing.msgError(e2.getMessage());
        }
        catch (Exception e3) {
            TngSwing.exceptionShow(e3);
        }
    }
}

