/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tangram.forms.TngFormScriptWizard;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormObject;
import tangram.forms.struct.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.forms.visual.components.TngFormFieldDecimal;
import tangram.forms.visual.components.TngFormFieldInteger;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.panel.TngDlg;

public class TngFormScriptOperator {
    private String expressionLeft;
    private String expressionRight;
    private final List<String> expressionLeftTokens = new ArrayList<String>();
    private final List<String> expressionRightTokens = new ArrayList<String>();
    private TngFormScript formScript;
    private static Pattern pattern;

    public TngFormScriptOperator(TngFormScript formScript) {
        this.formScript = formScript;
    }

    public void initializeScript(String expression) {
        this.resolveExpression(expression);
        this.resolveExpressionTokens(this.expressionLeftTokens, this.expressionLeft);
        this.resolveExpressionTokens(this.expressionRightTokens, this.expressionRight);
    }

    private void resolveExpression(String expression) {
        if (TngUtilities.isEmpty(expression)) {
            return;
        }
        int indexOfEquals = expression.indexOf(61);
        if (indexOfEquals == -1 || indexOfEquals == expression.length() - 1) {
            return;
        }
        this.expressionLeft = expression.substring(0, indexOfEquals).trim();
        this.expressionRight = expression.substring(indexOfEquals + 1).trim();
    }

    private List<String> resolveExpressionTokens(List<String> expressionTokens, String expressionPart) {
        if (pattern == null) {
            pattern = Pattern.compile("\\{.*?\\}");
        }
        Matcher matcher = pattern.matcher(expressionPart == null ? "" : expressionPart);
        while (matcher.find()) {
            expressionTokens.add(matcher.group(0).replace("{", "").replace("}", ""));
        }
        return expressionTokens;
    }

    public void initializeObjects(List<TngFormObject> formObjects) {
        this.initializeObjectsByExpressionLeftTokens(formObjects);
        this.initializeObjectsByExpressionRightTokens(formObjects);
    }

    private void initializeObjectsByExpressionLeftTokens(List<TngFormObject> formObjects) {
        for (String leftToken : this.expressionLeftTokens) {
            for (TngFormObject formObject : formObjects) {
                if (!formObject.getName().equalsIgnoreCase(leftToken)) continue;
                formObject.setScriptLeft(true);
            }
        }
    }

    private void initializeObjectsByExpressionRightTokens(List<TngFormObject> formObjects) {
        for (String rightToken : this.expressionRightTokens) {
            for (TngFormObject formObject : formObjects) {
                if (!formObject.getName().equalsIgnoreCase(rightToken)) continue;
                formObject.setScriptRight(true);
            }
        }
    }

    public void executeScript(List<TngFormComponent> formComponents) {
        String leftTokenFirst = this.expressionLeftTokens.size() == 0 ? null : this.expressionLeftTokens.get(0);
        for (TngFormComponent formComponent : formComponents) {
            if (!formComponent.isNamed(leftTokenFirst)) continue;
            String eval = this.prepareScriptEval(formComponents);
            this.executeEval(formComponent, eval);
        }
    }

    private String prepareScriptEval(List<TngFormComponent> formComponents) {
        String eval = this.expressionRight;
        for (String expressionRightToken : this.expressionRightTokens) {
            for (TngFormComponent formComponent : formComponents) {
                String value;
                if (!formComponent.isNamed(expressionRightToken)) continue;
                String replace = value = formComponent.getValue();
                if (formComponent instanceof TngFormFieldDecimal) {
                    BigDecimal valueBd = TngUtilities.numberOrZero(TngUtilities.stringToNumber(value));
                    replace = "(" + String.valueOf(valueBd) + ")";
                } else if (formComponent instanceof TngFormFieldInteger) {
                    int valueInt = TngUtilities.strToInt(value, Integer.MIN_VALUE);
                    replace = "(" + String.valueOf(valueInt == Integer.MIN_VALUE ? 0 : valueInt) + ")";
                } else {
                    replace = "'" + (TngUtilities.isEmpty(value) ? "" : value) + "'";
                }
                eval = eval.replace("{" + expressionRightToken + "}", replace);
            }
        }
        return eval;
    }

    private void executeEval(TngFormComponent leftComponent, String eval) {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        try {
            Object obj = engine.eval(eval);
            leftComponent.setValue(obj == null ? null : obj.toString());
        }
        catch (ScriptException e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri prepo\u010d\u00edtavan\u00ed \u00fadajov") + "\n\n" + leftComponent.getFormObject().getName() + " (" + leftComponent.getFormObject().getName() + ") => '" + eval + "'", e2);
        }
    }

    public void wizard(TngForm form, List<TngFormComponent> formComponents, TngFormObject leftFormObject) {
        String leftTokenFirst;
        String string = leftTokenFirst = this.expressionLeftTokens.size() == 0 ? null : this.expressionLeftTokens.get(0);
        if (!leftFormObject.getName().equalsIgnoreCase(leftTokenFirst)) {
            return;
        }
        ArrayList<TngFormComponent> formComponentsCopy = new ArrayList<TngFormComponent>();
        for (String expressionRightToken : this.expressionRightTokens) {
            for (TngFormComponent formComponent : formComponents) {
                if (!formComponent.isNamed(expressionRightToken)) continue;
                TngFormComponent formComponentCopy = TngFormComponent.createFromFormObject(form, formComponent.getFormObject());
                formComponentCopy.setValue(formComponent.getValue());
                formComponentsCopy.add(formComponentCopy);
            }
        }
        TngFormComponent leftFormComponentCopy = TngFormComponent.createFromFormObject(form, leftFormObject);
        formComponentsCopy.add(leftFormComponentCopy);
        TngFormScriptWizard wizard = new TngFormScriptWizard();
        wizard.setData(this.formScript, formComponentsCopy);
        wizard.setTitle(Nat.x("Rozpis riadka %1", leftFormObject.getDescription()));
        if (!TngDlg.runModal(wizard, 7)) {
            return;
        }
        for (TngFormComponent formComponent : formComponents) {
            if (!formComponent.getFormObject().isVirtual()) continue;
            for (TngFormComponent formComponentCopy : formComponentsCopy) {
                if (!formComponentCopy.getFormObject().isVirtual()) continue;
                formComponent.setValue(formComponentCopy.getValue());
            }
        }
        this.formScript.getOperator().executeScript(formComponents);
    }
}

