/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import tangram.exception.TngExceptionSql;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class TngFormSqlScript {
    private String script;
    private final Map<String, String> replaces = new HashMap<String, String>();
    private static final SimpleDateFormat fmtDate = new SimpleDateFormat("yyyy-MM-dd");

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void putReplaceString(String key, String value) {
        this.replaces.put(key, value);
    }

    public void putReplaceDate(String key, Date value) {
        this.putReplaceString(key, fmtDate.format(value));
    }

    public void execute(TngConnection conn) throws Exception {
        if (TngUtilities.isEmpty(this.script)) {
            return;
        }
        String[] commands = TngUtilities.strTokenizeNotNull(this.script, ';');
        try {
            for (String command : commands) {
                if (TngUtilities.isEmpty(command = command.trim())) continue;
                for (Map.Entry<String, String> replace : this.replaces.entrySet()) {
                    String key = replace.getKey();
                    String value = replace.getValue();
                    command = command.replace(key, value);
                }
                conn.exec(command);
            }
            conn.commit();
        }
        catch (TngExceptionSql e2) {
            conn.rollback();
            throw e2;
        }
    }

    public static TngFormSqlScript fromInputStream(InputStream inputStream) {
        TngFormSqlScript sqlScript = new TngFormSqlScript();
        sqlScript.setScript(new Scanner(inputStream).useDelimiter("\\Z").next());
        return sqlScript;
    }
}

