/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.script;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import tangram.forms.TngFormGroup;
import tangram.forms.script.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.forms.visual.components.TngFormComboBox;
import tangram.library.TngUtilities;

public class TngFormScriptEnabledIf
extends TngFormScript<TngFormComponent> {
    public static final String NAME = "EnabledIf";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void execute() {
        String[] params = TngUtilities.strTokenizeNotNull(this.param, ',');
        if (params.length < 2) {
            return;
        }
        TngFormGroup group = this.form.getGroup(params[0]);
        if (group != null) {
            this.executeGroup(group, params);
        } else {
            TngFormComponent target1 = this.getFormComponentByName(params[0]);
            if (target1 instanceof TngFormComboBox) {
                this.executeComboBox((TngFormComboBox)target1, params);
            }
        }
    }

    private void executeGroup(TngFormGroup group, final String[] params) {
        ButtonGroup buttonGroup = group.getButtonGroup();
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    boolean enabled = false;
                    for (int i2 = 1; i2 < params.length && !enabled; ++i2) {
                        if (params[i2] == null || !params[i2].equalsIgnoreCase(TngFormScriptEnabledIf.this.form.getGroupValue(params[0]))) continue;
                        enabled = true;
                    }
                    TngFormScriptEnabledIf.this.source.getComponent().setEnabled(enabled);
                }
            });
        }
    }

    private void executeComboBox(final TngFormComboBox target, final String[] params) {
        target.getComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() != 1) {
                    return;
                }
                boolean enabled = false;
                for (int i2 = 1; i2 < params.length && !enabled; ++i2) {
                    if (!params[i2].equalsIgnoreCase(target.getValue())) continue;
                    enabled = true;
                }
                TngFormScriptEnabledIf.this.source.getComponent().setEnabled(enabled);
            }
        });
    }
}

