/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.script;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tangram.forms.script.TngFormScript;
import tangram.forms.struct.TngFormObjectComboBox;
import tangram.forms.visual.TngFormComponent;
import tangram.forms.visual.components.TngFormComboBox;
import tangram.library.TngUtilities;

public class TngFormScriptFilterComboBox
extends TngFormScript<TngFormComboBox> {
    public static final String NAME = "FilterComboBox";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void execute() {
        ((TngFormComboBox)this.source).getComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() != 1) {
                    return;
                }
                TngFormScriptFilterComboBox.this.filterComboBox();
            }
        });
    }

    private void filterComboBox() {
        TngFormComponent target1 = this.getFormComponentByName(this.param);
        if (!(target1 instanceof TngFormComboBox)) {
            return;
        }
        HashSet<String> filteredOptions = new HashSet<String>();
        this.loadFilteredOptions(filteredOptions);
        TngFormComboBox target = (TngFormComboBox)target1;
        target.getComponent().removeAllItems();
        List<TngFormObjectComboBox.Option> targetOptions = target.getFormObject().getOptions();
        if (targetOptions != null) {
            for (TngFormObjectComboBox.Option targetOption : targetOptions) {
                if (!filteredOptions.contains(targetOption.getExport())) continue;
                target.getComponent().addItem(targetOption);
            }
        }
    }

    private void loadFilteredOptions(Set<String> filteredOptions) {
        Object sourceSelectedItem = ((TngFormComboBox)this.source).getComponent().getSelectedItem();
        if (!(sourceSelectedItem instanceof TngFormObjectComboBox.Option)) {
            return;
        }
        TngFormObjectComboBox.Option sourceOption = (TngFormObjectComboBox.Option)sourceSelectedItem;
        String sourceOptionScript = sourceOption.getScript();
        String[] sourceOptionScriptTokens = TngUtilities.strTokenizeNotNull(sourceOptionScript, ';');
        String toSearch = this.getName() + "(" + this.param + ")";
        for (String token : sourceOptionScriptTokens) {
            String[] optionParamsTokens;
            int indexOfToken = token.indexOf(toSearch);
            if (indexOfToken == -1 && indexOfToken >= token.length()) continue;
            String optionParams = token.substring(1 + indexOfToken + toSearch.length());
            for (String optionParamsToken : optionParamsTokens = TngUtilities.strTokenizeNotNull(optionParams, ',')) {
                filteredOptions.add(optionParamsToken);
            }
        }
    }
}

