/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.struct;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import tangram.forms.TngFormGroup;
import tangram.forms.struct.TngFormDefaultValue;
import tangram.forms.struct.TngFormObject;
import tangram.forms.struct.TngFormObjectGroupable;
import tangram.forms.struct.TngFormPage;
import tangram.forms.struct.TngFormRoot;
import tangram.forms.struct.TngFormScript;
import tangram.library.TngUtilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="form")
@XmlType(propOrder={"scripts", "defaultValues", "pages", "dynamic"})
public class TngForm
extends TngFormRoot {
    @XmlElement
    private boolean dynamic;
    @XmlElementWrapper
    @XmlElement(name="page")
    private List<TngFormPage> pages = new ArrayList<TngFormPage>();
    @XmlElementWrapper
    @XmlElement(name="defaultValue")
    private List<TngFormDefaultValue> defaultValues = new ArrayList<TngFormDefaultValue>();
    @XmlElementWrapper
    @XmlElement(name="script")
    private List<TngFormScript> scripts = new ArrayList<TngFormScript>();
    @XmlTransient
    private final Map<String, TngFormGroup> groups = new HashMap<String, TngFormGroup>();
    @XmlTransient
    private boolean fromCache;

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setPages(List<TngFormPage> pages) {
        this.pages = pages;
    }

    public List<TngFormPage> getPages() {
        return this.pages;
    }

    public void setDefaultValues(List<TngFormDefaultValue> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public List<TngFormDefaultValue> getDefaultValues() {
        return this.defaultValues;
    }

    public void setScripts(List<TngFormScript> scripts) {
        this.scripts = scripts;
    }

    public List<TngFormScript> getScripts() {
        return this.scripts;
    }

    public void addPage(TngFormPage page) {
        this.pages.add(page);
    }

    public TngFormPage getPage(int page) {
        return this.pages.get(page);
    }

    public Map<String, TngFormGroup> getGroups() {
        return this.groups;
    }

    public void addGroup(String name, TngFormObjectGroupable groupable, AbstractButton button) {
        if (this.groups.containsKey(name)) {
            TngFormGroup group = this.groups.get(name);
            group.add(groupable, button);
        } else {
            TngFormGroup group = new TngFormGroup();
            group.add(groupable, button);
            this.groups.put(name, group);
        }
    }

    public String getGroupValue(String name) {
        TngFormGroup group = this.getGroup(name);
        if (group == null) {
            return null;
        }
        String value = null;
        ButtonGroup buttonGroup = group.getButtonGroup();
        Enumeration<AbstractButton> buttonGroupElements = buttonGroup.getElements();
        int pc = 0;
        while (buttonGroupElements.hasMoreElements()) {
            AbstractButton buttonGroupElement = buttonGroupElements.nextElement();
            if (buttonGroupElement.isSelected()) {
                value = TngUtilities.strExt(value, ",", group.getGroupable(pc).getTrueValue());
            }
            ++pc;
        }
        return value;
    }

    public TngFormGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public void setFromCache(boolean fromCache) {
        this.fromCache = fromCache;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public void initialize() throws Exception {
        this.initializeScripts();
    }

    private void initializeScripts() throws Exception {
        Collections.sort(this.getScripts(), new TngFormScriptComparator());
        for (TngFormScript formScript : this.getScripts()) {
            formScript.getOperator().initializeScript(formScript.getExpression());
            formScript.getOperator().initializeObjects(this.getObjects());
        }
    }

    public List<TngFormObject> getObjects() {
        ArrayList<TngFormObject> formObject = new ArrayList<TngFormObject>();
        for (int i2 = 0; i2 < this.getPages().size(); ++i2) {
            TngFormPage formPage = this.getPages().get(i2);
            formPage.orderObjects();
            formObject.addAll(formPage.getObjects());
        }
        return formObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TngForm unmarshal(InputStream stream) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TngForm.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            TngForm form = (TngForm)unmarshaller.unmarshal(stream);
            form.initialize();
            TngForm tngForm = form;
            return tngForm;
        }
        finally {
            TngUtilities.streamCloseSafe(stream);
        }
    }

    public void marshal(File xmlFile) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TngForm.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)this, xmlFile);
    }

    public static class TngFormScriptComparator
    implements Comparator<TngFormScript> {
        @Override
        public int compare(TngFormScript o1, TngFormScript o2) {
            if (o1.getOrder() < o2.getOrder()) {
                return -1;
            }
            if (o1.getOrder() > o2.getOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

