/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tangram.dm.buffer.TngDmBufferCached;
import tangram.dm.buffer.eko.ext.DochExt;
import tangram.dm.buffer.eko.ext.Dph_priznaniaExt;
import tangram.exception.TngException;
import tangram.exception.TngExceptionAbort;
import tangram.forms.TngFormDataAccessor;
import tangram.forms.TngFormDataAccessorDoch;
import tangram.forms.TngFormDataAccessorDphPriznania;
import tangram.forms.TngFormPdfOperator;
import tangram.forms.TngForms;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.forms.visual.TngFormPanel;
import tangram.library.Nat;
import tangram.report.visual.TngReportPanelPageJumpTo;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButtonToolbar;
import tangram.swing.container.TngScrollPane;
import tangram.swing.icon.TngIcon;
import tangram.swing.mdi.TngMdiChild;
import tangram.swing.mdi.TngMdiMain;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngProgressableWorker;

public class TngFormViewer
extends TngPanel {
    protected JPanel jPanelToolbar = new JPanel();
    protected TngButtonToolbar jPagePrevious = new TngButtonToolbar();
    protected TngButtonToolbar jPageNext = new TngButtonToolbar();
    protected TngButtonToolbar jPageFirst = new TngButtonToolbar();
    protected TngButtonToolbar jPageLast = new TngButtonToolbar();
    protected TngButtonToolbar jPageJumpTo = new TngButtonToolbar();
    protected TngButtonToolbar jZoomOut = new TngButtonToolbar();
    protected TngButtonToolbar jZoomIn = new TngButtonToolbar();
    protected TngButtonToolbar jZoomDefault = new TngButtonToolbar();
    protected TngButtonToolbar jRefresh = new TngButtonToolbar();
    protected TngButtonToolbar jConfig = new TngButtonToolbar();
    protected TngButtonToolbar jPrintDefault = new TngButtonToolbar();
    protected TngButtonToolbar jPrint = new TngButtonToolbar();
    protected TngButtonToolbar jSave = new TngButtonToolbar();
    protected TngButtonToolbar jExportPdf = new TngButtonToolbar();
    protected TngButtonToolbar jExit = new TngButtonToolbar();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanelTop = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private TngLabel jPosition = new TngLabel();
    private TngScrollPane jScrollPane1 = new TngScrollPane();
    protected TngFormPanel formPanel = new TngFormPanel();
    protected TngForm form;
    protected TngFormDataAccessor formDataAccessor;
    private static final int SCROLL = 48;
    private final Rectangle topLeftRect = new Rectangle(0, 0);

    public TngFormViewer() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(1024, 600));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (TngFormViewer.this.formPanel != null) {
                    TngFormViewer.this.formPanel.componentResized();
                    TngFormViewer.this.formPanel.refreshPage();
                }
            }
        });
        this.formPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.scrollLeftRight(-1);
            }
        }, KeyStroke.getKeyStroke(37, 0), 2);
        this.formPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.scrollLeftRight(1);
            }
        }, KeyStroke.getKeyStroke(39, 0), 2);
        this.formPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.scrollUpDown(-1);
            }
        }, KeyStroke.getKeyStroke(38, 0), 2);
        this.formPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.scrollUpDown(1);
            }
        }, KeyStroke.getKeyStroke(40, 0), 2);
        this.jPanelToolbar.setLayout(this.gridBagLayout4);
        this.jPagePrevious.setIcon(TngIcon.getIcon("report/page_previous.png"));
        this.jPagePrevious.setToolTipText(Nat.x("Predch\u00e1dzaj\u00faca str\u00e1nka"));
        this.jPagePrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formPreviousPage();
            }
        });
        this.jPageNext.setIcon(TngIcon.getIcon("report/page_next.png"));
        this.jPageNext.setToolTipText(Nat.x("Nasleduj\u00faca str\u00e1nka"));
        this.jPageNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formNextPage();
            }
        });
        this.jPageFirst.setIcon(TngIcon.getIcon("report/page_first.png"));
        this.jPageFirst.setToolTipText(Nat.x("Prv\u00e1 str\u00e1nka"));
        this.jPageFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formFirstPage();
            }
        });
        this.jPageLast.setIcon(TngIcon.getIcon("report/page_last.png"));
        this.jPageLast.setToolTipText(Nat.x("Posledn\u00e1 str\u00e1nka"));
        this.jPageLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formLastPage();
            }
        });
        this.jPageJumpTo.setIcon(TngIcon.getIcon("report/page_jump_to.png"));
        this.jPageJumpTo.setToolTipText(Nat.x("Skok na str\u00e1nku"));
        this.jPageJumpTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formToPage();
            }
        });
        this.jZoomOut.setIcon(TngIcon.getIcon("report/zoom_out.png"));
        this.jZoomOut.setToolTipText(Nat.x("Zmen\u0161i\u0165"));
        this.jZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formZoomOut();
            }
        });
        this.jZoomIn.setIcon(TngIcon.getIcon("report/zoom_in.png"));
        this.jZoomIn.setToolTipText(Nat.x("Zv\u00e4\u010d\u0161i\u0165"));
        this.jZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formZoomIn();
            }
        });
        this.jZoomDefault.setIcon(TngIcon.getIcon("report/zoom_default.png"));
        this.jZoomDefault.setToolTipText(Nat.x("P\u00f4vodn\u00e1 ve\u013ekos\u0165"));
        this.jZoomDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formFitClear();
            }
        });
        this.jRefresh.setIcon(TngIcon.getIcon("report/refresh.png"));
        this.jRefresh.setToolTipText(Nat.x("Obnovi\u0165 obsah obrazovky") + " <F9>");
        this.jRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.refreshForm();
            }
        });
        this.jRefresh.setHitKey(120, 0);
        this.jConfig.setIcon(TngIcon.getIcon("report/filter.png"));
        this.jConfig.setToolTipText(Nat.x("V\u00fdberov\u00e1 podmienka a \u010fal\u0161ie parametre") + " <F5>");
        this.jConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formConfig();
            }
        });
        this.jConfig.setHitKey(116, 0);
        this.jSave.setIcon(TngIcon.getIcon("toolbar/file_write.png"));
        this.jSave.setToolTipText(Nat.x("Ulo\u017ei\u0165") + " <F6>");
        this.jSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formSave();
            }
        });
        this.jSave.setHitKey(117, 0);
        this.jPrintDefault.setIcon(TngIcon.getIcon("report/print_default.png"));
        this.jPrintDefault.setToolTipText(Nat.x("Tla\u010d") + " <F7>");
        this.jPrintDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formPrintDefault();
            }
        });
        this.jPrintDefault.setHitKey(118, 0);
        this.jPrint.setIcon(TngIcon.getIcon("report/print.png"));
        this.jPrint.setToolTipText(Nat.x("Tla\u010d s nastaven\u00edm") + " <Ctrl+F7>");
        this.jPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formPrint();
            }
        });
        this.jPrint.setHitKey(118, 2);
        this.jExportPdf.setIcon(TngIcon.getIcon("report/export_pdf.png"));
        this.jExportPdf.setToolTipText(Nat.x("Export do PDF") + " <F8>");
        this.jExportPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formExportPdf();
            }
        });
        this.jExportPdf.setHitKey(119, 0);
        this.jExit.setIcon(TngIcon.getIcon("report/exit.png"));
        this.jExit.setToolTipText(Nat.x("Ukon\u010denie") + " <Esc>");
        this.jExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngFormViewer.this.formExit();
            }
        });
        this.jExit.setHitKey(27, 0);
        this.jPanelTop.setLayout(this.gridBagLayout3);
        this.jPosition.setText(Nat.nox("0/0"));
        this.jPosition.setHorizontalAlignment(2);
        this.jPanelToolbar.add((Component)this.jPagePrevious, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageNext, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageFirst, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageLast, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageJumpTo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jZoomOut, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jZoomIn, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jZoomDefault, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jRefresh, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jConfig, new GridBagConstraints(11, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jSave, new GridBagConstraints(12, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPrintDefault, new GridBagConstraints(13, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPrint, new GridBagConstraints(14, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jExportPdf, new GridBagConstraints(15, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jExit, new GridBagConstraints(16, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPosition, new GridBagConstraints(17, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelTop.add((Component)this.jPanelToolbar, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanelTop, "North");
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanelTop.setBackground(null);
        this.jPanelTop.setPreferredSize(new Dimension(0, 36));
        this.jPanelToolbar.setBackground(null);
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.jScrollPane1.setViewportView(this.formPanel);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(evt.getNewValue() instanceof JComponent)) {
                    return;
                }
                JComponent focused = (JComponent)evt.getNewValue();
                if (TngFormViewer.this.formPanel.isAncestorOf(focused) && !focused.getVisibleRect().getSize().equals(focused.getSize())) {
                    TngFormViewer.this.formPanel.scrollRectToVisible(focused.getBounds());
                }
            }
        });
    }

    public void setData(TngFormDataAccessor formDataAccessor) {
        this.formDataAccessor = formDataAccessor;
    }

    public void loadForm() {
        TngProgressableWorker worker = new TngProgressableWorker(Nat.x("Na\u010d\u00edtavanie formul\u00e1ra")){

            @Override
            public void compute() throws Exception {
                this.setProgressStatus(Nat.x("Na\u010d\u00edtavanie \u0161trukt\u00fary"));
                TngFormViewer.this.form = TngForms.loadStruct(TngFormViewer.this.formDataAccessor.getFormat());
                TngFormViewer.this.formPanel.loadForm(TngFormViewer.this.form, this);
                this.setProgressStatus(Nat.x("Na\u010d\u00edtavanie \u00fadajov"));
                TngFormViewer.this.loadData(this);
                TngFormViewer.this.jScrollPane1.validate();
                TngFormViewer.this.scrollAndRefreshPage();
            }
        };
        try {
            worker.setProgressCancelable(true);
            worker.start();
        }
        catch (TngException e2) {
            TngSwing.msgError(e2.getMessage());
        }
        catch (Exception e3) {
            TngSwing.exceptionShow(e3);
        }
    }

    protected boolean isFormEmpty() {
        if (this.formPanel == null || !this.formPanel.hasPages()) {
            TngSwing.msgWarning(Nat.x("Formul\u00e1r je pr\u00e1zdny"));
            return true;
        }
        return false;
    }

    private void scrollLeftRight(int i2) {
        int val = this.jScrollPane1.getHorizontalScrollBar().getModel().getValue();
        this.jScrollPane1.getHorizontalScrollBar().getModel().setValue(val += i2 * 48);
    }

    private void scrollUpDown(int i2) {
        int val = this.jScrollPane1.getVerticalScrollBar().getModel().getValue();
        this.jScrollPane1.getVerticalScrollBar().getModel().setValue(val += i2 * 48);
    }

    private void refreshForm() {
        if (!this.saveOnDemand()) {
            return;
        }
        this.loadForm();
    }

    private void refreshPage() {
        this.formPanel.refreshPage();
    }

    private void scrollAndRefreshPage() {
        this.resolvePaginator();
        this.jPosition.setText(this.formPanel.getPageIndex() + 1 + "/" + this.formPanel.getPageCount());
        this.formPanel.scrollRectToVisible(this.topLeftRect);
        this.refreshPage();
    }

    private void resolvePaginator() {
        this.jPagePrevious.setEnabled(!this.formPanel.hasPages() || this.formPanel.getPageIndex() != 0);
        this.jPageFirst.setEnabled(!this.formPanel.hasPages() || this.formPanel.getPageIndex() != 0);
        this.jPageNext.setEnabled(!this.formPanel.hasPages() || this.formPanel.getPageIndex() != this.formPanel.getPageCount() - 1);
        this.jPageLast.setEnabled(!this.formPanel.hasPages() || this.formPanel.getPageIndex() != this.formPanel.getPageCount() - 1);
        this.jPageJumpTo.setEnabled(this.formPanel.hasPages());
    }

    private void formPreviousPage() {
        this.loadPage(this.formPanel.getPageIndex() - 1);
    }

    private void formNextPage() {
        this.loadPage(this.formPanel.getPageIndex() + 1);
    }

    private void formFirstPage() {
        this.loadPage(0);
    }

    private void formLastPage() {
        this.loadPage(this.formPanel.getPageCount() - 1);
    }

    private void formToPage() {
        TngReportPanelPageJumpTo p2 = new TngReportPanelPageJumpTo();
        p2.setRestriction(1, this.formPanel.getPageCount());
        if (!TngDlg.runModal(p2)) {
            return;
        }
        int page = p2.getPage() - 1;
        if (page < 0 || page > this.formPanel.getPageCount() - 1) {
            return;
        }
        this.loadPage(page);
    }

    private void loadPage(int pageIndex) {
        this.formPanel.loadPage(pageIndex);
        this.scrollAndRefreshPage();
    }

    private void formZoomOut() {
        if (!this.canZoom()) {
            return;
        }
        this.formPanel.addZoomRatio(-0.15f);
        this.refreshPage();
    }

    private void formZoomIn() {
        if (!this.canZoom()) {
            return;
        }
        this.formPanel.addZoomRatio(0.15f);
        this.refreshPage();
    }

    private void formFitClear() {
        if (!this.canZoom()) {
            return;
        }
        this.formPanel.calcZoomRatios();
        this.refreshPage();
    }

    private boolean canZoom() {
        return this.formPanel.hasPages();
    }

    protected boolean formConfig() {
        return false;
    }

    protected void formPrintDefault() {
        if (this.isFormEmpty()) {
            return;
        }
        this.formPrintInner(1, false);
    }

    protected void formPrint() {
        if (this.isFormEmpty()) {
            return;
        }
        this.formPrintInner(1, true);
    }

    private void formPrintInner(int copies, boolean displayDialog) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TngFormViewer.this.jPrint.setEnabled(false);
                    TngFormViewer.this.jPrintDefault.setEnabled(false);
                }
                catch (Exception ex) {
                    TngSwing.exceptionShow(Nat.x("Chyba pri vytla\u010den\u00ed formul\u00e1ra"), ex);
                }
                finally {
                    TngFormViewer.this.jPrint.setEnabled(true);
                    TngFormViewer.this.jPrintDefault.setEnabled(true);
                }
            }
        });
        thread.start();
    }

    protected void formSave() {
        if (this.saveForm()) {
            TngSwing.msgOK(Nat.x("\u00dadaje boli \u00faspe\u0161ne ulo\u017een\u00e9"));
        }
    }

    protected boolean saveForm() {
        TngProgressableWorker worker = new TngProgressableWorker(Nat.x("Ukladanie formul\u00e1ra")){

            @Override
            public void compute() throws Exception {
                this.setProgressStatus(Nat.x("Ukladanie \u00fadajov"));
                for (TngFormComponent formComponent : TngFormViewer.this.formPanel.getFormComponents()) {
                    TngFormViewer.this.formDataAccessor.setValue(formComponent.getFormObject().getName(), formComponent.getValue(), formComponent.getFormObject().isScriptLeft() ? TngDmBufferCached.FCalc.C : null);
                }
                TngFormViewer.this.formDataAccessor.saveData(this);
            }
        };
        try {
            worker.setProgressCancelable(true);
            worker.start();
            return true;
        }
        catch (TngException e2) {
            TngSwing.msgError(e2.getMessage());
        }
        catch (Exception e3) {
            TngSwing.exceptionShow(e3);
        }
        return false;
    }

    protected void formExportPdf() {
        if (!this.saveOnDemand()) {
            return;
        }
        try {
            TngFormPdfOperator.exportFinalPdf(this.formDataAccessor);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private boolean saveOnDemand() {
        int ask = TngSwing.msgAsk(Nat.x("\u017del\u00e1te si pred vykonan\u00edm oper\u00e1cie ulo\u017ei\u0165 \u00fadaje?"), new String[]{Nat.x("\u00c1no"), Nat.x("Nie"), Nat.x("Zru\u0161i\u0165")}, 0);
        if (ask == -1 || ask == 2) {
            return false;
        }
        return ask != 0 || this.saveForm();
    }

    private void formExit() {
        if (!this.saveOnDemand()) {
            return;
        }
        Container topLevelAncestor = this.getTopLevelAncestor();
        if (topLevelAncestor instanceof TngMdiMain) {
            TngMdiMain mdiMain = (TngMdiMain)topLevelAncestor;
            JInternalFrame child = mdiMain.getActiveChild();
            if (child instanceof TngMdiChild) {
                ((TngMdiChild)child).close();
            } else {
                mdiMain.closeChild(child);
            }
        } else if (topLevelAncestor instanceof JFrame) {
            ((JFrame)topLevelAncestor).dispose();
        } else if (topLevelAncestor instanceof TngDlg) {
            ((TngDlg)topLevelAncestor).buttonCancelAction();
        }
        this.clearForm();
    }

    private void clearForm() {
        this.formPanel.disposeImages();
        this.formPanel.clear();
        if (this.formDataAccessor instanceof TngFormDataAccessorDoch) {
            ((DochExt)((TngFormDataAccessorDoch)this.formDataAccessor).getData()).getCache().clearValues();
        } else if (this.formDataAccessor instanceof TngFormDataAccessorDphPriznania) {
            ((Dph_priznaniaExt)((TngFormDataAccessorDphPriznania)this.formDataAccessor).getData()).getCache().clearValues();
        }
    }

    private void loadData(TngProgressableWorker worker) {
        try {
            this.formDataAccessor.loadData(worker);
            worker.setProgressMax(this.formPanel.getFormComponents().size());
            for (TngFormComponent formComponent : this.formPanel.getFormComponents()) {
                if (worker.isProgressCanceled()) {
                    throw new TngExceptionAbort();
                }
                worker.addProgressValue(1);
                formComponent.setValue(this.formDataAccessor.getValue(formComponent.getFormObject().getName()));
            }
            for (TngFormScript formScript : this.form.getScripts()) {
                formScript.getOperator().executeScript(this.formPanel.getFormComponents());
            }
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public static TngFormViewer createViewer(TngFormDataAccessor formDataAccessor) {
        TngFormViewer formViewer = new TngFormViewer();
        formViewer.setData(formDataAccessor);
        formViewer.loadForm();
        return formViewer;
    }

    public static TngMdiChild createViewerAsMdiChild(TngFormDataAccessor formDataAccessor) {
        TngFormViewer formViewer = TngFormViewer.createViewer(formDataAccessor);
        TngMdiChild mdiChild = new TngMdiChild();
        mdiChild.add(formViewer);
        return mdiChild;
    }

    public static JFrame createViewerAsFrame(TngFormDataAccessor formDataAccessor) {
        TngFormViewer formViewer = TngFormViewer.createViewer(formDataAccessor);
        JFrame frame = new JFrame();
        frame.add(formViewer);
        return frame;
    }
}

