/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import tangram.library.TngConnection;
import tangram.library.TngCrypt;
import tangram.library.TngIniReader;
import tangram.library.TngSqlConfig;
import tangram.library.TngTnsnamesConfig;
import tangram.library.TngUtilities;

public abstract class TngConfigAbstract {
    protected TngIniReader ini = null;
    protected boolean iniLoaded = false;
    protected boolean autoCommit = false;

    public TngConfigAbstract() {
        this(new TngIniReader());
    }

    public TngConfigAbstract(String fileName) {
        this(new TngIniReader(fileName));
    }

    public TngConfigAbstract(TngIniReader ini) {
        this.ini = ini;
    }

    public void setConnection(String database, TngConnection connection) throws Exception {
        this.iniLoad();
        connection.setProtocol(this.getString(database, "protocol", "tcp"));
        connection.setHost(this.getString(database, "host", "localhost"));
        connection.setPort(this.getInteger(database, "port", 1521));
        connection.setServer(this.getString(database, "server", "dedicated"));
        connection.setService(this.getString(database, "service", "XE"));
        connection.setAutoCommit(this.autoCommit);
    }

    public String getDefDatabase() throws Exception {
        return TngUtilities.getArgumentString("database", "");
    }

    public String getDefSchema(String database) throws Exception {
        return this.getString(database, "schema", "").toUpperCase();
    }

    public String getDefUser(String database) throws Exception {
        String username = this.getString(database, "username", null);
        if (username != null) {
            return username.toUpperCase();
        }
        return this.getString(database, "user", "").toUpperCase();
    }

    public String getDefPassword(String database) throws Exception {
        String h2 = TngUtilities.getArgumentString("password", null);
        if (h2 != null) {
            return h2;
        }
        TngCrypt c2 = new TngCrypt("DES");
        String psswd = this.ini.getString(database, "password", "");
        if (psswd == null || psswd.equals("")) {
            return "";
        }
        return c2.decrypt(psswd);
    }

    public abstract void iniLoad() throws Exception;

    public abstract String[] getDatabases() throws Exception;

    protected abstract String getString(String var1, String var2, String var3) throws Exception;

    protected abstract int getInteger(String var1, String var2, int var3) throws Exception;

    public static TngConfigAbstract getConfig() {
        TngTnsnamesConfig tnsNamesConfig = TngConfigAbstract.getTnsnamesConfig();
        TngSqlConfig sqlConfig = TngConfigAbstract.getSqlConfig();
        if (sqlConfig == null && tnsNamesConfig == null) {
            return new TngSqlConfig();
        }
        return sqlConfig == null ? tnsNamesConfig : sqlConfig;
    }

    private static TngTnsnamesConfig getTnsnamesConfig() {
        try {
            TngTnsnamesConfig tns = new TngTnsnamesConfig("sql.ini");
            tns.iniLoad();
            return tns;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static TngSqlConfig getSqlConfig() {
        try {
            TngSqlConfig sql = new TngSqlConfig();
            sql.iniLoad();
            return sql;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

