/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class TngCrypt {
    public static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    public static final String DES_ENCRYPTION_SCHEME = "DES";
    public static final String DEFAULT_ENCRYPTION_KEY = "This is a fairly long phrase used to encrypt";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;
    private static final String UNICODE_FORMAT = "UTF8";

    public TngCrypt(String encryptionScheme) throws Exception {
        this(encryptionScheme, DEFAULT_ENCRYPTION_KEY);
    }

    public TngCrypt(String encryptionScheme, String encryptionKey) throws Exception {
        if (encryptionKey == null) {
            throw new IllegalArgumentException("encryption key was null");
        }
        if (encryptionKey.trim().length() < 24) {
            throw new IllegalArgumentException("encryption key was less than 24 characters");
        }
        byte[] keyAsBytes = encryptionKey.getBytes(UNICODE_FORMAT);
        if (encryptionScheme.equals(DESEDE_ENCRYPTION_SCHEME)) {
            this.keySpec = new DESedeKeySpec(keyAsBytes);
        } else if (encryptionScheme.equals(DES_ENCRYPTION_SCHEME)) {
            this.keySpec = new DESKeySpec(keyAsBytes);
        } else {
            throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
        }
        this.keyFactory = SecretKeyFactory.getInstance(encryptionScheme);
        this.cipher = Cipher.getInstance(encryptionScheme);
    }

    public String encrypt(String unencryptedString) throws Exception {
        if (unencryptedString == null || unencryptedString.length() == 0) {
            return "";
        }
        SecretKey key = this.keyFactory.generateSecret(this.keySpec);
        this.cipher.init(1, key);
        byte[] cleartext = unencryptedString.getBytes(UNICODE_FORMAT);
        byte[] ciphertext = this.cipher.doFinal(cleartext);
        BASE64Encoder base64encoder = new BASE64Encoder();
        return base64encoder.encode(ciphertext);
    }

    public String decrypt(String encryptedString) throws Exception {
        if (encryptedString == null || encryptedString.length() == 0) {
            return "";
        }
        SecretKey key = this.keyFactory.generateSecret(this.keySpec);
        this.cipher.init(2, key);
        BASE64Decoder base64decoder = new BASE64Decoder();
        byte[] cleartext = base64decoder.decodeBuffer(encryptedString);
        byte[] ciphertext = this.cipher.doFinal(cleartext);
        return TngCrypt.bytes2String(ciphertext);
    }

    private static String bytes2String(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            stringBuffer.append((char)bytes[i2]);
        }
        return stringBuffer.toString();
    }

    public static class EncryptionException
    extends Exception {
        public EncryptionException(Throwable t) {
            super(t);
        }
    }
}

