/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import tangram.library.TngUtilities;

public enum TngFtpType {
    FTP_CONNECTION("", false),
    IMPLICIT_SSL_FTP_CONNECTION("SSL", true),
    IMPLICIT_TLS_FTP_CONNECTION("TLS", true),
    AUTH_SSL_FTP_CONNECTION("SSL", false),
    AUTH_TLS_FTP_CONNECTION("TLS", false);

    private String protocol;
    private boolean implicit;

    private TngFtpType(String protocol, boolean implicit) {
        this.protocol = protocol;
        this.implicit = implicit;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public boolean isSecured() {
        return !TngUtilities.isEmpty(this.getProtocol());
    }

    public static TngFtpType find(String value) {
        if (TngUtilities.isEmpty(value)) {
            return FTP_CONNECTION;
        }
        String[] tokens = TngUtilities.strTokenizeNotNull(value, ';');
        if (tokens.length < 2) {
            return FTP_CONNECTION;
        }
        for (TngFtpType type : TngFtpType.values()) {
            boolean implicitEquals;
            boolean protocolEquals = type.getProtocol().equalsIgnoreCase(tokens[0]);
            boolean bl = implicitEquals = type.isImplicit() == Boolean.valueOf(tokens[1]).booleanValue();
            if (!protocolEquals || !implicitEquals) continue;
            return type;
        }
        return FTP_CONNECTION;
    }

    public String getSavedValue() {
        return this.getProtocol() + ";" + this.isImplicit();
    }
}

