/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngIniReader {
    private String file = null;
    private Hashtable<String, ArrayList<String>> data = new Hashtable();
    private ArrayList<String> sections = new ArrayList();

    public TngIniReader() {
        this("config.ini");
    }

    public TngIniReader(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public String[] getSections() {
        return this.sections.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.data.clear();
        this.sections.clear();
        File ff = TngUtilities.getFileAppFull(this.file);
        if (!ff.exists()) {
            throw new IOException(Nat.x("Konfigura\u010dn\u00fd s\u00fabor %1 neexistuje", this.file));
        }
        BufferedReader stream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "windows-1250"));
        String section = "";
        try {
            String h2;
            while ((h2 = stream.readLine()) != null) {
                h2.trim();
                if (h2.length() == 0 || h2.charAt(0) == ';') continue;
                if (h2.charAt(0) == '[') {
                    if (h2.charAt(h2.length() - 1) != ']') {
                        throw new IOException(Nat.x("Chybn\u00e1 syntax sekcie '%1' v INI s\u00fabore", h2));
                    }
                    section = h2.substring(1, h2.length() - 1);
                    section = section.toUpperCase();
                    this.sections.add(section);
                    continue;
                }
                String value = "";
                int f2 = h2.indexOf(61);
                if (f2 < 0) {
                    String string = h2;
                }
                if (f2 == 0) {
                    throw new IOException(Nat.x("Chybn\u00e1 syntax k\u013e\u00fa\u010da '%1' v INI s\u00fabore", h2));
                }
                String key = TngUtilities.strLeft(h2, f2).trim();
                value = TngUtilities.strCut(h2, f2 + 1).trim();
                key = key.toUpperCase();
                String dataKey = section + "." + key;
                ArrayList<String> values = this.data.get(dataKey);
                if (values == null) {
                    values = new ArrayList();
                    values.add(value);
                    this.data.put(dataKey, values);
                    continue;
                }
                values.add(value);
            }
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
        finally {
            TngUtilities.closeSafe(stream);
        }
    }

    public String[] getValues(String section, String key) {
        if (key == null || key.length() == 0) {
            return new String[0];
        }
        ArrayList<String> values = this.data.get(section.toUpperCase() + "." + key.toUpperCase());
        if (values == null) {
            return new String[0];
        }
        return values.toArray(new String[0]);
    }

    private String getValue(String section, String key) throws IOException {
        if (key == null || key.length() == 0) {
            return null;
        }
        ArrayList<String> values = this.data.get(section.toUpperCase() + "." + key.toUpperCase());
        if (values == null) {
            return null;
        }
        if (values.size() > 1) {
            throw new IOException(Nat.x("Duplicitn\u00e9 hodnoty pre k\u013e\u00fa\u010d '%1' v INI s\u00fabore", section + "." + key));
        }
        return values.get(0);
    }

    public String getString(String section, String key, String defValue) throws IOException {
        String h2 = this.getValue(section, key);
        if (h2 == null) {
            return defValue;
        }
        return h2;
    }

    public int getInteger(String section, String key, int defValue) throws IOException {
        String h2 = this.getValue(section, key);
        if (h2 == null) {
            return defValue;
        }
        int v = TngUtilities.strToInt(h2, -1);
        if (v < 0) {
            throw new IOException(Nat.x("Hodnota k\u013e\u00fa\u010da '%1' v INI s\u00fabore nie je \u010d\u00edslo", section + "." + key));
        }
        return v;
    }

    public boolean getBoolean(String section, String key, boolean defValue) throws IOException {
        String h2 = this.getValue(section, key);
        if (h2 == null) {
            return defValue;
        }
        int v = TngUtilities.strToInt(h2, -1);
        if (v < 0 || v > 1) {
            throw new IOException(Nat.x("Hodnota k\u013e\u00fa\u010da '%1' v INI s\u00fabore nie je boolean", section + "." + key));
        }
        return v == 1;
    }
}

