/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import tangram.library.TngUtilities;

public class TngJournalRow {
    private static final int MAX_LEVEL = 99;
    private String text;
    private String ident;
    private String group;
    private RowType type;
    private int level;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setType(RowType type) {
        this.type = type;
    }

    public RowType getType() {
        return this.type;
    }

    public boolean isTitle() {
        return this.type == RowType.T;
    }

    public boolean isError() {
        return this.type == RowType.E;
    }

    public boolean isInfo() {
        return this.type == RowType.I;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static TngJournalRow fromString(String data) {
        TngJournalRow row = new TngJournalRow();
        String text = TngUtilities.strSubstrOrNull(data, 0, 250);
        row.text = text == null ? null : text.trim();
        String group = TngUtilities.strSubstrOrNull(data, 250, 15);
        row.group = group == null ? null : group.trim();
        String ident = TngUtilities.strSubstrOrNull(data, 265, 50);
        row.ident = ident == null ? null : ident.trim();
        row.type = RowType.findType(TngUtilities.strSubstrOrNull(data, 315, 1));
        row.level = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(data, 316, 2), 0);
        return row;
    }

    public String toString() {
        String str = TngUtilities.strLeft(TngUtilities.strPadLeft(this.text, 250), 250);
        str = str + TngUtilities.strLeft(TngUtilities.strPadLeft(this.group, 15), 15);
        str = str + TngUtilities.strLeft(TngUtilities.strPadLeft(this.ident, 50), 50);
        str = str + TngUtilities.strLeft(this.type.toString(), 1);
        str = str + TngUtilities.strLeft(TngUtilities.strPadRight(String.valueOf(this.level > 99 ? this.level % 99 : this.level), 2, '0'), 2);
        return str;
    }

    public static enum RowType {
        T,
        I,
        E;


        public static RowType findType(String type) {
            try {
                return RowType.valueOf(type);
            }
            catch (Exception e2) {
                return I;
            }
        }
    }
}

