/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngLicence {
    protected static final int RX32_LENGHT = 10;
    protected static final int IDX_DATA1 = 0;
    protected static final int IDX_DATA2 = 1;
    protected static final int IDX_CRC = 2;
    private static long lockId = 0L;

    protected static long getLockId() {
        if (lockId != 0L) {
            return lockId;
        }
        try {
            String mac = TngLicence.getMacAddress();
            lockId = Long.parseLong(mac, 16);
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
        if (lockId == 0L) {
            lockId = 28772997619311L;
        }
        return lockId;
    }

    protected static String cryptKeyTo32RX(long key, long lock) {
        long crypted64 = TngLicence.recrypt(key, lock, true);
        return TngLicence.longToRx32(crypted64);
    }

    protected static long decrypt32RXToKey(String keyRx32, long lock) throws Exception {
        int crc2;
        long crypted64 = TngLicence.Rx32ToLong(keyRx32);
        long decrypted64 = TngLicence.recrypt(crypted64, lock, false);
        int crc1 = TngLicence.calcCrc(TngLicence.getWord(decrypted64, 0), TngLicence.getWord(decrypted64, 1));
        if (crc1 != (crc2 = TngLicence.getWord(decrypted64, 2))) {
            throw new Exception(Nat.x("K\u013e\u00fa\u010d %1 obsahuje chybn\u00e9 CRC", keyRx32));
        }
        return decrypted64 & 0xFFFFFFFFL;
    }

    private static long Rx32ToLong(String keyRx32) throws Exception {
        if (keyRx32 == null || keyRx32.length() != 10) {
            throw new Exception(Nat.x("K\u013e\u00fa\u010d %1 nem\u00e1 spr\u00e1vnu ve\u013ekos\u0165", keyRx32));
        }
        long value = 0L;
        for (int i2 = 9; i2 >= 0; --i2) {
            int h2;
            if ((h2 -= (h2 = keyRx32.charAt(i2)) > 57 ? 55 : 48) > 31) {
                throw new Exception(Nat.x("K\u013e\u00fa\u010d %1 obsahuje chybn\u00fd znak %2", keyRx32, Character.valueOf(keyRx32.charAt(i2))));
            }
            value <<= 5;
            value += (long)h2;
        }
        return value;
    }

    private static String longToRx32(long value) {
        char[] r2 = new char[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            int h2;
            r2[i2] = (char)(h2 += (h2 = (int)(value & 0x1FL)) > 9 ? 55 : 48);
            value >>>= 5;
        }
        return new String(r2);
    }

    private static long recrypt(long key, long lock, boolean calcCrc) {
        int L1 = TngLicence.getWord(lock, 0);
        int L2 = TngLicence.getWord(lock, 1);
        int Lcrc = TngLicence.calcCrc(L1, L2);
        L1 = L1 * 38239 & 0xFFFF;
        L2 = L2 * 48973 & 0xFFFF;
        Lcrc = Lcrc * 63317 & 0xFFFF;
        int d1 = TngLicence.getWord(key, 0);
        int d2 = TngLicence.getWord(key, 1);
        int crc = calcCrc ? TngLicence.calcCrc(d1, d2) : TngLicence.getWord(key, 2);
        long value = ((long)(d1 ^= L1) << 0) + ((long)(d2 ^= L2) << 16) + ((long)(crc ^= Lcrc) << 32);
        return value;
    }

    private static int calcCrc(int d1, int d2) {
        d1 = d1 * 37967 & 0xFFFF;
        d2 = d2 * 51439 & 0xFFFF;
        return d1 + d2 & 0xFFFF;
    }

    protected static int getWord(long value, int index) {
        return (int)(value >>> index * 16 & 0xFFFFL);
    }

    protected static int getByte(long value, int index) {
        return (int)(value >>> index * 8 & 0xFFL);
    }

    public static String getMacAddress() throws Exception {
        StringBuilder mac = new StringBuilder(16);
        char[] hex = new char[2];
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface netint : Collections.list(nets)) {
            mac.setLength(0);
            byte[] hw = netint.getHardwareAddress();
            if (hw != null) {
                for (int i2 = 0; i2 < hw.length; ++i2) {
                    TngUtilities.hexCharsFromByte(hw[i2], hex);
                    mac.append(hex);
                }
            }
            String dispName = netint.getDisplayName();
            if (netint.isLoopback() || netint.isVirtual() || dispName == null || mac.length() != 12 || dispName.indexOf("Virtual") >= 0 || mac.toString().startsWith("00-FF-")) continue;
            return mac.toString();
        }
        return null;
    }
}

