/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngLogFile {
    protected OutputStreamWriter stream;

    public void openDay(File path, String fileWithoutExtension) {
        if (!path.exists() && !path.mkdirs()) {
            return;
        }
        String day = TngUtilities.dateTimeToStr(new Date(), new SimpleDateFormat("yyyyMMdd"));
        String file = fileWithoutExtension + "_" + day + ".log";
        this.open(new File(path, file), true);
    }

    public void open(String fileName, boolean append) {
        this.open(new File(fileName), append);
    }

    public void open(File file, boolean append) {
        try {
            this.close();
            this.stream = new OutputStreamWriter(new FileOutputStream(file, append));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.write(Nat.x("\u0160tart:") + " " + TngUtilities.dateTimeToStr(new Date()));
    }

    public void close() {
        if (this.stream == null) {
            return;
        }
        try {
            this.write(Nat.x("Koniec:") + " " + TngUtilities.dateTimeToStr(new Date()));
            this.write("");
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stream = null;
    }

    public boolean isOpened() {
        return this.stream != null;
    }

    public void write(String line) {
        if (this.stream == null || line == null) {
            return;
        }
        try {
            this.stream.write(line);
            this.stream.write(13);
            this.stream.write(10);
            this.stream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void add(String text) {
        if (this.stream == null || text == null) {
            return;
        }
        try {
            this.stream.write(text);
            this.stream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

