/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;

public final class TngParams
implements Cloneable {
    public static final String PATH_SEP = "/";
    protected boolean isRoot = true;
    protected String name;
    protected String path;
    protected Hashtable<String, String> params = new Hashtable(128);
    protected TngParamsAccessor accessor;

    public TngParams() {
        this(null, null);
    }

    public TngParams(String name) {
        this(name, null);
    }

    public TngParams(String name, TngParamsAccessor accessor) {
        this.accessor = accessor;
        this.setNameAndPath(name);
    }

    public void setNameAndPath(String name) {
        this.name = name != null ? name : "";
        this.path = this.name + PATH_SEP;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable<String, String> getParams() {
        return this.params;
    }

    public TngParams getSubParams(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        TngParams subParams = new TngParams();
        subParams.isRoot = false;
        subParams.name = this.path + name;
        subParams.path = subParams.name + PATH_SEP;
        subParams.params = this.params;
        subParams.accessor = this.accessor;
        return subParams;
    }

    public TngParams getSubParamsAsNew(String newName) {
        if (newName == null || newName.length() == 0) {
            return this;
        }
        TngParams subParams = new TngParams();
        subParams.params = new Hashtable();
        Enumeration<String> keys = this.params.keys();
        while (keys.hasMoreElements()) {
            String k2 = keys.nextElement();
            if (!this.isOnPath(k2)) continue;
            String newKey = k2;
            String toSearch = this.path + newName;
            if (!k2.startsWith(toSearch)) continue;
            newKey = newKey.length() == toSearch.length() ? "" : PATH_SEP + k2.substring(toSearch.length() + 1);
            subParams.params.put(newKey, this.params.get(k2));
        }
        subParams.accessor = this.accessor;
        subParams.isRoot = true;
        subParams.name = "";
        subParams.path = subParams.name + PATH_SEP;
        return subParams;
    }

    public void setSubParams(String name, TngParams subParams) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (subParams == null || subParams.params == null) {
            return;
        }
        Enumeration<String> keys = subParams.params.keys();
        while (keys.hasMoreElements()) {
            String k2 = keys.nextElement();
            String v = subParams.params.get(k2);
            this.setValue(name + k2, v);
        }
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        String value = this.getValue(name);
        return value != null ? value : defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getValue(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (value.charAt(0) == 'T') {
            return true;
        }
        if (value.charAt(0) == 'F') {
            return false;
        }
        return defaultValue;
    }

    public int getInt(String name, int defaultValue) {
        String value = this.getValue(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        String value = this.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public void setString(String name, String value) {
        this.setValue(name, value);
    }

    public void setBoolean(String name, boolean value) {
        this.setValue(name, value ? "T" : "F");
    }

    public void setInt(String name, int value) {
        this.setValue(name, Integer.toString(value));
    }

    public void setBigDecimal(String name, BigDecimal value) {
        this.setValue(name, value != null ? value.toString() : "");
    }

    protected String getValue(String name) {
        return this.params.get(this.path + name);
    }

    protected void setValue(String name, String value) {
        this.setFullNameValue(this.path + name, value);
    }

    protected void setFullNameValue(String fullName, String value) {
        this.params.put(fullName, value == null ? "" : value);
    }

    public void clear() {
        if (this.isRoot) {
            this.params.clear();
            return;
        }
        Enumeration<String> e2 = this.params.keys();
        while (e2.hasMoreElements()) {
            String name = e2.nextElement();
            if (!this.isOnPath(name)) continue;
            this.params.remove(name);
        }
    }

    public boolean isOnPath(String fullname) {
        return fullname.startsWith(this.path);
    }

    public Object clone() throws CloneNotSupportedException {
        TngParams clone = (TngParams)super.clone();
        clone.params = (Hashtable)this.params.clone();
        return clone;
    }

    public void setAccessor(TngParamsAccessor accessor) {
        this.accessor = accessor;
    }

    public TngParamsAccessor getAccessor() {
        return this.accessor;
    }

    public final void load() throws Exception {
        if (this.accessor != null) {
            this.accessor.load(this);
        }
    }

    public final void save() throws Exception {
        if (this.accessor != null) {
            this.accessor.save(this);
        }
    }

    public static interface TngParamsAccessor {
        public void load(TngParams var1) throws Exception;

        public void save(TngParams var1) throws Exception;
    }
}

