/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import tangram.library.Nat;
import tangram.library.TngParams;
import tangram.library.TngUtilities;
import tangram.library.TngWindowsRegistry;

public class TngParamsAccessorFile
implements TngParams.TngParamsAccessor {
    private File file;
    private boolean backup = true;
    private static final char COMMENT_CHAR = '#';
    private static final char COMMENT_DIV = '#';
    private static final char PATH_DIV = '\t';

    public void setName(String name) {
        String path = this.getDefaultPath();
        this.setFile(new File(path, name));
    }

    public String getName() {
        return this.file == null ? null : this.file.getName();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public boolean getBackup() {
        return this.backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(TngParams p2) throws Exception {
        p2.clear();
        if (!this.file.exists()) {
            return;
        }
        BufferedReader streamIn = null;
        try {
            String line;
            StringBuilder n2 = new StringBuilder(64);
            StringBuilder v = new StringBuilder(64);
            String path = "/";
            boolean onPath = p2.isOnPath(path);
            streamIn = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
            while ((line = streamIn.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (this.analysePath(line, n2)) {
                    path = n2.toString();
                    onPath = p2.isOnPath(path);
                    continue;
                }
                if (!onPath || !this.analyseNameAndValue(line, n2, v)) continue;
                this.decodeValue(v);
                p2.setFullNameValue(path + n2.toString(), v.toString());
            }
        }
        catch (Throwable throwable) {
            TngParamsAccessorFile.streamCloseSafe(streamIn);
            throw throwable;
        }
        TngParamsAccessorFile.streamCloseSafe(streamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(TngParams p2) throws Exception {
        BufferedReader streamIn = null;
        BufferedWriter streamOut = null;
        this.createDirsForFile(this.file);
        try {
            ArrayList<String> lines = new ArrayList<String>(128);
            if (this.file.exists()) {
                streamIn = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                this.appendLines(lines, streamIn, p2);
                TngParamsAccessorFile.streamCloseSafe(streamIn);
            }
            if (this.backup) {
                this.renameToBackup(this.file);
            }
            this.appendLines(lines, p2);
            Object[] l2 = lines.toArray(new String[0]);
            Arrays.sort(l2);
            streamOut = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.file)));
            this.saveLines((String[])l2, streamOut);
            streamOut.close();
        }
        catch (Throwable throwable) {
            TngParamsAccessorFile.streamCloseSafe(streamOut);
            TngParamsAccessorFile.streamCloseSafe(streamIn);
            throw throwable;
        }
        TngParamsAccessorFile.streamCloseSafe(streamOut);
        TngParamsAccessorFile.streamCloseSafe(streamIn);
    }

    private void appendLines(ArrayList<String> lines, BufferedReader streamIn, TngParams p2) throws Exception {
        String line;
        StringBuilder h2 = new StringBuilder(64);
        StringBuilder k2 = new StringBuilder(64);
        StringBuilder v = new StringBuilder(64);
        String path = "/";
        boolean onPath = p2.isOnPath(path);
        int commentNumber = 0;
        while ((line = streamIn.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (this.analysePath(line, h2)) {
                commentNumber = 0;
                path = h2.toString();
                onPath = p2.isOnPath(path);
                continue;
            }
            if (line.charAt(0) == '#') {
                this.appendLinesComment(lines, path, line, ++commentNumber, h2);
                continue;
            }
            if (onPath || !this.analyseNameAndValue(line, k2, v)) continue;
            this.appendLinesKeyAndValue(lines, path, k2.toString(), v.toString(), h2, false);
        }
    }

    private void appendLinesComment(ArrayList<String> lines, String path, String comment, int commentNumber, StringBuilder speed) {
        char[] num = new char[4];
        TngUtilities.hexCharsFromWord(commentNumber, num);
        speed.setLength(0);
        speed.append(path);
        speed.append('\t');
        speed.append('#');
        speed.append(num);
        speed.append(comment);
        lines.add(speed.toString());
    }

    private void appendLinesKeyAndValue(ArrayList<String> lines, String path, String key, String value, StringBuilder speed, boolean encode) {
        speed.setLength(0);
        speed.append(path);
        speed.append('\t');
        speed.append(key);
        speed.append('=');
        if (encode) {
            this.encodeValue(speed, value);
        } else {
            speed.append(value);
        }
        lines.add(speed.toString());
    }

    private void appendLines(ArrayList<String> lines, TngParams p2) {
        StringBuilder h2 = new StringBuilder(64);
        Enumeration<String> e2 = p2.params.keys();
        while (e2.hasMoreElements()) {
            String fullname = e2.nextElement();
            if (!p2.isOnPath(fullname)) continue;
            int x = fullname.lastIndexOf(47);
            String path = fullname.substring(0, x + 1);
            String key = fullname.substring(x + 1);
            String value = p2.params.get(fullname);
            this.appendLinesKeyAndValue(lines, path, key, value, h2, true);
        }
    }

    private void saveLines(String[] lines, BufferedWriter streamOut) throws Exception {
        String path = "";
        int x = 0;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            x = line.indexOf(9);
            if (path.length() != x || !line.startsWith(path)) {
                path = line.substring(0, x);
                this.savePathName(path, streamOut);
            }
            if (line.charAt(++x) == '#') {
                x += 5;
            }
            streamOut.write(line, x, line.length() - x);
            streamOut.newLine();
        }
    }

    private void savePathName(String path, BufferedWriter streamOut) throws Exception {
        if (path.length() <= 1) {
            return;
        }
        streamOut.newLine();
        streamOut.write(91);
        streamOut.write(path, 0, path.length() - 1);
        streamOut.write(93);
        streamOut.newLine();
    }

    private void createDirsForFile(File f2) throws Exception {
        String path = f2.getParent();
        if (path == null || path.length() == 0) {
            return;
        }
        File p2 = new File(path);
        if (!p2.isDirectory() && !p2.mkdirs()) {
            throw new Exception(Nat.x("Nie je mo\u017en\u00e9 vytvori\u0165 adres\u00e1r %1", p2.getAbsolutePath()));
        }
    }

    private boolean analysePath(String line, StringBuilder section) {
        if (line == null || line.length() < 2) {
            return false;
        }
        if (line.charAt(0) != '[') {
            return false;
        }
        int length = line.length() - 1;
        if (line.charAt(length) == ']') {
            --length;
        }
        if ((line = line.substring(1, length + 1).trim()).length() == 0) {
            return false;
        }
        section.setLength(0);
        section.append(line);
        section.append('/');
        return true;
    }

    private boolean analyseNameAndValue(String line, StringBuilder name, StringBuilder value) {
        int f2 = line.indexOf(61);
        if (f2 < 2) {
            return false;
        }
        String n2 = line.substring(0, f2).trim();
        if (n2.length() == 0) {
            return false;
        }
        String v = line.substring(f2 + 1).trim();
        name.setLength(0);
        name.append(n2);
        value.setLength(0);
        value.append(v);
        return true;
    }

    private void encodeValue(StringBuilder buff, String value) {
        boolean enclose;
        char[] hex = new char[2];
        int l2 = value.length();
        if (l2 == 0) {
            return;
        }
        char b2 = value.charAt(0);
        char e2 = value.charAt(l2 - 1);
        boolean bl = enclose = b2 == ' ' || b2 == '\"' || e2 == ' ' || e2 == '\"';
        if (enclose) {
            buff.append('\"');
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            b2 = value.charAt(i2);
            if (b2 == '\\') {
                buff.append("\\\\");
                continue;
            }
            if (b2 == '\n') {
                buff.append("\\n");
                continue;
            }
            if (b2 < ' ') {
                buff.append("\\<");
                TngUtilities.hexCharsFromByte(b2, hex);
                buff.append(hex);
                buff.append('>');
                continue;
            }
            buff.append(b2);
        }
        if (enclose) {
            buff.append('\"');
        }
    }

    private void decodeValue(StringBuilder value) {
        char[] hex = new char[2];
        int x = 0;
        int ldec = value.length() - 1;
        for (int i2 = 0; i2 < value.length(); ++i2) {
            int c2 = value.charAt(i2);
            if (c2 == 34 && i2 == 0) continue;
            if (c2 == 92 && i2 < ldec) {
                char n2 = value.charAt(i2 + 1);
                if (n2 == '\\') {
                    c2 = 92;
                    ++i2;
                } else if (n2 == 'n') {
                    c2 = 10;
                    ++i2;
                } else if (n2 == '<') {
                    int o2 = this.tokenHex(value, hex, i2 + 1);
                    if (hex[0] != '\u0000') {
                        c2 = (char)TngUtilities.hexCharsToByte(hex);
                        i2 = o2;
                    }
                }
            }
            value.setCharAt(x++, (char)c2);
        }
        if (x > 0 && value.charAt(x - 1) == '\"') {
            --x;
        }
        value.setLength(x);
    }

    private int tokenHex(StringBuilder value, char[] hex, int index) {
        hex[0] = '\u0000';
        hex[1] = '\u0000';
        int l2 = value.length();
        if (l2 < index + 4 || value.charAt(index + 0) != '<' || value.charAt(index + 3) != '>') {
            return index;
        }
        char a2 = Character.toUpperCase(value.charAt(index + 1));
        char b2 = Character.toUpperCase(value.charAt(index + 2));
        if (!(a2 >= '0' && a2 <= '9' || a2 >= 'A' && a2 <= 'F')) {
            return index;
        }
        if (!(b2 >= '0' && b2 <= '9' || b2 >= 'A' && b2 <= 'F')) {
            return index;
        }
        hex[0] = a2;
        hex[1] = b2;
        return index + 4;
    }

    public static void streamCloseSafe(BufferedReader stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void streamCloseSafe(BufferedWriter stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void renameToBackup(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File bak = new File(file.getAbsolutePath() + ".bak");
        if (bak.exists() && !bak.delete()) {
            System.err.println(Nat.x("Nie je mo\u017en\u00e9 zmaza\u0165 s\u00fabor %1", bak.getAbsolutePath()));
        }
        if (!file.renameTo(bak)) {
            System.err.println(Nat.x("Nie je mo\u017en\u00e9 premenova\u0165 s\u00fabor %1 na %2", file.getAbsolutePath(), bak.getName()));
        }
    }

    private String getDefaultPath() {
        String path = null;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            try {
                path = TngWindowsRegistry.getKeySz(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common AppData");
                path = path + File.separator + "Tangram";
            }
            catch (Throwable e2) {
                TngUtilities.exceptionLog(e2);
            }
        }
        if (path == null) {
            path = System.getProperty("user.home");
        }
        return path;
    }
}

