/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import tangram.exception.TngException;
import tangram.library.Nat;
import tangram.library.TngParams;
import tangram.library.TngSmtpSecurity;
import tangram.library.TngSsl;
import tangram.library.TngUtilities;

public class TngSmtp {
    private List<String> recipients = new ArrayList<String>();
    private List<File> files = new ArrayList<File>();
    private String smtpHostName;
    private int smtpPort = 25;
    private boolean auth;
    private TngSmtpSecurity security;
    private String authUser;
    private String authPassword;
    private String sender;
    private String subject;
    private String message;
    private boolean debug;
    private String messageID;

    public void loadFromParams(TngParams params) {
        this.setAuth(params.getBoolean("Smtp_auth", false));
        this.setSecurity(TngUtilities.valueOf(params.getString("Smtp_security"), TngSmtpSecurity.NONE));
        this.setAuthPassword(params.getString("Smtp_auth_pswd", ""));
        this.setAuthUser(params.getString("Smtp_auth_user", ""));
        this.setSmtpHostName(params.getString("Smtp_host", ""));
        this.setMessageID(params.getString("Smtp_messageid", ""));
        this.setSender(params.getString("Smtp_sender", ""));
        this.setSmtpPort(params.getInt("Smtp_port", 25));
    }

    public void saveToParams(TngParams params) {
        params.setBoolean("Smtp_auth", this.isAuth());
        params.setString("Smtp_security", this.getSecurity().name());
        params.setString("Smtp_auth_pswd", this.getAuthPassword());
        params.setString("Smtp_auth_user", this.getAuthUser());
        params.setString("Smtp_host", this.getSmtpHostName());
        params.setString("Smtp_messageid", this.getMessageID());
        params.setString("Smtp_sender", this.getSender());
        params.setInt("Smtp_port", this.getSmtpPort());
    }

    public void addRecepient(String recepient) {
        this.recipients.add(recepient);
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recepients) {
        this.recipients = recepients;
    }

    public void addFile(File file) {
        if (file.isDirectory()) {
            File[] dirFiles;
            for (File dirFile : dirFiles = file.listFiles()) {
                this.files.add(dirFile);
            }
        } else {
            this.files.add(file);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setSmtpHostName(String smtpHostName) {
        this.smtpHostName = smtpHostName;
    }

    public String getSmtpHostName() {
        return this.smtpHostName;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean authorize) {
        this.auth = authorize;
    }

    public TngSmtpSecurity getSecurity() {
        return this.security == null ? TngSmtpSecurity.NONE : this.security;
    }

    public void setSecurity(TngSmtpSecurity security) {
        this.security = security;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authorizeUser) {
        this.authUser = authorizeUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authorizePassword) {
        this.authPassword = authorizePassword;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() throws Exception {
        this.checkParams();
        Properties props = this.createProperties();
        Session session = this.createSession(props);
        Message message = this.createMessage(session);
        Multipart multipart = this.createMultipart();
        message.setContent(multipart);
        try {
            if (this.getSecurity() == TngSmtpSecurity.SSL) {
                TngSsl.certificateOff();
            }
            Transport.send(message);
        }
        finally {
            if (this.getSecurity() == TngSmtpSecurity.SSL) {
                TngSsl.certificateOn();
            }
        }
    }

    private void checkParams() throws Exception {
        if (TngUtilities.isEmpty(this.smtpHostName)) {
            throw new TngException(Nat.x("Nezadan\u00fd n\u00e1zov hostu"));
        }
        if (this.smtpPort < 0) {
            throw new TngException(Nat.x("Nezadan\u00fd port"));
        }
        if (TngUtilities.isEmpty(this.sender)) {
            throw new TngException(Nat.x("Nezadan\u00fd odosielate\u013e emailu"));
        }
        if (this.recipients == null || this.recipients.size() == 0) {
            throw new TngException(Nat.x("Nezadan\u00fd pr\u00edjemcovia emailu"));
        }
        if (this.auth && TngUtilities.isEmpty(this.authUser)) {
            throw new TngException(Nat.x("Nezadan\u00e9 prihl. meno"));
        }
    }

    private Properties createProperties() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.smtpHostName);
        props.setProperty("mail.smtp.port", String.valueOf(this.smtpPort));
        if (this.getSecurity() == TngSmtpSecurity.SSL) {
            props.setProperty("mail.smtp.socketFactory.port", String.valueOf(this.smtpPort));
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else if (this.getSecurity() == TngSmtpSecurity.TLS) {
            props.setProperty("mail.smtp.starttls.enable", "true");
        }
        return props;
    }

    private Session createSession(Properties props) {
        Session session = null;
        if (this.auth) {
            props.setProperty("mail.smtp.auth", "true");
            SMTPAuthenticator auth = new SMTPAuthenticator();
            session = Session.getInstance(props, auth);
        } else {
            session = Session.getInstance(props, null);
        }
        session.setDebug(this.debug);
        return session;
    }

    private Message createMessage(Session session) throws Exception {
        InternetAddress addressFrom = TngSmtp.resolveInternetAddress(this.sender, false);
        Address[] addressTo = new InternetAddress[this.recipients.size()];
        for (int i2 = 0; i2 < this.recipients.size(); ++i2) {
            addressTo[i2] = TngSmtp.resolveInternetAddress(this.recipients.get(i2), true);
        }
        MimeMessage message = new MimeMessage(session){

            @Override
            public void updateMessageID() throws MessagingException {
                if (TngSmtp.this.messageID == null || TngSmtp.this.messageID.equals("")) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", new GregorianCalendar().getTimeInMillis() + "@" + TngSmtp.this.messageID);
                }
            }
        };
        message.setFrom(addressFrom);
        message.setRecipients(Message.RecipientType.TO, addressTo);
        message.setSubject(this.subject, "UTF-8");
        message.saveChanges();
        return message;
    }

    private Multipart createMultipart() throws Exception {
        MimeMultipart multipart = new MimeMultipart("mixed");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        String messageStart = TngUtilities.strLeft(this.message, 10);
        boolean isHtml = messageStart.trim().toLowerCase().startsWith("<html");
        messageBodyPart.setContent(this.message, "text/" + (isHtml ? "html" : "plain") + "; charset=\"UTF-8\"");
        multipart.addBodyPart(messageBodyPart);
        for (int i2 = 0; i2 < this.files.size(); ++i2) {
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(this.files.get(i2));
            messageBodyPart.setDataHandler(new DataHandler(source));
            messageBodyPart.setFileName(MimeUtility.encodeText(this.files.get(i2).getName()));
            messageBodyPart.setDisposition("attachment");
            multipart.addBodyPart(messageBodyPart);
        }
        return multipart;
    }

    private static InternetAddress resolveInternetAddress(String data, boolean addressRequired) throws Exception {
        String[] addressPersonal = TngSmtp.resolveAddressAndPersonal(data);
        InternetAddress internetAddress = new InternetAddress();
        if (TngUtilities.isEmpty(addressPersonal[0])) {
            if (addressRequired) {
                throw new TngException(Nat.x("Nezadan\u00e1 emailov\u00e1 adresa pr\u00edjemcu spr\u00e1vy (%1)", data));
            }
        } else {
            internetAddress.setAddress(addressPersonal[0]);
            TngSmtp.validateAddress(internetAddress);
        }
        if (!TngUtilities.isEmpty(addressPersonal[1])) {
            internetAddress.setPersonal(addressPersonal[1], "UTF-8");
        }
        return internetAddress;
    }

    private static String[] resolveAddressAndPersonal(String data) {
        String[] addressPersonal = new String[]{"", ""};
        int first = data.indexOf("\"");
        if (first == -1) {
            addressPersonal[0] = data;
        } else {
            int last = data.indexOf("\"", first + 1);
            if (last == -1 || first == last - 1) {
                addressPersonal[0] = data;
            } else {
                addressPersonal[1] = data.substring(first + 1, last);
                addressPersonal[0] = data.replace(addressPersonal[1], "");
            }
        }
        addressPersonal[0] = addressPersonal[0].replace("\"", "").replace("<", "").replace(">", "").trim();
        addressPersonal[1] = addressPersonal[1].trim();
        return addressPersonal;
    }

    private static void validateAddress(InternetAddress address) throws Exception {
        try {
            address.validate();
        }
        catch (AddressException addressExc) {
            TngException tngExc = new TngException(Nat.x("Nespr\u00e1vny form\u00e1t emailovej adresy %1", address));
            tngExc.initCause(addressExc);
            throw tngExc;
        }
    }

    protected class SMTPAuthenticator
    extends Authenticator {
        protected SMTPAuthenticator() {
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(TngSmtp.this.authUser, TngSmtp.this.authPassword);
        }
    }
}

