/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tangram.library.TngUtilities;

public final class TngSqlFilter {
    private static final String LIKE_ESCAPE = " ESCAPE '\\'";
    private static final char LIKE_ESCAPE_CHAR = '\\';

    public static String emptyToNothing(String filter) {
        return filter == null || filter.length() == 0 ? "0=1" : filter;
    }

    public static String and(String ... filters) {
        return TngSqlFilter.and(Arrays.asList(filters));
    }

    public static String and(List<String> filters) {
        if (filters == null || filters.size() == 0) {
            return null;
        }
        StringBuilder filter = new StringBuilder();
        for (int i2 = 0; i2 < filters.size(); ++i2) {
            String item = filters.get(i2);
            if (item == null || item.length() == 0) continue;
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            filter.append(item);
        }
        if (filter.length() == 0) {
            return null;
        }
        return filter.toString();
    }

    public static String or(String ... filters) {
        return TngSqlFilter.or(Arrays.asList(filters));
    }

    public static String or(List<String> filters) {
        if (filters == null || filters.size() == 0) {
            return null;
        }
        StringBuilder filter = new StringBuilder();
        int count = 0;
        for (int i2 = 0; i2 < filters.size(); ++i2) {
            String item = filters.get(i2);
            if (item == null || item.length() == 0) continue;
            if (++count > 1) {
                filter.append(" OR ");
            }
            filter.append(filters.get(i2).toString());
        }
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return filter.toString();
        }
        return "(" + filter.toString() + ")";
    }

    public static String inWithLike(String column, String wildList) {
        String[] items = TngUtilities.strTokenizeOrNull(wildList, ',');
        if (items == null) {
            return null;
        }
        ArrayList<String> in = null;
        ArrayList<String> filters = new ArrayList<String>();
        for (int i2 = 0; i2 < items.length; ++i2) {
            String value = items[i2];
            if (value == null || value.length() == 0) continue;
            if (value.indexOf(42) >= 0 || value.indexOf(63) >= 0) {
                filters.add(TngSqlFilter.like(column, value));
                continue;
            }
            if (in == null) {
                in = new ArrayList<String>();
            }
            in.add(value);
        }
        filters.add(TngSqlFilter.in(column, in));
        return TngSqlFilter.or(filters);
    }

    public static String inFromString(String column, String values) {
        return TngSqlFilter.in(column, TngUtilities.strTokenizeNotNull(values, ','));
    }

    public static String in(String column, char ... values) {
        String[] strings = new String[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            strings[i2] = Character.toString(values[i2]);
        }
        return TngSqlFilter.in(column, strings);
    }

    public static String in(String column, String ... values) {
        return TngSqlFilter.in(column, Arrays.asList(values));
    }

    public static String in(String column, List<String> values) {
        if (values == null || values.size() == 0) {
            return null;
        }
        StringBuilder h2 = new StringBuilder();
        h2.append(column);
        h2.append(" IN(");
        int count = 0;
        String last = null;
        for (int i2 = 0; i2 < values.size(); ++i2) {
            String value = values.get(i2);
            if (value == null || value.length() == 0) continue;
            if (++count > 1) {
                h2.append(',');
            }
            h2.append(TngSqlFilter.sqlStrValue(value));
            last = value;
        }
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return TngSqlFilter.equals(column, last);
        }
        h2.append(')');
        return h2.toString();
    }

    public static String equals(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return column + "=" + TngSqlFilter.sqlStrValue(value);
    }

    public static String equalsOrNull(String column, String value) {
        String f2 = TngSqlFilter.equals(column, value);
        if (f2 == null) {
            return column + " IS NULL";
        }
        return f2;
    }

    public static String startsWith(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return TngSqlFilter.like(column, value + "*");
    }

    public static String endsWith(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return TngSqlFilter.like(column, "*" + value);
    }

    public static String contains(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return TngSqlFilter.like(column, "*" + value + "*");
    }

    public static String like(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.indexOf(42) < 0 && value.indexOf(63) < 0) {
            return TngSqlFilter.equals(column, value);
        }
        return column + " LIKE '" + TngSqlFilter.patternLike(value) + "'" + LIKE_ESCAPE;
    }

    public static String startsWithInsensitive(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return TngSqlFilter.regexpLike(column, value + "*");
    }

    public static String endsWithInsensitive(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return TngSqlFilter.regexpLike(column, "*" + value);
    }

    public static String containsInsensitive(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return TngSqlFilter.regexpLike(column, "*" + value + "*");
    }

    public static String regexpLike(String column, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return "REGEXP_LIKE(" + column + ",'" + TngSqlFilter.patternRegexp(value) + "','i')";
    }

    private static String patternLike(String value) {
        StringBuilder like = new StringBuilder();
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == '*') {
                if (i2 != 0 && value.charAt(i2 - 1) == '*') continue;
                like.append('%');
                continue;
            }
            if (c2 == '?') {
                like.append('_');
                continue;
            }
            if (c2 == '%' || c2 == '_' || c2 == '\\') {
                like.append('\\');
            } else if (c2 == '\'') {
                like.append('\'');
            }
            like.append(c2);
        }
        return like.toString();
    }

    private static String patternRegexp(String value) {
        int i2;
        StringBuilder regexp = new StringBuilder();
        int size = value.length();
        for (i2 = 0; i2 < size && value.charAt(i2) == '*'; ++i2) {
        }
        if (i2 == size) {
            return ".";
        }
        if (i2 == 0) {
            regexp.append('^');
        }
        while (size > 0 && value.charAt(size - 1) == '*') {
            --size;
        }
        while (i2 < size) {
            char c2 = value.charAt(i2);
            if (c2 == '*') {
                if (value.charAt(i2 - 1) != '*') {
                    regexp.append(".*");
                }
            } else if (c2 == '?') {
                regexp.append('.');
            } else {
                if ("^$+|.()[]{}\\".indexOf(c2) >= 0) {
                    regexp.append('\\');
                } else if (c2 == '\'') {
                    regexp.append('\'');
                }
                regexp.append(c2);
            }
            ++i2;
        }
        if (size == value.length()) {
            regexp.append('$');
        }
        return regexp.toString();
    }

    public static String sqlStrValue(String value) {
        if (value.indexOf(39) >= 0) {
            value = value.replace("'", "''");
        }
        return "'" + value + "'";
    }
}

