/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.awt.Point;
import tangram.library.TngUtilities;

public class TngSqlOrder {
    public String sqlName;
    public String userName;
    public boolean asc;

    public TngSqlOrder() {
    }

    public TngSqlOrder(String sqlName) {
        this(sqlName, sqlName, true);
    }

    public TngSqlOrder(String sqlName, String userName) {
        this(sqlName, userName, true);
    }

    public TngSqlOrder(String sqlName, String userName, boolean asc) {
        this.sqlName = sqlName;
        this.userName = userName;
        this.asc = asc;
        if (userName == null || userName.length() == 0) {
            this.userName = sqlName;
        }
    }

    public String toString() {
        return this.userName + (this.asc ? " (Asc)" : " (Desc)");
    }

    public String getForOrder() {
        if (this.asc) {
            return this.sqlName;
        }
        return this.sqlName + " DESC";
    }

    public static int findInOrder(String order, String sqlName, Point p2) {
        if (p2 != null) {
            p2.setLocation(0, 0);
        }
        if (order == null || order.length() == 0) {
            return 0;
        }
        int f2 = order.indexOf(sqlName);
        if (f2 < 0) {
            return 0;
        }
        String[] items = order.split(",");
        boolean n2 = false;
        if (p2 != null) {
            p2.y = items.length;
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            String column = items[i2].trim();
            if (column.length() == 0) continue;
            boolean asc = true;
            if (column.endsWith(" ASC")) {
                column = TngUtilities.strCutEnd(column, 4).trim();
            } else if (column.endsWith(" DESC")) {
                asc = false;
                column = TngUtilities.strCutEnd(column, 5).trim();
            }
            if (!column.equals(sqlName)) continue;
            if (p2 != null) {
                p2.x = i2 + 1;
            }
            return asc ? 1 : -1;
        }
        return 0;
    }

    public static String syntetizeOrder(TngSqlOrder[] o2) {
        if (o2 == null || o2.length == 0) {
            return "";
        }
        String order = "";
        for (int i2 = 0; i2 < o2.length; ++i2) {
            if (i2 > 0) {
                order = order + ",";
            }
            order = order + o2[i2].getForOrder();
        }
        return order;
    }

    public static TngSqlOrder[] analyzeOrder(String order) {
        if (order == null || order.length() == 0) {
            return new TngSqlOrder[0];
        }
        String[] items = order.split(",");
        TngSqlOrder[] o2 = new TngSqlOrder[items.length];
        int n2 = 0;
        for (int i2 = 0; i2 < items.length; ++i2) {
            String column = items[i2].trim();
            if (column.length() == 0) continue;
            boolean asc = true;
            if (column.endsWith(" ASC")) {
                column = TngUtilities.strCutEnd(column, 4).trim();
            } else if (column.endsWith(" DESC")) {
                asc = false;
                column = TngUtilities.strCutEnd(column, 5).trim();
            }
            o2[n2++] = new TngSqlOrder(column, column, asc);
        }
        TngSqlOrder[] oo = new TngSqlOrder[n2];
        System.arraycopy(o2, 0, oo, 0, n2);
        return oo;
    }

    public static String changeOrderSimple(String order, String sqlName) {
        if (sqlName == null || sqlName.length() == 0) {
            return order;
        }
        int o2 = -TngSqlOrder.findInOrder(order, sqlName, null);
        if (o2 >= 0) {
            return sqlName;
        }
        return sqlName + " DESC";
    }

    public static String changeOrderMulti(String order, String sqlName) {
        int i2;
        if (sqlName == null || sqlName.length() == 0) {
            return order;
        }
        TngSqlOrder[] o2 = TngSqlOrder.analyzeOrder(order);
        for (i2 = 0; i2 < o2.length; ++i2) {
            if (!sqlName.equals(o2[i2].sqlName)) continue;
            o2[i2].asc = !o2[i2].asc;
            break;
        }
        order = TngSqlOrder.syntetizeOrder(o2);
        if (i2 >= o2.length) {
            if (order.length() > 0) {
                order = order + ",";
            }
            order = order + sqlName;
        }
        return order;
    }
}

