/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.ZipFile;
import sun.misc.SharedSecrets;
import tangram.library.Nat;
import tangram.library.TngImageSelection;

public final class TngUtilities {
    public static String application = null;
    public static Image applicationIcon = null;
    public static String[] applicationArgs = null;
    public static String exceptionLog = "log/error.log";
    public static final long MS_PER_DAY = 86400000L;
    public static final String DATE_FORMAT = "dd.MM.yyyy";
    public static final String DATETIME_FORMAT = "dd.MM.yyyy HH:mm:ss";
    public static final String DATETIMEMILLIS_FORMAT = "dd.MM.yyyy HH:mm:ss.SSS";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private static SimpleDateFormat fmtDate = new SimpleDateFormat("dd.MM.yyyy");
    private static SimpleDateFormat fmtDateTime = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static SimpleDateFormat fmtDateTimeMillis = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private static SimpleDateFormat fmtTime = new SimpleDateFormat("HH:mm:ss");
    private static Date fastDate = new Date();
    private static GregorianCalendar fastCal = new GregorianCalendar();
    public static String[] daysOfWeek = new String[]{Nat.x("Nede\u013ea"), Nat.x("Pondelok"), Nat.x("Utorok"), Nat.x("Streda"), Nat.x("\u0160tvrtok"), Nat.x("Piatok"), Nat.x("Sobota")};
    public static final String[] months = new String[]{Nat.x("Janu\u00e1r"), Nat.x("Febru\u00e1r"), Nat.x("Marec"), Nat.x("Apr\u00edl"), Nat.x("M\u00e1j"), Nat.x("J\u00fan"), Nat.x("J\u00fal"), Nat.x("August"), Nat.x("September"), Nat.x("Okt\u00f3ber"), Nat.x("November"), Nat.x("December")};
    private static String lastErrorLogged;
    public static final String DECIMAL_POINT = ".";
    public static final String DECIMAL_COMMA = ",";

    private TngUtilities() {
    }

    public static void initialize(String application, String[] applicationArgs) {
        TngUtilities.application = application;
        TngUtilities.applicationArgs = applicationArgs;
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        return fmtDate.format(date);
    }

    public static String timeToStr(Date date) {
        if (date == null) {
            return null;
        }
        return fmtTime.format(date);
    }

    public static Date strToDate(String value) {
        return TngUtilities.strToDate(value, fmtDate);
    }

    public static Date strToDate(String value, SimpleDateFormat sdf) {
        if (value == null || value.length() == 0 || sdf == null) {
            return null;
        }
        try {
            sdf.setLenient(false);
            return sdf.parse(value);
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateTimeToStr(long millis, SimpleDateFormat sdf) {
        Date date = fastDate;
        synchronized (date) {
            fastDate.setTime(millis);
            return sdf.format(fastDate);
        }
    }

    public static String dateTimeToStr(Date date, SimpleDateFormat sdf) {
        if (date == null) {
            return null;
        }
        return sdf.format(date);
    }

    public static String dateTimeToStr(Date date) {
        if (date == null) {
            return null;
        }
        return fmtDateTime.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToStr(long millis) {
        if (millis == 0L) {
            return null;
        }
        Date date = fastDate;
        synchronized (date) {
            fastDate.setTime(millis);
            return fmtDate.format(fastDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateTimeToStr(long millis) {
        if (millis == 0L) {
            return null;
        }
        Date date = fastDate;
        synchronized (date) {
            fastDate.setTime(millis);
            return fmtDateTime.format(fastDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateTimeMillisToStr(long millis) {
        if (millis == 0L) {
            return null;
        }
        Date date = fastDate;
        synchronized (date) {
            fastDate.setTime(millis);
            return fmtDateTimeMillis.format(fastDate);
        }
    }

    public static String strExt(String str1, String div, String str2) {
        if (str1 == null) {
            str1 = "";
        }
        if (div == null) {
            div = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        if (str1.length() == 0) {
            return str2;
        }
        if (str2.length() == 0) {
            return str1;
        }
        return str1 + div + str2;
    }

    public static String strExt(List<String> list, String div) {
        return TngUtilities.strExt(list, div, Integer.MAX_VALUE);
    }

    public static String strExt(List list, String div, int maxLength) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder h2 = new StringBuilder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String item;
            Object o2 = list.get(i2);
            if (o2 == null || (item = o2.toString()) == null || item.length() == 0) continue;
            if (h2.length() + item.length() > maxLength) {
                h2.append("...");
                break;
            }
            if (h2.length() > 0) {
                h2.append(div);
            }
            h2.append(item);
        }
        return h2.toString();
    }

    public static String strRight(String str, int len) {
        if (str == null) {
            return null;
        }
        if (str.length() < len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String strLeft(String str, int len) {
        if (str == null) {
            return null;
        }
        if (str.length() < len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String strCut(String str, int len) {
        if (str == null) {
            return null;
        }
        if (str.length() < len) {
            return "";
        }
        return TngUtilities.strRight(str, str.length() - len);
    }

    public static String strCutEnd(String str, int len) {
        return TngUtilities.strLeft(str, str.length() - len);
    }

    public static char strFirstChar(String str, char defChar) {
        if (str == null || str.length() == 0) {
            return defChar;
        }
        return str.charAt(0);
    }

    public static int strTokenizeTrim(String str, char div, String[] data) {
        int f2;
        if (str == null) {
            str = "";
        }
        int a2 = 0;
        int o2 = 0;
        while ((f2 = str.indexOf(div, o2)) >= 0 && a2 < data.length) {
            data[a2++] = str.substring(o2, f2).trim();
            o2 = f2 + 1;
        }
        if (a2 < data.length) {
            data[a2++] = str.substring(o2, str.length()).trim();
            for (int i2 = a2; i2 < data.length; ++i2) {
                data[i2] = "";
            }
        }
        return a2;
    }

    public static void closeSafe(Closeable obj) {
        if (obj == null) {
            return;
        }
        try {
            obj.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSafe(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void streamCloseSafe(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void streamCloseSafe(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String randomString(int length) {
        if (length < 1) {
            return "";
        }
        StringBuilder h2 = new StringBuilder(length);
        int r2 = 26;
        for (int i2 = 0; i2 < length; ++i2) {
            int a2 = (int)(1000.0 * Math.random() % (double)r2);
            h2.append((char)(a2 + 65));
        }
        return h2.toString();
    }

    public static int hexCharTo(char hex) throws NumberFormatException {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        throw new NumberFormatException();
    }

    public static int hexCharsToByte(char[] src) throws NumberFormatException {
        int value = TngUtilities.hexCharTo(src[0]);
        value = (value << 4) + TngUtilities.hexCharTo(src[1]);
        return value;
    }

    public static int hexStringToByte(String src) throws NumberFormatException {
        int value = TngUtilities.hexCharTo(src.charAt(0));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(1));
        return value;
    }

    public static int hexStringToDword(String src, int offset) throws NumberFormatException {
        int value = TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        value = (value << 4) + TngUtilities.hexCharTo(src.charAt(offset++));
        return value;
    }

    public static int hexCharsToWord(char[] src) throws NumberFormatException {
        int value = TngUtilities.hexCharTo(src[0]);
        value = (value << 4) + TngUtilities.hexCharTo(src[1]);
        value = (value << 4) + TngUtilities.hexCharTo(src[2]);
        value = (value << 4) + TngUtilities.hexCharTo(src[3]);
        return value;
    }

    public static int hexCharsToDword(char[] src, int offset) throws NumberFormatException {
        int value = TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        value = (value << 4) + TngUtilities.hexCharTo(src[offset++]);
        return value;
    }

    public static char hexCharFrom(int value) {
        if ((value &= 0xF) <= 9) {
            return (char)(48 + value);
        }
        return (char)(55 + value);
    }

    public static void hexCharsFromByte(int value, char[] dest) {
        dest[0] = TngUtilities.hexCharFrom(value >>> 4);
        dest[1] = TngUtilities.hexCharFrom(value >>> 0);
    }

    public static void hexCharsFromWord(int value, char[] dest) {
        dest[0] = TngUtilities.hexCharFrom(value >>> 12);
        dest[1] = TngUtilities.hexCharFrom(value >>> 8);
        dest[2] = TngUtilities.hexCharFrom(value >>> 4);
        dest[3] = TngUtilities.hexCharFrom(value >>> 0);
    }

    public static void hexCharsFromDword(int value, char[] dest, int offset) {
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 28);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 24);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 20);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 16);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 12);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 8);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 4);
        dest[offset++] = TngUtilities.hexCharFrom(value >>> 0);
    }

    public static void hexCharsFromInt(StringBuilder buff, int value, int hexdigits) {
        int shift = hexdigits << 2;
        for (int i2 = 0; i2 < hexdigits; ++i2) {
            buff.append(TngUtilities.hexCharFrom(value >>> (shift -= 4)));
        }
    }

    public static int hex2decimal(String s2) {
        String digits = "0123456789ABCDEF";
        s2 = s2.toUpperCase();
        int val = 0;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            int d2 = digits.indexOf(c2);
            val = 16 * val + d2;
        }
        return val;
    }

    public static String where1(String flt1) {
        if (flt1 == null || flt1.length() == 0) {
            return "";
        }
        return "\nWHERE " + flt1;
    }

    public static String where2(String flt1, String flt2) {
        String filter = TngUtilities.strExt(flt1, " and ", flt2);
        if (filter.length() == 0) {
            return "";
        }
        return "\nWHERE " + filter;
    }

    public static String where3(String flt1, String flt2, String flt3) {
        String filter = TngUtilities.strExt(flt1, " and ", flt2);
        if ((filter = TngUtilities.strExt(filter, " and ", flt3)).length() == 0) {
            return "";
        }
        return "\nWHERE " + filter;
    }

    public static String strPadLeft(String str, int len) {
        return TngUtilities.strPadLeft(str, len, ' ');
    }

    public static String strPadLeft(String str, int len, char c2) {
        int ln;
        if (str == null) {
            str = "";
        }
        if ((ln = str.length()) >= len) {
            return str;
        }
        StringBuffer buff = new StringBuffer(len);
        buff.append(str);
        int m2 = len - ln;
        for (int i2 = 0; i2 < m2; ++i2) {
            buff.append(c2);
        }
        return buff.toString();
    }

    public static String strPadRight(String str, int len) {
        return TngUtilities.strPadRight(str, len, ' ');
    }

    public static String strPadRight(String str, int len, char c2) {
        int ln;
        if (str == null) {
            str = "";
        }
        if ((ln = str.length()) >= len) {
            return str;
        }
        StringBuffer buff = new StringBuffer(len);
        int m2 = len - ln;
        for (int i2 = 0; i2 < m2; ++i2) {
            buff.append(c2);
        }
        buff.append(str);
        return buff.toString();
    }

    public static String strPadCenter(String str, int len) {
        return TngUtilities.strPadCenter(str, len, ' ');
    }

    public static String strPadCenter(String str, int len, char c2) {
        int i2;
        int ln;
        if (str == null) {
            str = "";
        }
        if ((ln = str.length()) >= len) {
            return str;
        }
        ln = len - ln >> 1;
        StringBuffer buff = new StringBuffer(len);
        for (i2 = 0; i2 < ln; ++i2) {
            buff.append(c2);
        }
        buff.append(str);
        for (i2 = buff.length(); i2 < len; ++i2) {
            buff.append(c2);
        }
        return buff.toString();
    }

    public static File getFileAppFull(String subpath) {
        if (subpath.charAt(0) == '\\') {
            return new File(subpath);
        }
        if (subpath.charAt(0) == '/') {
            return new File(subpath);
        }
        if (subpath.length() > 1 && subpath.charAt(1) == ':') {
            return new File(subpath);
        }
        File f2 = new File(subpath);
        return f2;
    }

    public static String minutyToStr(int minuty) {
        return TngUtilities.minutyToStr(minuty, 2);
    }

    public static String minutyToStr(int minuty, int hhdigits) {
        if (minuty < 0) {
            return null;
        }
        int h2 = minuty / 60;
        int m2 = minuty - h2 * 60;
        StringBuilder buff = new StringBuilder(8);
        String hh = Integer.toString(h2);
        int zeros = hhdigits - hh.length();
        for (int i2 = 0; i2 < zeros; ++i2) {
            buff.append('0');
        }
        buff.append(hh);
        buff.append(':');
        if (m2 < 10) {
            buff.append('0');
        }
        buff.append(m2);
        return buff.toString();
    }

    public static int strToMinuty(String str) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        try {
            String hh = "";
            String mm = str;
            int p2 = str.indexOf(58);
            if (p2 > 0) {
                hh = str.substring(0, p2);
                mm = str.substring(p2 + 1);
            }
            int h2 = hh.length() == 0 ? 0 : Integer.parseInt(hh);
            int m2 = mm.length() == 0 ? 0 : Integer.parseInt(mm);
            return h2 * 60 + m2;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    public static String round(Float d2) {
        long factor = (long)Math.pow(10.0, 2.0);
        double val = d2.floatValue() * (float)factor;
        long tmp = Math.round(val);
        double doub = (double)tmp / (double)factor;
        String s2 = String.valueOf(doub);
        int pos = s2.indexOf(DECIMAL_POINT);
        if (pos == -1) {
            s2 = s2 + ".00";
        } else {
            int p2;
            for (int i2 = p2 = s2.length() - pos - 1; i2 < 2; ++i2) {
                s2 = s2 + "0";
            }
        }
        return s2;
    }

    public static String round(int d2) {
        long factor = (long)Math.pow(10.0, 2.0);
        double val = (long)d2 * factor;
        long tmp = Math.round(val);
        double doub = (double)tmp / (double)factor;
        String s2 = String.valueOf(doub);
        int pos = s2.indexOf(DECIMAL_POINT);
        if (pos == -1) {
            s2 = s2 + ".00";
        } else {
            int p2 = s2.length() - pos - 1;
            for (int i2 = 0; i2 < p2; ++i2) {
                s2 = s2 + "0";
            }
        }
        return s2;
    }

    public static String exceptionText(Throwable e2) {
        String text;
        if (e2 == null) {
            return null;
        }
        String string = text = e2.getMessage() == null ? null : e2.getMessage().trim();
        if (text != null && text.length() > 16) {
            return text;
        }
        return e2.toString();
    }

    public static void exceptionLog(Throwable e2) {
        String stack = TngUtilities.exceptionStack(e2, 32, true);
        TngUtilities.errorLog(e2.toString() + "\n\n" + Nat.nox("Poz\u00edcia:") + "\n" + stack);
    }

    public static String exceptionStack(Throwable e2, int maximum, boolean spaces) {
        int i2;
        if (e2 == null) {
            return null;
        }
        StringBuilder stack = new StringBuilder(512);
        StackTraceElement[] ste = e2.getStackTrace();
        for (i2 = 0; i2 < ste.length && i2 < maximum; ++i2) {
            if (i2 > 0) {
                stack.append("\n");
            }
            if (spaces) {
                stack.append(" ");
            }
            stack.append(ste[i2].toString());
        }
        if (i2 < ste.length) {
            stack.append("\n ...");
        }
        return stack.toString();
    }

    public static void errorLog(String text) {
        if (text == null) {
            return;
        }
        String h2 = "";
        if (application != null) {
            h2 = h2 + " " + application;
        }
        if ((h2 = h2 + "\n" + text + "\n").equals(lastErrorLogged)) {
            h2 = " -||-";
        } else {
            lastErrorLogged = h2;
        }
        h2 = TngUtilities.dateTimeToStr(new Date()) + h2;
        System.err.println(h2);
        TngUtilities.strAppendToFileSilent(exceptionLog, h2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void strAppendToFileSilent(String fileName, String textToWrite) {
        PrintStream s2 = null;
        try {
            File file = new File(fileName);
            File path = file.getParentFile();
            if (path != null && !path.exists() && !path.mkdirs()) {
                return;
            }
            s2 = new PrintStream(new FileOutputStream(file, true));
            s2.println(textToWrite);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        finally {
            if (s2 != null) {
                s2.close();
            }
        }
    }

    public static void printToFile(String fileName, boolean append, String textToWrite) throws Exception {
        try {
            FileOutputStream fout = new FileOutputStream(fileName, append);
            new PrintStream(fout).println(textToWrite);
            fout.close();
        }
        catch (Exception ee) {
            throw new Exception(Nat.x("Chyba pri z\u00e1pise do s\u00faboru %1", fileName), ee);
        }
    }

    public static String getArgumentString(String name, String defValue) {
        if (applicationArgs == null || name == null || name.length() == 0) {
            return defValue;
        }
        name = name.toUpperCase();
        String nameStart = name + "=";
        for (int i2 = 0; i2 < applicationArgs.length; ++i2) {
            String h2 = applicationArgs[i2];
            if (h2.length() == name.length() && h2.toUpperCase().equals(name)) {
                return "";
            }
            if (h2.length() < nameStart.length() || !h2.substring(0, nameStart.length()).toUpperCase().equals(nameStart)) continue;
            return h2.substring(nameStart.length());
        }
        return defValue;
    }

    public static int getArgumentInteger(String name, int defValue) {
        String h2 = TngUtilities.getArgumentString(name, null);
        return TngUtilities.strToInt(h2, defValue);
    }

    public static int strToInt(Object value, int defValue) {
        if (value == null) {
            return defValue;
        }
        return TngUtilities.strToInt(value.toString(), defValue);
    }

    public static int strToInt(String value, int defValue) {
        if (value == null || value.length() == 0) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e2) {
            return defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dateHasTime(Date date) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            if (fastCal.get(14) != 0) {
                return true;
            }
            if (fastCal.get(13) != 0) {
                return true;
            }
            if (fastCal.get(12) != 0) {
                return true;
            }
            return fastCal.get(11) != 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateOnly(Date date) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            int year = fastCal.get(1);
            int month = fastCal.get(2);
            int day = fastCal.get(5);
            fastCal.setTimeInMillis(0L);
            fastCal.set(year, month, day, 0, 0, 0);
            return fastCal.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateDayName(Date date) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            return daysOfWeek[fastCal.get(7) - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dateCompare(Date a2, Date b2) {
        if (a2 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return a2 == null ? 0 : 1;
        }
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(a2);
            int aYear = fastCal.get(1);
            int aDays = fastCal.get(6);
            fastCal.setTime(b2);
            int bYear = fastCal.get(1);
            int bDays = fastCal.get(6);
            int d2 = aYear - bYear;
            if (d2 != 0) {
                return d2;
            }
            return aDays - bDays;
        }
    }

    public static long daysBetween(Date startDate, Date endDate) {
        if (startDate == null || endDate == null || !startDate.before(endDate)) {
            return 0L;
        }
        GregorianCalendar calStartDate = new GregorianCalendar();
        calStartDate.setTime(startDate);
        GregorianCalendar calEndDate = new GregorianCalendar();
        calEndDate.setTime(endDate);
        return TngUtilities.daysBetween(calStartDate, calEndDate);
    }

    public static long daysBetween(Calendar startDate, Calendar endDate) {
        if (startDate == null || endDate == null || !startDate.before(endDate)) {
            return 0L;
        }
        Calendar sDate = (Calendar)startDate.clone();
        long daysBetween = 0L;
        int y1 = sDate.get(1);
        int y2 = endDate.get(1);
        int m1 = sDate.get(2);
        int m2 = endDate.get(2);
        while ((y2 - y1) * 12 + (m2 - m1) > 12) {
            if (sDate.get(2) == 0 && sDate.get(5) == sDate.getActualMinimum(5)) {
                daysBetween += (long)sDate.getActualMaximum(6);
                sDate.add(1, 1);
            } else {
                int diff = 1 + sDate.getActualMaximum(6) - sDate.get(6);
                sDate.add(6, diff);
                daysBetween += (long)diff;
            }
            y1 = sDate.get(1);
        }
        while ((m2 - m1) % 12 > 1) {
            daysBetween += (long)sDate.getActualMaximum(5);
            sDate.add(2, 1);
            m1 = sDate.get(2);
        }
        while (TngUtilities.dateCompare(sDate.getTime(), endDate.getTime()) < 0) {
            sDate.add(5, 1);
            ++daysBetween;
        }
        return daysBetween;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int timeCompare(Date a2, Date b2) {
        if (a2 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return a2 == null ? 0 : 1;
        }
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(a2);
            int aHour = fastCal.get(11);
            int aMin = fastCal.get(12);
            int aSec = fastCal.get(13);
            fastCal.setTime(b2);
            int bHour = fastCal.get(11);
            int bMin = fastCal.get(12);
            int bSec = fastCal.get(13);
            int d2 = aHour - bHour;
            if (d2 != 0) {
                return d2;
            }
            d2 = aMin - bMin;
            if (d2 != 0) {
                return d2;
            }
            return aSec - bSec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int timeDayMinutes(long time) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTimeInMillis(time);
            int hour = fastCal.get(11);
            int min = fastCal.get(12);
            return hour * 60 + min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int timeDaySeconds(long time) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTimeInMillis(time);
            int hour = fastCal.get(11);
            int min = fastCal.get(12);
            int sec = fastCal.get(13);
            return hour * 24 + min * 60 + sec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateSetTime(Date date, int hour, int min, int sec) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            fastCal.set(fastCal.get(1), fastCal.get(2), fastCal.get(5), hour, min, sec);
            return fastCal.getTime();
        }
    }

    public static Date dateAddMonths(Date date, int months) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateAddDays(Date date, int days) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            fastCal.add(5, days);
            return fastCal.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateMonthBegin(Date date) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            fastCal.set(5, 1);
            return fastCal.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateMonthEnd(Date date) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTime(date);
            int lastDay = fastCal.getActualMaximum(5);
            fastCal.set(5, lastDay);
            return fastCal.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dateMonthBegin(long milis) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTimeInMillis(milis);
            fastCal.set(5, 1);
            return fastCal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dateMonthEnd(long milis) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.setTimeInMillis(milis);
            int lastDay = fastCal.getActualMaximum(5);
            fastCal.set(5, lastDay);
            return fastCal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateCreate(int year, int month, int day) {
        GregorianCalendar gregorianCalendar = fastCal;
        synchronized (gregorianCalendar) {
            fastCal.set(year, month - 1, day);
            return fastCal.getTime();
        }
    }

    public static int dateDifferenceDays(Date dateA, Date dateB) {
        dateA = TngUtilities.dateOnly(dateA);
        dateB = TngUtilities.dateOnly(dateB);
        long ms = dateA.getTime() - dateB.getTime();
        int days = (int)(ms / 86400000L);
        return days;
    }

    public static int strCharCount(String str, char div) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int length = str.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (str.charAt(i2) != div) continue;
            ++count;
        }
        return count;
    }

    public static String[] strTokenizeNotNull(String str, char div) {
        String[] items = TngUtilities.strTokenizeOrNull(str, div);
        if (items == null) {
            return new String[0];
        }
        return items;
    }

    public static String[] strTokenizeOrNull(String str, char div) {
        if (str == null || str.length() == 0) {
            return null;
        }
        int count = TngUtilities.strCharCount(str, div);
        String[] items = new String[count + 1];
        if (count == 0) {
            items[0] = str;
            return items;
        }
        int length = str.length();
        int offset = 0;
        int x = 0;
        for (int i2 = 0; i2 < length && count > 0; ++i2) {
            if (str.charAt(i2) != div) continue;
            items[x++] = str.substring(offset, i2);
            offset = i2 + 1;
            --count;
        }
        items[x] = str.substring(offset);
        return items;
    }

    public static String strRepeat(char c2, int count) {
        StringBuilder s2 = new StringBuilder(count);
        for (int i2 = 0; i2 < count; ++i2) {
            s2.append(c2);
        }
        return s2.toString();
    }

    public static String strSubstrOrNull(String str, int offset) {
        return TngUtilities.strSubstrOrNull(str, offset, -1);
    }

    public static String strSubstrOrNull(String str, int offset, int length) {
        if (str == null) {
            return null;
        }
        if (offset < 0 || offset >= str.length()) {
            return null;
        }
        if (length == -1 || offset + length >= str.length()) {
            return str.substring(offset);
        }
        return str.substring(offset, offset + length);
    }

    public static String strStretchCutLeft(String left, String between, String right, int len) {
        if (left == null) {
            left = "";
        }
        if (between == null) {
            between = "";
        }
        if (right == null) {
            right = "";
        }
        int rn = right.length();
        int bn = between.length();
        if (rn >= len) {
            return right;
        }
        int leftSide = len - (rn + bn);
        if (leftSide <= 0) {
            return TngUtilities.strPadRight(right, len, ' ');
        }
        StringBuilder buff = new StringBuilder(len);
        buff.append(left);
        if (leftSide < buff.length()) {
            buff.setLength(leftSide);
        }
        buff.append(between);
        leftSide = len - rn;
        while (buff.length() < leftSide) {
            buff.append(' ');
        }
        buff.append(right);
        return buff.toString();
    }

    public static void strWrap(String text, int maxWidth, ArrayList<String> lines) {
        text = text == null ? "" : text;
        lines.clear();
        int p2 = 0;
        while (p2 < text.length()) {
            int e2 = p2 + maxWidth;
            if (e2 >= text.length()) {
                lines.add(text.substring(p2));
                break;
            }
            int f2 = text.lastIndexOf(32, e2);
            if (f2 >= p2) {
                e2 = f2;
                while (e2 - 1 >= p2 && text.charAt(e2 - 1) == ' ') {
                    --e2;
                }
            }
            if (p2 != e2) {
                lines.add(text.substring(p2, e2));
            }
            for (p2 = e2; p2 < text.length() && text.charAt(p2) == ' '; ++p2) {
            }
        }
    }

    public static BigDecimal fixDecimals(BigDecimal num, int decimals) {
        if (num == null) {
            return null;
        }
        if (decimals < 0) {
            decimals = 0;
        }
        if (num.scale() == decimals) {
            return num;
        }
        if (num.signum() == 0) {
            return decimals == 0 ? BigDecimal.ZERO : BigDecimal.ZERO.setScale(decimals, 4);
        }
        if (num.scale() > decimals) {
            num = num.stripTrailingZeros();
        }
        if (num.scale() == decimals) {
            return num;
        }
        if (num.scale() < decimals) {
            return num.setScale(decimals, 4);
        }
        return num;
    }

    public static BigDecimal trimDecimals(BigDecimal num, int minDecimals, int maxDecimals) {
        if (num == null) {
            return null;
        }
        if (minDecimals < 0) {
            minDecimals = 0;
        }
        if (maxDecimals >= 0 && minDecimals > maxDecimals) {
            num = num.setScale(maxDecimals, 4);
            num = num.setScale(minDecimals, 4);
            return num;
        }
        num = TngUtilities.fixDecimals(num, minDecimals);
        if (maxDecimals >= 0 && num.scale() > maxDecimals) {
            num = num.setScale(maxDecimals, 4);
        }
        return num;
    }

    public static String numberToString(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.toString().replace(DECIMAL_POINT, DECIMAL_COMMA);
    }

    public static String numberToString(BigDecimal number, int decimals) {
        if (number == null) {
            return null;
        }
        if (decimals >= 0) {
            number = number.setScale(decimals, 4);
        }
        String h2 = number.toString();
        if (decimals != 0) {
            h2 = h2.replace(DECIMAL_POINT, DECIMAL_COMMA);
        }
        return h2;
    }

    public static BigDecimal numberOrZero(BigDecimal number) {
        if (number == null) {
            return BigDecimal.ZERO;
        }
        return number;
    }

    public static BigDecimal stringToNumber(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(text.replace(DECIMAL_COMMA, DECIMAL_POINT));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String nullToEmpty(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String emptyToNull(String value) {
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    public static String deleteCharAll(String text, char c2) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int i2 = text.indexOf(c2);
        if (i2 < 0) {
            return text;
        }
        StringBuilder h2 = new StringBuilder(text);
        while (i2 < h2.length()) {
            if (h2.charAt(i2) == c2) {
                h2.deleteCharAt(i2);
                continue;
            }
            ++i2;
        }
        return h2.toString();
    }

    public static String replaceBinaryCharAll(String text, char c2) {
        if (text == null || text.length() < 0) {
            return text;
        }
        StringBuilder h2 = new StringBuilder(text);
        for (int i2 = 0; i2 < h2.length(); ++i2) {
            if (h2.charAt(i2) >= ' ') continue;
            h2.setCharAt(i2, c2);
        }
        return h2.toString();
    }

    public static String strDigits(String text) {
        if (text == null || text.length() < 0) {
            return text;
        }
        StringBuilder h2 = new StringBuilder(text.length());
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 < '0' || c2 > '9') continue;
            h2.append(c2);
        }
        return h2.toString();
    }

    public static int countOccurrences(String haystack, char needle) {
        if (haystack == null || haystack.length() == 0) {
            return 0;
        }
        int count = 0;
        for (int i2 = 0; i2 < haystack.length(); ++i2) {
            if (haystack.charAt(i2) != needle) continue;
            ++count;
        }
        return count;
    }

    public static String getClipboardAsString() {
        Object clipObject = TngUtilities.getClipboard(DataFlavor.stringFlavor);
        return clipObject == null ? null : (String)clipObject;
    }

    public static Image getClipboardAsImage() {
        Object clipObject = TngUtilities.getClipboard(DataFlavor.imageFlavor);
        return clipObject == null ? null : (Image)clipObject;
    }

    private static Object getClipboard(DataFlavor dataFlavor) {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(dataFlavor)) {
                return t.getTransferData(dataFlavor);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    public static void setClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        TngUtilities.setClipboard(ss);
    }

    public static void setClipboard(Image image) {
        TngImageSelection is = new TngImageSelection(image);
        TngUtilities.setClipboard(is);
    }

    private static void setClipboard(Transferable transferable) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    public static String getPackageName(Object comp) {
        if (comp == null) {
            return null;
        }
        Class<?> clazz = comp.getClass();
        if (clazz == null) {
            return null;
        }
        Package pckg = clazz.getPackage();
        if (pckg == null) {
            return null;
        }
        return pckg.getName();
    }

    public static String getClassName(Component comp) {
        if (comp == null) {
            return null;
        }
        Class<?> clazz = comp.getClass();
        if (clazz == null) {
            return null;
        }
        return clazz.getSimpleName();
    }

    public static String strCapitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        String lower = str.toLowerCase();
        String capLetter = TngUtilities.strLeft(lower, 1).toUpperCase();
        String lowerWithoutCapLetter = TngUtilities.strCut(lower, 1);
        return TngUtilities.strExt(capLetter, "", lowerWithoutCapLetter);
    }

    public static boolean deleteDirectory(File path) {
        if (path == null) {
            return true;
        }
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                if (files[i2].isDirectory()) {
                    TngUtilities.deleteDirectory(files[i2]);
                    continue;
                }
                files[i2].delete();
            }
        }
        return path.delete();
    }

    public static String stringEscapesOff(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder h2 = new StringBuilder(text.length());
        for (int i2 = 0; i2 < text.length(); ++i2) {
            int c2 = text.charAt(i2);
            if (c2 == 92 && i2 + 1 < text.length()) {
                if ((c2 = text.charAt(++i2)) == 98) {
                    c2 = 8;
                } else if (c2 == 116) {
                    c2 = 9;
                } else if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 102) {
                    c2 = 12;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 34) {
                    c2 = 34;
                } else if (c2 == 39) {
                    c2 = 39;
                } else if (c2 == 92) {
                    c2 = 92;
                }
            }
            h2.append((char)c2);
        }
        if (text.length() == h2.length()) {
            return text;
        }
        return h2.toString();
    }

    public static <E extends Enum<E>> E valueOfOrNull(Class<E> enumClass, String name) {
        if (name == null) {
            return null;
        }
        Enum[] v = SharedSecrets.getJavaLangAccess().getEnumConstantsShared(enumClass);
        for (int i2 = 0; i2 < v.length; ++i2) {
            if (!v[i2].name().equals(name)) continue;
            return (E)v[i2];
        }
        return null;
    }

    public static <E extends Enum<E>> E valueOf(String name, E enumDefault) {
        if (name == null) {
            return enumDefault;
        }
        Class<?> enumClass = enumDefault.getClass();
        Enum[] v = SharedSecrets.getJavaLangAccess().getEnumConstantsShared(enumClass);
        for (int i2 = 0; i2 < v.length; ++i2) {
            if (!v[i2].name().equals(name)) continue;
            return (E)v[i2];
        }
        return enumDefault;
    }
}

