/*
 * Decompiled with CFR 0.152.
 */
package tangram.qrcode;

import com.bysquare.document.invoice.Contact;
import com.bysquare.document.invoice.CustomerParty;
import com.bysquare.document.invoice.Invoice;
import com.bysquare.document.invoice.MonetarySummary;
import com.bysquare.document.invoice.Party;
import com.bysquare.document.invoice.PaymentMean;
import com.bysquare.document.invoice.PostalAddress;
import com.bysquare.document.invoice.SupplierParty;
import com.bysquare.document.invoice.TaxCategorySummaries;
import com.bysquare.document.invoice.TaxCategorySummary;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import tangram.exception.TngException;
import tangram.library.Nat;
import tangram.qrcode.TngBysquareParams;
import tangram.qrcode.TngBysquareUtils;
import tangram.qrcode.TngInvoiceBysquareFactory;

public class TngInvoiceBysquare {
    public static Invoice createInvoice(TngBysquareParams bysquareParams) {
        Integer numberOfInvoiceLines;
        PaymentMean paymentMean;
        TaxCategorySummary taxCategorySummary;
        if (bysquareParams == null) {
            bysquareParams = new TngBysquareParams();
        }
        Party supplierPartyParty = TngInvoiceBysquareFactory.createParty(bysquareParams.getString(Items.SUPPLIER_PARTY_NAME), bysquareParams.getString(Items.SUPPLIER_COMPANY_TAX_ID), bysquareParams.getString(Items.SUPPLIER_COMPANY_VAT_ID), bysquareParams.getString(Items.SUPPLIER_COMPANY_REGISTER_ID));
        PostalAddress supplierPartyPostalAddress = TngInvoiceBysquareFactory.createPostalAddress(bysquareParams.getString(Items.SUPPLIER_POSTAL_ADDRESS_STREET_NAME), bysquareParams.getString(Items.SUPPLIER_POSTAL_ADDRESS_BUILDING_NUMBER), bysquareParams.getString(Items.SUPPLIER_POSTAL_ADDRESS_CITY_NAME), bysquareParams.getString(Items.SUPPLIER_POSTAL_ADDRESS_POSTAL_ZONE), bysquareParams.getString(Items.SUPPLIER_POSTAL_ADDRESS_STATE), bysquareParams.getString(Items.SUPPLIER_POSTAL_ADDRESS_COUNTRY));
        Contact supplierPartyContact = TngInvoiceBysquareFactory.createContact(bysquareParams.getString(Items.SUPPLIER_CONTACT_NAME), bysquareParams.getString(Items.SUPPLIER_CONTACT_TELEPHONE), bysquareParams.getString(Items.SUPPLIER_CONTACT_EMAIL));
        SupplierParty supplierParty = TngInvoiceBysquareFactory.createSupplierParty(supplierPartyParty, supplierPartyPostalAddress, supplierPartyContact);
        Party customerPartyParty = TngInvoiceBysquareFactory.createParty(bysquareParams.getString(Items.CUSTOMER_PARTY_NAME), bysquareParams.getString(Items.CUSTOMER_COMPANY_TAX_ID), bysquareParams.getString(Items.CUSTOMER_COMPANY_VAT_ID), bysquareParams.getString(Items.CUSTOMER_COMPANY_REGISTER_ID));
        CustomerParty customerParty = TngInvoiceBysquareFactory.createCustomerParty(customerPartyParty, bysquareParams.getString(Items.CUSTOMER_PARTY_IDENTIFICATION));
        TaxCategorySummaries taxCategorySummaries = new TaxCategorySummaries();
        BigDecimal taxCat1 = bysquareParams.getBigDecimal(Items.CLASSIFIED_TAX_CATEGORY1);
        BigDecimal taxCat2 = bysquareParams.getBigDecimal(Items.CLASSIFIED_TAX_CATEGORY2);
        BigDecimal taxCat3 = bysquareParams.getBigDecimal(Items.CLASSIFIED_TAX_CATEGORY3);
        if (taxCat1 != null) {
            taxCategorySummary = TngInvoiceBysquareFactory.createTaxCategorySummary(taxCat1, bysquareParams.getBigDecimal(Items.TAX_EXCLUSIVE_AMOUNT1), bysquareParams.getBigDecimal(Items.TAX_AMOUNT1), null, null);
            taxCategorySummaries.add(taxCategorySummary);
        }
        if (taxCat2 != null) {
            taxCategorySummary = TngInvoiceBysquareFactory.createTaxCategorySummary(taxCat2, bysquareParams.getBigDecimal(Items.TAX_EXCLUSIVE_AMOUNT2), bysquareParams.getBigDecimal(Items.TAX_AMOUNT2), null, null);
            taxCategorySummaries.add(taxCategorySummary);
        }
        if (taxCat3 != null) {
            taxCategorySummary = TngInvoiceBysquareFactory.createTaxCategorySummary(taxCat3, bysquareParams.getBigDecimal(Items.TAX_EXCLUSIVE_AMOUNT3), bysquareParams.getBigDecimal(Items.TAX_AMOUNT3), null, null);
            taxCategorySummaries.add(taxCategorySummary);
        }
        MonetarySummary monetarySummary = TngInvoiceBysquareFactory.createMonetarySummary(bysquareParams.getBigDecimal(Items.PAYABLE_ROUNDING_AMOUNT), bysquareParams.getBigDecimal(Items.PAID_DEPOSITS_AMOUNT));
        ArrayList<PaymentMean> paymentMeans = new ArrayList<PaymentMean>();
        String paymentMeanTng = bysquareParams.getString(Items.PAYMENT_MEAN);
        PaymentMean paymentMean2 = paymentMean = "P".equalsIgnoreCase(paymentMeanTng) ? PaymentMean.moneyTransfer : PaymentMean.other;
        if (paymentMean != null) {
            paymentMeans.add(paymentMean);
        }
        if ((numberOfInvoiceLines = bysquareParams.getInteger(Items.NUMBER_OF_INVOICE_LINES)) == null) {
            numberOfInvoiceLines = 0;
        }
        Invoice invoice = TngInvoiceBysquareFactory.createInvoice(bysquareParams.getString(Items.INVOICE_ID), bysquareParams.getDate(Items.ISSUE_DATE), bysquareParams.getDate(Items.TAX_POINT_DATE), null, null, bysquareParams.getString(Items.LOCAL_CURRENCY_CODE), bysquareParams.getString(Items.FOREIGN_CURRENCY_CODE), bysquareParams.getBigDecimal(Items.CURR_RATE), bysquareParams.getBigDecimal(Items.REFERENCE_CURR_RATE), supplierParty, customerParty, numberOfInvoiceLines, bysquareParams.getString(Items.INVOICE_DESCRIPTION), null, taxCategorySummaries, monetarySummary, paymentMeans);
        return invoice;
    }

    public static TngBysquareParams createBysquareParams(Invoice invoice) throws Exception {
        SupplierParty supplierParty;
        CustomerParty customerParty;
        TngBysquareParams bysquareParams = new TngBysquareParams();
        if (invoice == null) {
            return bysquareParams;
        }
        bysquareParams.setString(Items.INVOICE_ID, invoice.getInvoiceID());
        bysquareParams.setDate(Items.ISSUE_DATE, invoice.getIssueDate());
        bysquareParams.setDate(Items.TAX_POINT_DATE, invoice.getTaxPointDate());
        bysquareParams.setString(Items.LOCAL_CURRENCY_CODE, invoice.getLocalCurrencyCode());
        bysquareParams.setString(Items.FOREIGN_CURRENCY_CODE, invoice.getForeignCurrencyCode());
        bysquareParams.setBigDecimal(Items.CURR_RATE, TngBysquareUtils.doubleToDecimal(invoice.getCurrRate()));
        bysquareParams.setBigDecimal(Items.REFERENCE_CURR_RATE, TngBysquareUtils.doubleToDecimal(invoice.getReferenceCurrRate()));
        bysquareParams.setInteger(Items.NUMBER_OF_INVOICE_LINES, invoice.getNumberOfInvoiceLines());
        bysquareParams.setString(Items.INVOICE_DESCRIPTION, invoice.getInvoiceDescription());
        List<PaymentMean> paymentMeans = invoice.getPaymentMeans();
        if (paymentMeans != null) {
            PaymentMean paymentMean;
            int paymentMeansCount = paymentMeans.size();
            if (paymentMeansCount > 1) {
                throw new TngException(Nat.x("Aplik\u00e1cia nepodporuje na\u010d\u00edtavanie QR k\u00f3du s viac ako jedn\u00fdm sp\u00f4sobom platby, po\u010det sp\u00f4sobov platby v QR k\u00f3de %1", paymentMeansCount));
            }
            if (paymentMeansCount != 0 && (paymentMean = paymentMeans.get(0)) != null) {
                bysquareParams.setString(Items.PAYMENT_MEAN, PaymentMean.creditCard == paymentMean ? "P" : "P");
            }
        }
        int summaryCounter = 0;
        TaxCategorySummaries taxCategorySummaries = invoice.getTaxCategorySummaries();
        if (taxCategorySummaries != null) {
            for (TaxCategorySummary taxCategorySummary : taxCategorySummaries) {
                if (taxCategorySummary == null) continue;
                BigDecimal a2 = TngBysquareUtils.doubleToDecimal(taxCategorySummary.getClassifiedTaxCategory());
                BigDecimal b2 = TngBysquareUtils.doubleToDecimal(taxCategorySummary.getTaxExclusiveAmount());
                BigDecimal c2 = TngBysquareUtils.doubleToDecimal(taxCategorySummary.getTaxExclusiveAmount());
                if (++summaryCounter == 1) {
                    bysquareParams.setBigDecimal(Items.CLASSIFIED_TAX_CATEGORY1, a2);
                    bysquareParams.setBigDecimal(Items.TAX_EXCLUSIVE_AMOUNT1, b2);
                    bysquareParams.setBigDecimal(Items.TAX_AMOUNT1, c2);
                    continue;
                }
                if (summaryCounter == 2) {
                    bysquareParams.setBigDecimal(Items.CLASSIFIED_TAX_CATEGORY2, a2);
                    bysquareParams.setBigDecimal(Items.TAX_EXCLUSIVE_AMOUNT2, b2);
                    bysquareParams.setBigDecimal(Items.TAX_AMOUNT2, c2);
                    continue;
                }
                if (summaryCounter != 3) continue;
                bysquareParams.setBigDecimal(Items.CLASSIFIED_TAX_CATEGORY3, a2);
                bysquareParams.setBigDecimal(Items.TAX_EXCLUSIVE_AMOUNT3, b2);
                bysquareParams.setBigDecimal(Items.TAX_AMOUNT3, c2);
            }
        }
        if ((customerParty = invoice.getCustomerParty()) != null) {
            bysquareParams.setString(Items.CUSTOMER_PARTY_NAME, customerParty.getPartyName());
            bysquareParams.setString(Items.CUSTOMER_COMPANY_TAX_ID, customerParty.getCompanyTaxID());
            bysquareParams.setString(Items.CUSTOMER_COMPANY_VAT_ID, customerParty.getCompanyVATID());
            bysquareParams.setString(Items.CUSTOMER_COMPANY_REGISTER_ID, customerParty.getCompanyRegisterID());
            bysquareParams.setString(Items.CUSTOMER_PARTY_IDENTIFICATION, customerParty.getPartyIdentification());
        }
        if ((supplierParty = invoice.getSupplierParty()) != null) {
            Contact contact;
            bysquareParams.setString(Items.SUPPLIER_PARTY_NAME, supplierParty.getPartyName());
            bysquareParams.setString(Items.SUPPLIER_COMPANY_TAX_ID, supplierParty.getCompanyTaxID());
            bysquareParams.setString(Items.SUPPLIER_COMPANY_VAT_ID, supplierParty.getCompanyVATID());
            bysquareParams.setString(Items.SUPPLIER_COMPANY_REGISTER_ID, supplierParty.getCompanyRegisterID());
            PostalAddress postalAddress = supplierParty.getPostalAddress();
            if (postalAddress != null) {
                bysquareParams.setString(Items.SUPPLIER_POSTAL_ADDRESS_STREET_NAME, postalAddress.getStreetName());
                bysquareParams.setString(Items.SUPPLIER_POSTAL_ADDRESS_BUILDING_NUMBER, postalAddress.getBuildingNumber());
                bysquareParams.setString(Items.SUPPLIER_POSTAL_ADDRESS_CITY_NAME, postalAddress.getCityName());
                bysquareParams.setString(Items.SUPPLIER_POSTAL_ADDRESS_POSTAL_ZONE, postalAddress.getPostalZone());
                bysquareParams.setString(Items.SUPPLIER_POSTAL_ADDRESS_STATE, postalAddress.getState());
                bysquareParams.setString(Items.SUPPLIER_POSTAL_ADDRESS_COUNTRY, postalAddress.getCountry());
            }
            if ((contact = supplierParty.getContact()) != null) {
                bysquareParams.setString(Items.SUPPLIER_CONTACT_NAME, contact.getName());
                bysquareParams.setString(Items.SUPPLIER_CONTACT_TELEPHONE, contact.getTelephone());
                bysquareParams.setString(Items.SUPPLIER_CONTACT_EMAIL, contact.getEMail());
            }
        }
        return bysquareParams;
    }

    public static enum Items {
        INVOICE_ID,
        ISSUE_DATE,
        TAX_POINT_DATE,
        ORDER_ID,
        LOCAL_CURRENCY_CODE,
        FOREIGN_CURRENCY_CODE,
        CURR_RATE,
        REFERENCE_CURR_RATE,
        INVOICE_DESCRIPTION,
        NUMBER_OF_INVOICE_LINES,
        SUPPLIER_PARTY_NAME,
        SUPPLIER_COMPANY_TAX_ID,
        SUPPLIER_COMPANY_VAT_ID,
        SUPPLIER_COMPANY_REGISTER_ID,
        SUPPLIER_POSTAL_ADDRESS_STREET_NAME,
        SUPPLIER_POSTAL_ADDRESS_BUILDING_NUMBER,
        SUPPLIER_POSTAL_ADDRESS_CITY_NAME,
        SUPPLIER_POSTAL_ADDRESS_POSTAL_ZONE,
        SUPPLIER_POSTAL_ADDRESS_STATE,
        SUPPLIER_POSTAL_ADDRESS_COUNTRY,
        SUPPLIER_CONTACT_NAME,
        SUPPLIER_CONTACT_TELEPHONE,
        SUPPLIER_CONTACT_EMAIL,
        CUSTOMER_PARTY_NAME,
        CUSTOMER_COMPANY_TAX_ID,
        CUSTOMER_COMPANY_VAT_ID,
        CUSTOMER_COMPANY_REGISTER_ID,
        CUSTOMER_PARTY_IDENTIFICATION,
        CLASSIFIED_TAX_CATEGORY1,
        TAX_EXCLUSIVE_AMOUNT1,
        TAX_AMOUNT1,
        CLASSIFIED_TAX_CATEGORY2,
        TAX_EXCLUSIVE_AMOUNT2,
        TAX_AMOUNT2,
        CLASSIFIED_TAX_CATEGORY3,
        TAX_EXCLUSIVE_AMOUNT3,
        TAX_AMOUNT3,
        PAYABLE_ROUNDING_AMOUNT,
        PAID_DEPOSITS_AMOUNT,
        PAYMENT_MEAN;

    }
}

